local assets =
{
    Asset("ANIM", "anim/bluerose.zip"),
    Asset("ATLAS", "images/inventoryimages/bluerose.xml"),
    Asset("IMAGE", "images/inventoryimages/bluerose.tex"),
}

local prefabs =
{
}

local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("cutgrass")
    inst.AnimState:SetBuild("bluerose")
    inst.AnimState:PlayAnimation("idle")

    inst:AddTag("cattoy")
    inst:AddTag("vasedecoration")

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end

    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "bluerose"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/bluerose.xml"

    inst:AddComponent("stackable")
    inst.components.stackable.maxsize = 40

    inst:AddComponent("tradable")
    inst:AddComponent("vasedecoration")
    inst:AddComponent("inspectable")

    inst:AddComponent("fuel")
    inst.components.fuel.fuelvalue = TUNING.TINY_FUEL

    MakeSmallBurnable(inst, TUNING.TINY_BURNTIME)
    MakeSmallPropagator(inst)

    inst:AddComponent("edible")
    inst.components.edible.healthvalue = 2
    inst.components.edible.hungervalue = 2
    inst.components.edible.foodtype = FOODTYPE.VEGGIE
	
    return inst
end

if TUNING.LANG == 1 then
	STRINGS.NAMES.BLUEROSE = "Blue Rose"
	STRINGS.CHARACTERS.GENERIC.DESCRIBE.BLUEROSE = "The beautiful rose that shouldn't exist in this world."
else
	STRINGS.NAMES.BLUEROSE = "蓝色蔷薇"
	STRINGS.CHARACTERS.GENERIC.DESCRIBE.BLUEROSE = "不应存于此世的美丽蔷薇。"
end

return Prefab("bluerose", fn, assets, prefabs)
