local assets =
{ 
    Asset("ANIM", "anim/koishi_hat.zip"),
    Asset("ANIM", "anim/koishi_hat_swap.zip"), 

    Asset("ATLAS", "images/inventoryimages/koishi_hat.xml"),
    Asset("IMAGE", "images/inventoryimages/koishi_hat.tex"),
}

local prefabs = 
{
}

local function OnEquip(inst, owner) 
    owner.AnimState:OverrideSymbol("swap_hat", "koishi_hat_swap", "swap_hat")

    owner.AnimState:Show("HAT")
    owner.AnimState:Show("HAIR_HAT")
    owner.AnimState:Hide("HAIR_NOHAT")
    owner.AnimState:Hide("HAIR")

    if owner:HasTag("player") then
        owner.AnimState:Hide("HEAD")
        owner.AnimState:Show("HEAD_HAT")
    end
end

local function OnUnequip(inst, owner) 
    owner.AnimState:Hide("HAT")
    owner.AnimState:Hide("HAIR_HAT")
    owner.AnimState:Show("HAIR_NOHAT")
    owner.AnimState:Show("HAIR")

    if owner:HasTag("player") then
        owner.AnimState:Show("HEAD")
        owner.AnimState:Hide("HEAD_HAT")
    end
end

local function fn()

    local inst = CreateEntity()
    
    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("koishi_hat")
    inst.AnimState:SetBuild("koishi_hat")
    inst.AnimState:PlayAnimation("idle")

    inst:AddTag("hat")

    if not TheWorld.ismastersim then
        return inst
    end

    inst.entity:SetPristine()

    inst:AddComponent("inspectable")

    inst:AddComponent("tradable")

    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "koishi_hat"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/koishi_hat.xml"
	inst.components.inventoryitem.keepondeath = true
	
    inst:AddComponent("equippable")
    inst.components.equippable.equipslot = EQUIPSLOTS.HEAD
    inst.components.equippable:SetOnEquip(OnEquip)
    inst.components.equippable:SetOnUnequip(OnUnequip)
	
    MakeHauntableLaunch(inst)

	inst:AddComponent("waterproofer")
    inst.components.waterproofer:SetEffectiveness(0.7)
	
	inst:AddComponent("insulator")
    inst.components.insulator:SetInsulation(TUNING.INSULATION_LARGE)
	inst:AddComponent("armor")
	inst.components.armor:InitCondition(999999, .2 * TUNING.PW)
	if not inst.components.characterspecific then
    	inst:AddComponent("characterspecific")
	end

    inst.components.characterspecific:SetOwner("koishi")
    inst.components.characterspecific:SetStorable(true)
    inst.components.characterspecific:SetComment("这东西我拿不起.")
    return inst
end
if TUNING.LANG == 1 then
	STRINGS.NAMES.KOISHI_HAT = "Koishi's Hat"
	STRINGS.CHARACTERS.GENERIC.DESCRIBE.KOISHI_HAT = "My lovely hat ！"
else
	STRINGS.NAMES.KOISHI_HAT = "恋恋的帽子"
	STRINGS.CHARACTERS.GENERIC.DESCRIBE.KOISHI_HAT = "可爱帽子！"
end


return  Prefab("common/inventory/koishi_hat", fn, assets, prefabs)