local assets =
{
    Asset("ANIM", "anim/blue_rose.zip"),
}

local prefabs =
{
}
local names = {"f10"}
local ROSE_NAME = "rose"
local ROSE_CHANCE = 1

local function setflowertype(inst, name)
    if inst.animname == nil or (name ~= nil and inst.animname ~= name) then
        inst.animname = name or (math.random() < ROSE_CHANCE and ROSE_NAME or names[math.random(#names)])
        inst.AnimState:PlayAnimation(inst.animname)
        if inst.animname == ROSE_NAME then
            inst:AddTag("thorny")
		end
	end
end

local function onsave(inst, data)
    data.anim = inst.animname
end

local function onload(inst, data)
    setflowertype(inst, data ~= nil and data.anim or nil)
end

local function GetStatus(inst)
    return inst.animname == ROSE_NAME and "ROSE" or nil
end

local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddNetwork()

    inst.AnimState:SetBank("flowers")
    inst.AnimState:SetBuild("blue_rose")
    inst.AnimState:SetRayTestOnBB(true)

    inst:AddTag("flower")
    inst:AddTag("cattoy")

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end
	inst:DoTaskInTime(60, function()
		SpawnPrefab("small_puff").Transform:SetPosition(inst.Transform:GetWorldPosition())
		inst:Remove()
	end)
    inst:AddComponent("inspectable")
    inst.components.inspectable.getstatus = GetStatus

    if not POPULATING then
        setflowertype(inst)
    end
    --------SaveLoad
    inst.OnSave = onsave
    inst.OnLoad = onload

    return inst

end
if TUNING.LANG == 1 then
	STRINGS.NAMES.ROSE_BLUE = "Blue Rose"
	STRINGS.CHARACTERS.GENERIC.DESCRIBE.ROSE_BLUE = "Why is there a blue rose here?"
else
	STRINGS.NAMES.ROSE_BLUE = "蓝色蔷薇"
	STRINGS.CHARACTERS.GENERIC.DESCRIBE.ROSE_BLUE = "为什么这里会有一朵蓝色的蔷薇呢？"
end

return Prefab("rose_blue", fn, assets, prefabs)