local assets =
{
    Asset("ANIM", "anim/spell.zip"),
	Asset("ATLAS", "images/inventoryimages/spell_dream.xml"),    
	Asset("IMAGE", "images/inventoryimages/spell_dream.tex"),
}

local function canuse()
       return true
end

local function onfinished(inst)
	inst:Remove()
end

local function reading(staff, target, pos)
	local owner = staff.components.inventoryitem.owner
	if owner:HasTag("koishi") and not owner:HasTag("dreamed") then
		if TUNING.LANG == 1 then
			if owner.components.talker then
				owner.components.talker:Say("All your ancestors are watching you~", 3, false)
			end
		else
			if owner.components.talker then
				owner.components.talker:Say("你的祖先大人们在看着你哟~", 3, false)
			end
		end	
		staff.components.finiteuses:Use(1)
		owner.components.hunger:DoDelta(-20 + 10 * TUNING.PW)
		owner:AddTag("dreamed")
		local x, y, z = owner.Transform:GetWorldPosition()
		local ents = TheSim:FindEntities(x, y, z, 20)
		for k,v in pairs(ents) do
			if (TheNet:GetPVPEnabled() or not v:HasTag("player")) and
			not (v.components.freezable ~= nil and v.components.freezable:IsFrozen()) and
			not (v.components.pinnable ~= nil and v.components.pinnable:IsStuck()) and not v:HasTag("koishi") then
				if v.components.sleeper ~= nil then
					v.components.sleeper:AddSleepiness(10, 15)
					v:AddTag("dreaming")
					v:ListenForEvent("onwakeup", function()
						v:RemoveTag("dreaming")
					end)
				elseif v.components.grogginess ~= nil then
					v.components.grogginess:AddGrogginess(10, 15)
					v:AddTag("dreaming")
					v:ListenForEvent("onwakeup", function()
						v:RemoveTag("dreaming")
					end)
				end
			v:DoTaskInTime(5, function()
				if v:HasTag("dreaming") and v.components.health then
					v.components.health:DoDelta(-50 * TUNING.PW)
				end
				if v:HasTag("dreaming") and v.components.sanity then
					v.components.sanity:DoDelta(-50)
				end
				if v:HasTag("dreaming") and v:HasTag("epic") then
					local damage = -0.02 * v.components.health:GetMaxWithPenalty() * TUNING.PW
					v.components.health:DoDelta(damage)
				end
			end)
			v:DoTaskInTime(10, function()
				if v:HasTag("dreaming") and v.components.health then
					v.components.health:DoDelta(-50 * TUNING.PW)
				end
				if v:HasTag("dreaming") and v.components.sanity then
					v.components.sanity:DoDelta(-50)
				end
				if v:HasTag("dreaming") and v:HasTag("epic") then
					local damage = -0.02 * v.components.health:GetMaxWithPenalty() * TUNING.PW
					v.components.health:DoDelta(damage)
				end
			end)
			v:DoTaskInTime(14, function()
				if v:HasTag("dreaming") and v.components.health then
					v.components.health:DoDelta(-50 * TUNING.PW)
				end
				if v:HasTag("dreaming") and v.components.sanity then
					v.components.sanity:DoDelta(-50)
				end
				if v:HasTag("dreaming") and v:HasTag("epic") then
					local damage = -0.01 * v.components.health:GetMaxWithPenalty() * TUNING.PW
					v.components.health:DoDelta(damage)
				end
			end)
		end
		owner:DoTaskInTime(30, function()		
			owner:RemoveTag("dreamed")
		end)
		end
	else
		if TUNING.LANG == 1 then
			if owner.components.talker then
				owner.components.talker:Say("I cannot do that~", 3, false)
			end
		else
			if owner.components.talker then
				owner.components.talker:Say("现在还不行哦~", 3, false)
			end
		end
	end
end

local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("spell")
    inst.AnimState:SetBuild("spell")
    inst.AnimState:PlayAnimation("idle")

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end
	
	inst:AddComponent("finiteuses")
	inst.components.finiteuses:SetOnFinished(onfinished)	
	inst.components.finiteuses:SetMaxUses(3)
	inst.components.finiteuses:SetUses(3)
	
    inst:AddComponent("inventoryitem")

    inst:AddComponent("inspectable")
    inst:AddComponent("tradable")

    MakeSmallPropagator(inst)
	
	inst.components.inventoryitem.imagename = "spell_dream"    
	inst.components.inventoryitem.atlasname = "images/inventoryimages/spell_dream.xml"  
	
	inst:AddComponent("spellcaster")
	inst.components.spellcaster:SetSpellFn(reading)
    inst.components.spellcaster.CanCast = canuse
    inst.components.spellcaster.canusefrominventory = true
    return inst
end
if TUNING.LANG == 1 then
	STRINGS.NAMES.SPELL_DREAM = "Dream Sign「Ancestors are Watching You」"
	STRINGS.CHARACTERS.GENERIC.DESCRIBE.SPELL_DREAM = "Why do we still obey the spellcard rules in this world?"
	STRINGS.RECIPE_DESC.SPELL_DREAM = "夢符「ご先祖様\n が見ているぞ」" 
else
	STRINGS.NAMES.SPELL_DREAM = "梦符「先祖大人在看着你」"
	STRINGS.CHARACTERS.GENERIC.DESCRIBE.SPELL_DREAM = "为什么在这个世界里还要遵守符卡规则？"
	STRINGS.RECIPE_DESC.SPELL_DREAM = "夢符「ご先祖様\n が見ているぞ」" 
end

return Prefab("common/inventory/spell_dream", fn, assets, prefabs)
