local assets =
{
    Asset("ANIM", "anim/spell.zip"),
	Asset("ATLAS", "images/inventoryimages/spell_philosophy.xml"),    
	Asset("IMAGE", "images/inventoryimages/spell_philosophy.tex"),
}

local function canuse()
       return true
end

local function onfinished(inst)
	inst:Remove()
end

local function reading(staff, target, pos)
	local owner = staff.components.inventoryitem.owner
	if owner:HasTag("koishi") and not owner:HasTag("philosophy") then
		if TUNING.LANG == 1 then
			if owner.components.talker then
				owner.components.talker:Say("Reading people's minds only makes you depressed...There's nothing good about it!", 3, false)
			end
		else
			if owner.components.talker then
				owner.components.talker:Say("即使去看别人的內心，也只会沮丧罢了……不会发生任何好事的！", 3, false)
			end
		end	
		staff.components.finiteuses:Use(1)
		owner:AddTag("philosophy")
		owner.components.hunger:DoDelta(-25 + 10 * TUNING.PW)
		local x, y, z = owner.Transform:GetWorldPosition()
		local ents = TheSim:FindEntities(x, y, z, 10)
		for k,v in pairs(ents) do
			if (TheNet:GetPVPEnabled() or not v:HasTag("player")) and not v:HasTag("koishi") and
			not (v.components.freezable ~= nil and v.components.freezable:IsFrozen()) and
			not (v.components.pinnable ~= nil and v.components.pinnable:IsStuck()) then
				if v.components.hauntable ~= nil and v.components.health then
					v.components.hauntable:Panic(15)
					v.components.health.absorb = -0.25 * TUNING.PW
				elseif v.components.health then
					v.components.health.absorb = -0.4 * TUNING.PW
				end
				v:DoTaskInTime(15, function()
					if v.components.health then
						v.components.health.absorb = 0
					end					
				end)
			end
		end
		owner:DoTaskInTime(30, function()		
			owner:RemoveTag("philosophy")
		end)
	else
		if TUNING.LANG == 1 then
			if owner.components.talker then
				owner.components.talker:Say("I cannot do that~", 3, false)
			end
		else
			if owner.components.talker then
				owner.components.talker:Say("现在还不行哦~", 3, false)
			end
		end
	end
end

local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("spell")
    inst.AnimState:SetBuild("spell")
    inst.AnimState:PlayAnimation("idle")

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end
	
	inst:AddComponent("finiteuses")
	inst.components.finiteuses:SetOnFinished(onfinished)	
	inst.components.finiteuses:SetMaxUses(2)
	inst.components.finiteuses:SetUses(2)
	
    inst:AddComponent("inventoryitem")

    inst:AddComponent("inspectable")
    inst:AddComponent("tradable")

    MakeSmallPropagator(inst)
	
	inst.components.inventoryitem.imagename = "spell_philosophy"    
	inst.components.inventoryitem.atlasname = "images/inventoryimages/spell_philosophy.xml"  
	
	inst:AddComponent("spellcaster")
	inst.components.spellcaster:SetSpellFn(reading)
    inst.components.spellcaster.CanCast = canuse
    inst.components.spellcaster.canusefrominventory = true
    return inst
end
if TUNING.LANG == 1 then
	STRINGS.NAMES.SPELL_PHILOSOPHY = "「Philosophy of a Hated Person」"
	STRINGS.CHARACTERS.GENERIC.DESCRIBE.SPELL_PHILOSOPHY = "Why do we still obey the spellcard rules in this world?"
	STRINGS.RECIPE_DESC.SPELL_PHILOSOPHY = "「嫌われ者のフ\n ィロソフィ」" 
else
	STRINGS.NAMES.SPELL_PHILOSOPHY = "「被厌恶者的哲学」"
	STRINGS.CHARACTERS.GENERIC.DESCRIBE.SPELL_PHILOSOPHY = "为什么在这个世界里还要遵守符卡规则？"
	STRINGS.RECIPE_DESC.SPELL_PHILOSOPHY = "「嫌われ者のフ\n ィロソフィ」" 
end

return Prefab("common/inventory/spell_philosophy", fn, assets, prefabs)
