local assets =
{
    Asset("ANIM", "anim/spell.zip"),
	Asset("ATLAS", "images/inventoryimages/spell_rose.xml"),    
	Asset("IMAGE", "images/inventoryimages/spell_rose.tex"),
}

local function canuse()
       return true
end

local function onfinished(inst)
	inst:Remove()
end

local function reading(staff, target, pos)
	local owner = staff.components.inventoryitem.owner
	if owner:HasTag("koishi") and not owner:HasTag("rosed") then
		if TUNING.LANG == 1 then
			if owner.components.talker then
				owner.components.talker:Say("The danmaku that lurk in your subconscious are danmaku that my sister has never seen! ", 3, false)
			end
		else
			if owner.components.talker then
				owner.components.talker:Say("潜藏在无意识中的弹幕是连姐姐也没见过的弹幕哦！", 3, false)
			end
		end	
		staff.components.finiteuses:Use(1)
		owner.components.hunger:DoDelta(-50)
		owner:AddTag("rosed")
		local x, y, z = owner.Transform:GetWorldPosition()
		local ents = TheSim:FindEntities(x, y, z, 15)
		for k,v in pairs(ents) do
			if (TheNet:GetPVPEnabled() or not v:HasTag("player")) and not v:HasTag("koishi") then
				if v.components.combat then
					v.components.combat:GetAttacked(owner, 1000 * TUNING.PW)
				end
				if v: HasTag("epic") then
					v.components.health:DoDelta(-0.25 * v.components.health:GetMaxWithPenalty() * TUNING.PW)
				end
			end
		end
		SpawnPrefab("groundpoundring_fx").Transform:SetPosition(x, y, z, 0)
		local a = 2
		local b = 6
		local c = 11
		local d = 16
		repeat 
			local e = a-1
			for var = 0, 2, 1 do
				local u = (var * 0.5236 + e * 0.1)
				if TheWorld.Map:IsAboveGroundAtPoint(x+(0.75 * math.sin(u) * a), y, z+(0.75 * math.cos(u) * a)) then
					SpawnPrefab("rose_red").Transform:SetPosition(x+(0.75 * math.sin(u) * a), y, z+(0.75 * math.cos(u) * a), 0)
					SpawnPrefab("small_puff").Transform:SetPosition(x+(0.75 * math.sin(u) * a), y, z+(0.75 * math.cos(u) * a), 0)
				end
			end
			for var = 3, 5, 1 do
				local u = (var * 0.5236 + e * 0.1)
				if TheWorld.Map:IsAboveGroundAtPoint(x+(0.75 * math.sin(u) * a), y, z+(0.75 * math.cos(u) * a)) then
					SpawnPrefab("rose_blue").Transform:SetPosition(x+(0.75 * math.sin(u) * a), y, z+(0.75 * math.cos(u) * a), 0)
					SpawnPrefab("small_puff").Transform:SetPosition(x+(0.75 * math.sin(u) * a), y, z+(0.75 * math.cos(u) * a), 0)
				end
			end
			for var = 6, 8, 1 do
				local u = (var * 0.5236 + e * 0.1)
				if TheWorld.Map:IsAboveGroundAtPoint(x+(0.75 * math.sin(u) * a), y, z+(0.75 * math.cos(u) * a)) then
					SpawnPrefab("rose_red").Transform:SetPosition(x+(0.75 * math.sin(u) * a), y, z+(0.75 * math.cos(u) * a), 0)
					SpawnPrefab("small_puff").Transform:SetPosition(x+(0.75 * math.sin(u) * a), y, z+(0.75 * math.cos(u) * a), 0)
				end
			end
			for var = 9, 11, 1 do
				local u = (var * 0.5236 + e * 0.1)
				if TheWorld.Map:IsAboveGroundAtPoint(x+(0.75 * math.sin(u) * a), y, z+(0.75 * math.cos(u) * a)) then
					SpawnPrefab("rose_blue").Transform:SetPosition(x+(0.75 * math.sin(u) * a), y, z+(0.75 * math.cos(u) * a), 0)
					SpawnPrefab("small_puff").Transform:SetPosition(x+(0.75 * math.sin(u) * a), y, z+(0.75 * math.cos(u) * a), 0)
				end
			end
			a = a + 1.5
		until (a == 6.5)
		owner:DoTaskInTime(0.3, function()				
		repeat 
			local e = b - 6
			for var = 0, 2, 1 do
				local u = (var * 0.5236 - e * 0.1 + 0.2618)
				if TheWorld.Map:IsAboveGroundAtPoint(x+(0.75 * math.sin(u) * b), y, z+(0.75 * math.cos(u) * b)) then
					SpawnPrefab("rose_blue").Transform:SetPosition(x+(0.75 * math.sin(u) * b), y, z+(0.75 * math.cos(u) * b), 0)
					SpawnPrefab("small_puff").Transform:SetPosition(x+(0.75 * math.sin(u) * b), y, z+(0.75 * math.cos(u) * b), 0)
				end
			end
			for var = 3, 5, 1 do
				local u = (var * 0.5236 -e * 0.1 + 0.2618)
				if TheWorld.Map:IsAboveGroundAtPoint(x+(0.75 * math.sin(u) * b), y, z+(0.75 * math.cos(u) * b)) then
					SpawnPrefab("rose_red").Transform:SetPosition(x+(0.75 * math.sin(u) * b), y, z+(0.75 * math.cos(u) * b), 0)
					SpawnPrefab("small_puff").Transform:SetPosition(x+(0.75 * math.sin(u) * b), y, z+(0.75 * math.cos(u) * b), 0)
				end
			end
			for var = 6, 8, 1 do
				local u = (var * 0.5236 -e * 0.1 + 0.2618)
				if TheWorld.Map:IsAboveGroundAtPoint(x+(0.75 * math.sin(u) * b), y, z+(0.75 * math.cos(u) * b)) then
					SpawnPrefab("rose_blue").Transform:SetPosition(x+(0.75 * math.sin(u) * b), y, z+(0.75 * math.cos(u) * b), 0)
					SpawnPrefab("small_puff").Transform:SetPosition(x+(0.75 * math.sin(u) * b), y, z+(0.75 * math.cos(u) * b), 0)
				end
			end
			for var = 9, 11, 1 do
				local u = (var * 0.5236 -e * 0.1 + 0.2618)
				if TheWorld.Map:IsAboveGroundAtPoint(x+(0.75 * math.sin(u) * b), y, z+(0.75 * math.cos(u) * b)) then
					SpawnPrefab("rose_red").Transform:SetPosition(x+(0.75 * math.sin(u) * b), y, z+(0.75 * math.cos(u) * b), 0)
					SpawnPrefab("small_puff").Transform:SetPosition(x+(0.75 * math.sin(u) * b), y, z+(0.75 * math.cos(u) * b), 0)
				end
			end
			b = b + 1
		until (b == 11)
		end)
		owner:DoTaskInTime(0.6, function()			
		repeat 
			local e = c - 11
			for var = 0, 2, 1 do
				local u = (var * 0.5236 + e * 0.1)
				if TheWorld.Map:IsAboveGroundAtPoint(x+(0.75 * math.sin(u) * c), y, z+(0.75 * math.cos(u) * c)) then
					SpawnPrefab("rose_red").Transform:SetPosition(x+(0.75 * math.sin(u) * c), y, z+(0.75 * math.cos(u) * c), 0)
					SpawnPrefab("small_puff").Transform:SetPosition(x+(0.75 * math.sin(u) * c), y, z+(0.75 * math.cos(u) * c), 0)
				end
			end
			for var = 3, 5, 1 do
				local u = (var * 0.5236 + e * 0.1)
				if TheWorld.Map:IsAboveGroundAtPoint(x+(0.75 * math.sin(u) * c), y, z+(0.75 * math.cos(u) * c)) then
					SpawnPrefab("rose_blue").Transform:SetPosition(x+(0.75 * math.sin(u) * c), y, z+(0.75 * math.cos(u) * c), 0)
					SpawnPrefab("small_puff").Transform:SetPosition(x+(0.75 * math.sin(u) * c), y, z+(0.75 * math.cos(u) * c), 0)
				end
			end
			for var = 6, 8, 1 do
				local u = (var * 0.5236 + e * 0.1)
				if TheWorld.Map:IsAboveGroundAtPoint(x+(0.75 * math.sin(u) * c), y, z+(0.75 * math.cos(u) * c)) then
					SpawnPrefab("rose_red").Transform:SetPosition(x+(0.75 * math.sin(u) * c), y, z+(0.75 * math.cos(u) * c), 0)
					SpawnPrefab("small_puff").Transform:SetPosition(x+(0.75 * math.sin(u) * c), y, z+(0.75 * math.cos(u) * c), 0)
				end
			end
			for var = 9, 11, 1 do
				local u = (var * 0.5236 + e * 0.1)
				if TheWorld.Map:IsAboveGroundAtPoint(x+(0.75 * math.sin(u) * c), y, z+(0.75 * math.cos(u) * c)) then
					SpawnPrefab("rose_blue").Transform:SetPosition(x+(0.75 * math.sin(u) * c), y, z+(0.75 * math.cos(u) * c), 0)
					SpawnPrefab("small_puff").Transform:SetPosition(x+(0.75 * math.sin(u) * c), y, z+(0.75 * math.cos(u) * c), 0)
				end
			end	
			c = c + 1
		until (c == 16)
		end)
		owner:DoTaskInTime(0.9, function()
		repeat 
			local e = d - 16
			for var = 0, 2, 1 do
				local u = (var * 0.5236 -e * 0.1 + 0.2618)
				if TheWorld.Map:IsAboveGroundAtPoint(x+(0.75 * math.sin(u) * d), y, z+(0.75 * math.cos(u) * d)) then
					SpawnPrefab("rose_blue").Transform:SetPosition(x+(0.75 * math.sin(u) * d), y, z+(0.75 * math.cos(u) * d), 0)
					SpawnPrefab("small_puff").Transform:SetPosition(x+(0.75 * math.sin(u) * d), y, z+(0.75 * math.cos(u) * d), 0)
				end
			end
			for var = 3, 5, 1 do
				local u = (var * 0.5236 -e * 0.1 + 0.2618)
				if TheWorld.Map:IsAboveGroundAtPoint(x+(0.75 * math.sin(u) * d), y, z+(0.75 * math.cos(u) * d)) then
					SpawnPrefab("rose_red").Transform:SetPosition(x+(0.75 * math.sin(u) * d), y, z+(0.75 * math.cos(u) * d), 0)
					SpawnPrefab("small_puff").Transform:SetPosition(x+(0.75 * math.sin(u) * d), y, z+(0.75 * math.cos(u) * d), 0)
				end
			end
			for var = 6, 8, 1 do
				local u = (var * 0.5236 -e * 0.1 + 0.2618)
				if TheWorld.Map:IsAboveGroundAtPoint(x+(0.75 * math.sin(u) * d), y, z+(0.75 * math.cos(u) * d)) then
					SpawnPrefab("rose_blue").Transform:SetPosition(x+(0.75 * math.sin(u) * d), y, z+(0.75 * math.cos(u) * d), 0)
					SpawnPrefab("small_puff").Transform:SetPosition(x+(0.75 * math.sin(u) * d), y, z+(0.75 * math.cos(u) * d), 0)
				end
			end
			for var = 9, 11, 1 do
				local u = (var * 0.5236 -e * 0.1 + 0.2618)
				if TheWorld.Map:IsAboveGroundAtPoint(x+(0.75 * math.sin(u) * d), y, z+(0.75 * math.cos(u) * d)) then
					SpawnPrefab("rose_red").Transform:SetPosition(x+(0.75 * math.sin(u) * d), y, z+(0.75 * math.cos(u) * d), 0)
					SpawnPrefab("small_puff").Transform:SetPosition(x+(0.75 * math.sin(u) * d), y, z+(0.75 * math.cos(u) * d), 0)
				end
			end		
			d = d + 1
		until (d == 21)
		end)
		owner:DoTaskInTime(120, function()		
			owner:RemoveTag("rosed")
		end)
	else
		if TUNING.LANG == 1 then
			if owner.components.talker then
				owner.components.talker:Say("I cannot do that~", 3, false)
			end
		else
			if owner.components.talker then
				owner.components.talker:Say("现在还不行哦~", 3, false)
			end
		end
	end
end

local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("spell")
    inst.AnimState:SetBuild("spell")
    inst.AnimState:PlayAnimation("idle")

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end
	
	inst:AddComponent("finiteuses")
	inst.components.finiteuses:SetOnFinished(onfinished)	
	inst.components.finiteuses:SetMaxUses(1)
	inst.components.finiteuses:SetUses(1)
	
    inst:AddComponent("inventoryitem")

    inst:AddComponent("inspectable")
    inst:AddComponent("tradable")

    MakeSmallPropagator(inst)
	
	inst.components.inventoryitem.imagename = "spell_rose"    
	inst.components.inventoryitem.atlasname = "images/inventoryimages/spell_rose.xml"  
	
	inst:AddComponent("spellcaster")
	inst.components.spellcaster:SetSpellFn(reading)
    inst.components.spellcaster.CanCast = canuse
    inst.components.spellcaster.canusefrominventory = true
    return inst
end
if TUNING.LANG == 1 then
	STRINGS.NAMES.SPELL_ROSE = "「Subterranean Rose」"
	STRINGS.CHARACTERS.GENERIC.DESCRIBE.SPELL_ROSE = "Why do we still obey the spellcard rules in this world?"
	STRINGS.RECIPE_DESC.SPELL_ROSE = "「サブタレイニ\n アンローズ」" 
else
	STRINGS.NAMES.SPELL_ROSE = "「Subterranean Rose」"
	STRINGS.CHARACTERS.GENERIC.DESCRIBE.SPELL_ROSE = "为什么在这个世界里还要遵守符卡规则？"
	STRINGS.RECIPE_DESC.SPELL_ROSE = "「サブタレイニ\n アンローズ」" 
end

return Prefab("common/inventory/spell_rose", fn, assets, prefabs)
