local assets =
{ 
    Asset("ANIM", "anim/third_eye.zip"),
	--Asset("ANIM", "anim/third_eye_swap.zip"), 

    Asset("ATLAS", "images/inventoryimages/third_eye.xml"),
    Asset("IMAGE", "images/inventoryimages/third_eye.tex"),
}

local prefabs = 
{
}

local function OnAttacked(owner, data)
    owner.SoundEmitter:PlaySound("dontstarve/wilson/hit_scalemail")
    if data.attacker ~= nil and owner:HasTag("koishi") then
		local pt1 = data.attacker:GetPosition()
        local pt2 = owner:GetPosition()
		if data.attacker.components.combat then
			data.attacker.components.combat:GetAttacked(owner, 10 * (TUNING.PW)^3)
			data.attacker.Transform:SetPosition((pt1.x-pt2.x)*0.3+pt1.x, pt1.y, (pt1.z-pt2.z)*0.3+pt1.z)
		end
    end
end

local function OnEquip(inst, owner) 
    owner.AnimState:OverrideSymbol("swap_body", "third_eye", "swap_body")
	inst:ListenForEvent("attacked", OnAttacked, owner)
end

local function OnUnequip(inst, owner) 
    owner.AnimState:ClearOverrideSymbol("swap_body")
end

local function unconscious(inst)
	local owner = inst.components.inventoryitem.owner
	if inst:HasTag("shift") and TUNING.SYS == 0 then
		if owner:HasTag("superego") then
			if TUNING.LANG == 1 then
				owner.components.talker:Say("Instinct「Release of the Id」!", 3, false)
			else
				owner.components.talker:Say("本能「本我的解放」!", 3, false)
			end
			owner.SoundEmitter:PlaySound("dontstarve/common/staff_blink")
			owner:AddTag("id")
			owner:RemoveTag("superego")
			inst:RemoveTag("shift")
		else
			if TUNING.LANG == 1 then
				owner.components.talker:Say("Suppression「Super-Ego」!", 3, false)
			else
				owner.components.talker:Say("抑制「Super-Ego」!", 3, false)
			end
			owner.SoundEmitter:PlaySound("dontstarve/common/staff_blink") 
			owner:AddTag("superego")
			owner:RemoveTag("id")
			inst:RemoveTag("shift")
		end
		inst:DoTaskInTime(10, function()
			inst:AddTag("shift")
		end)
	else
		if TUNING.LANG == 1 then
			owner.components.talker:Say("I cannot do that~", 3, false)
		else
			owner.components.talker:Say("现在还不行哦~", 3, false)
		end
	end
	if TUNING.SYS == 1 then
		if not owner:HasTag("invsb") then
			owner:AddTag("invsb")
			if TUNING.LANG == 1 then
				owner.components.talker:Say("Eheheh, now no one can discover me now~", 3, false)
			else
				owner.components.talker:Say("嘿嘿嘿，现在谁也发现不了我了~", 3, false)
			end			
		else
			owner:RemoveTag("invsb")
			if TUNING.LANG == 1 then
				owner.components.talker:Say("Koishi is back~", 3, false)
			else
				owner.components.talker:Say("恋恋回来了~", 3, false)
			end	
		end
	end
	inst.components.useableitem.inuse = false
end

local function fn()

    local inst = CreateEntity()
    
    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("third_eye")
    inst.AnimState:SetBuild("third_eye")
    inst.AnimState:PlayAnimation("idle")

    inst:AddTag("third_eye")

    if not TheWorld.ismastersim then
        return inst
    end 

    inst.entity:SetPristine()

    inst:AddComponent("inspectable")

    inst:AddComponent("tradable")

    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "third_eye"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/third_eye.xml"
	inst.components.inventoryitem.keepondeath = true
	
    inst:AddComponent("equippable")
    inst.components.equippable.equipslot = EQUIPSLOTS.BODY
    inst.components.equippable:SetOnEquip(OnEquip)
    inst.components.equippable:SetOnUnequip(OnUnequip)
	
    MakeHauntableLaunch(inst)
	
	inst:AddComponent("insulator")
    inst.components.insulator:SetInsulation(TUNING.INSULATION_SMALL)

	inst:AddComponent("useableitem")
    inst.components.useableitem:SetOnUseFn(unconscious)
	inst:AddTag("shift")
	
	if not inst.components.characterspecific then
    	inst:AddComponent("characterspecific")
	end

    inst.components.characterspecific:SetOwner("koishi")
    inst.components.characterspecific:SetStorable(true)
    inst.components.characterspecific:SetComment("这东西我拿不起.")
    return inst
end
if TUNING.LANG == 1 then
	STRINGS.NAMES.THIRD_EYE = "Koishi's 3rd_eye"
	STRINGS.CHARACTERS.GENERIC.DESCRIBE.THIRD_EYE = "My lovely 3rd eye ！"
else
	STRINGS.NAMES.THIRD_EYE = "恋恋的第三只眼"
	STRINGS.CHARACTERS.GENERIC.DESCRIBE.THIRD_EYE = "第三只眼！"
end


return  Prefab("common/inventory/third_eye", fn, assets, prefabs)