PrefabFiles = {
	"sat",
	"petrabbit",
	"petbeefalo",
	"petkoalefant",
	"pettallbird",
}

Assets = {
    Asset( "IMAGE", "images/saveslot_portraits/sat.tex" ),
    Asset( "ATLAS", "images/saveslot_portraits/sat.xml" ),

    Asset( "IMAGE", "images/selectscreen_portraits/sat.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/sat.xml" ),

    Asset( "IMAGE", "images/selectscreen_portraits/sat_silho.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/sat_silho.xml" ),

    Asset( "IMAGE", "bigportraits/sat.tex" ),
    Asset( "ATLAS", "bigportraits/sat.xml" ),
	
	Asset("IMAGE", "images/saticon.tex"),
    Asset("ATLAS", "images/saticon.xml"),
	
	Asset("IMAGE", "images/petbeefaloicon.tex"),
	Asset("ATLAS", "images/petbeefaloicon.xml"),
	
	Asset("IMAGE", "images/petkoalefanticon.tex"),
	Asset("ATLAS", "images/petkoalefanticon.xml"),
	
	Asset("IMAGE", "images/pettallbirdicon.tex"),
	Asset("ATLAS", "images/pettallbirdicon.xml"),
	
	Asset("SOUNDPACKAGE", "sound/sat.fev"),
	Asset("SOUND", "sound/sat.fsb"),
}
-- ICONS MINIMAP SAT+PETS
AddMinimapAtlas("images/saticon.xml")
AddMinimapAtlas("images/petbeefaloicon.xml")
AddMinimapAtlas("images/petkoalefanticon.xml")
AddMinimapAtlas("images/pettallbirdicon.xml")



-- strings! Any "WOD" below would have to be replaced by the prefab name of your character.

-- The character select screen lines
-- note: these are lower-case character name
GLOBAL.STRINGS.CHARACTER_TITLES.sat = "  "
GLOBAL.STRINGS.CHARACTER_NAMES.sat = "Satori"  -- Note! This line is especially important as some parts of the game require
                                            -- the character to have a valid name.
GLOBAL.STRINGS.CHARACTER_DESCRIPTIONS.sat = "*  \n*   ϲ  \n*  ج     ج "
GLOBAL.STRINGS.CHARACTER_QUOTES.sat = "\"  ֻ  ǰ  û       \""

-- You can also add any kind of custom dialogue that you would like. Don't forget to make
-- categores that don't exist yet using = {}
-- note: these are UPPER-CASE charcacter name

local require = GLOBAL.require 
local STRINGS = GLOBAL.STRINGS
 
STRINGS.CHARACTERS.SAT=require "speech_sat"

-- Let the game know Wod is a male, for proper pronouns during the end-game sequence.
-- Possible genders here are MALE, FEMALE, or ROBOT
table.insert(GLOBAL.CHARACTER_GENDERS.FEMALE, "sat")
AddModCharacter("sat")

------------------MURDER
local ACTIONS = GLOBAL.ACTIONS
-------------------------------------
--OverWrite Satori Actions to Lose Sanity 

-- Murder -> IF SAT MURDER RABBIT or BIRDS lose sanity
ACTIONS.MURDER.fn = function(act)
	
    local murdered = act.invobject or act.target
	-- If player = Sat 
	if act.doer.prefab == "sat" then 
		-- If sat murder rabbit or birds
		if  murdered.prefab == "rabbit" or murdered.prefab == "crow" or murdered.prefab == "robin"	or murdered.prefab == "robin_winter" then
			act.doer.components.sanity:DoDelta(-3)
			act.doer.components.talker:Say(" , ,Ϊ        ǿ ʳ    .")
		end
	end
    if murdered and murdered.components.health then  
        murdered.components.inventoryitem:RemoveFromOwner(true)

        if murdered.components.health.murdersound then
            act.doer.SoundEmitter:PlaySound(murdered.components.health.murdersound)
        end

        local stacksize = 1
        if murdered.components.stackable then
            stacksize = murdered.components.stackable.stacksize
        end
        if murdered.components.lootdropper then
            for i = 1, stacksize do
                local loots = murdered.components.lootdropper:GenerateLoot()
                for k, v in pairs(loots) do
					-- It's necessary to use GLOBAL with SpawnPrefab
                    local loot = GLOBAL.SpawnPrefab(v)
                    act.doer.components.inventory:GiveItem(loot)
                end      
            end
        end
		
        act.doer:PushEvent("killed", {victim = murdered})
        murdered:Remove() 

        return true
    end
end

-- Murder -> IF SAT COOK RABBIT or BIRDS loses sanity
ACTIONS.COOK.fn = function(act)
	if act.target.components.cooker then
	    local ingredient = act.doer.components.inventory:RemoveItem(act.invobject)
		-- If player = Sat 
		if act.doer.prefab == "sat" then 
			-- If sat cook rabbit or birds
			if  ingredient.prefab == "rabbit" or ingredient.prefab == "crow" or ingredient.prefab == "robin" or ingredient.prefab == "robin_winter" then
				act.doer.components.sanity:DoDelta(-10)
				act.doer.components.talker:Say("     һ     ǿ ʳ   . . .")
			end
		end	
	    
        if ingredient.components.health and ingredient.components.combat then
            act.doer:PushEvent("killed", {victim = ingredient})
        end
        
	    local product = act.target.components.cooker:CookItem(ingredient, act.doer)
	    if product then											-- Is necessary use GLOBAL with Vector3
	        act.doer.components.inventory:GiveItem(product,nil, GLOBAL.Vector3(TheSim:GetScreenPos(act.target.Transform:GetWorldPosition()) ))
	        return true
	    end
    elseif act.target.components.stewer then
		act.target.components.stewer:StartCooking()
		return true
    end
end

---------------------STAYCOMAND-------------------
ACTIONS.STAYORDER = GLOBAL.Action(2, true, true)
ACTIONS.STAYORDER.fn = function(act)
	local targ = act.target
		if targ and targ.components.staycommand then
			act.doer.components.locomotor:Stop()
			act.doer.components.talker:Say("     һ  .")
			targ.components.staycommand:SetStaying(true)
			targ.components.staycommand:RememberStayPos("stayspot", GLOBAL.Point(targ.Transform:GetWorldPosition())) 
		return true
		end
	end
ACTIONS.STAYORDER.str = STRINGS.ACTIONS.STAYORDER
ACTIONS.STAYORDER.id = "STAYORDER"
ACTIONS.STAYORDER_CANCEL = GLOBAL.Action(2, true, true)
ACTIONS.STAYORDER_CANCEL.fn = function(act)
	local targ = act.target
	if targ and targ.components.staycommand then
	act.doer.components.locomotor:Stop()
		act.doer.components.talker:Say("   .")
		targ.components.staycommand:SetStaying(false)
		return true
	end
end
ACTIONS.STAYORDER_CANCEL.str = STRINGS.ACTIONS.STAYORDER_CANCEL
ACTIONS.STAYORDER_CANCEL.id = "STAYORDER_CANCEL"

STRINGS.ACTIONS.STAYORDER = "    "
STRINGS.ACTIONS.STAYORDER_CANCEL = "    "


--------------REPAIR SCRIPT DESCRIPTION
GLOBAL.require "repairabledescriptionfix"
AddPrefabPostInit("maxwellintro", ModMaxwellIntro)
--------------CHANGE INTRO

local function ModMaxwellIntro(inst)

	
	if GLOBAL.GetPlayer().prefab == "sat" then
	inst.components.maxwelltalker.speeches.SANDBOX_1 =
        {
            appearsound = "dontstarve/maxwell/disappear",
	    voice = "dontstarve/maxwell/talk_LP",
		appearanim = "appear",
		idleanim= "idle",
		dialogpreanim = "dialog_pre",
		dialoganim="dial_loop",
		dialogpostanim = "dialog_pst",
		disappearanim = "disappear",
            disableplayer = true,
            skippable = false,
            {
                string = "ι !   ,    ȥ ״ ̬   ,",
                wait = 3,
                anim = nil,
                sound = nil,
            },
            {
                string = "                 Щ   !",
                wait = 4,
                anim = nil,
                sound = nil,
            },
		}
	end
end

local function ExtraSat(inst)
	if GLOBAL.GetPlayer().prefab == "sat" and  GetModConfigData("Music") == "sat" then
		GLOBAL.GetPlayer().Musictheme = "sat"
	else 
		GLOBAL.GetPlayer().Musictheme = "not"
	end
	-- COMPATIBILITY WITH MOD - Always On Status by Kiopho
	for i, moddir in ipairs(GLOBAL.KnownModIndex:GetModsToLoad()) do
		if GLOBAL.KnownModIndex:GetModInfo(moddir).name == "Always On Status" then 
			local switch = GLOBAL.require "components/switch"
			inst:AddComponent("switch")
		end  
	end
	------------------------------------------------------
end

AddPrefabPostInit("maxwellintro", ModMaxwellIntro)
AddPrefabPostInit("sat", ExtraSat)
