require "behaviours/chattynode"

local SEE_PLAYER_DIST = 5




local BirdBrain = Class(Brain, function(self, inst)
    Brain._ctor(self, inst)
end)



local function ShouldFlyAway(inst)
    local busy = inst.sg:HasStateTag("sleeping") or inst.sg:HasStateTag("busy") or inst.sg:HasStateTag("flying")
    if not busy then
        local threat = FindEntity(inst, 5, nil, nil, {'notarget'}, {'player', 'monster', 'scarytoprey'})
        return threat ~= nil or GetClock():IsNight()
    end
end

local function FlyAway(inst)
    inst:PushEvent("flyaway")
end

function BirdBrain:OnStart()
    local clock = GetClock()
    if GetPlayer().prefab ~= "sat" then 
		if SEASONS.AUTUMN then 
		--************ D  L  C *********--
			local root = PriorityNode(
			{
				IfNode(function() return ShouldFlyAway(self.inst) end, "Threat Near",
					ActionNode(function() return FlyAway(self.inst) end)),
				EventNode(self.inst, "threatnear", 
					ActionNode(function() return FlyAway(self.inst) end)),
				EventNode(self.inst, "gohome", 
					ActionNode(function() return FlyAway(self.inst) end)),
			}, .25)		
			self.bt = BT(self.inst, root)
		else
			local root = PriorityNode(
			{
				IfNode(function() return ShouldFlyAway(self.inst) end, "Threat Near",
					ActionNode(function() return FlyAway(self.inst) end)),
				EventNode(self.inst, "gohome", 
					ActionNode(function() return FlyAway(self.inst) end)),
			}, .25)		
			self.bt = BT(self.inst, root)
		end
	else
		-- Behaviour with Satori
		if SEASONS.AUTUMN then 
		--************ D  L  C *********--
			local root = PriorityNode(
			{
				WhileNode(function()
					if self.inst.components.health.currenthealth < self.inst.components.health.maxhealth then
						-- SAT TALK when bird is hurt - > FlyAway
						if self.inst.prefab == "crow" then
							self.inst.components.talker:Say(" ѽ ѽ ѽ !")
						else
							self.inst.components.talker:Say("   !")
						end
						return true 
					else
						return false
					end
				end, "die",
					ActionNode(function() return FlyAway(self.inst) end)),
					EventNode(self.inst, "threatnear", 
						ActionNode(function() return FlyAway(self.inst) end)),
					EventNode(self.inst, "gohome", 
						ActionNode(function() return FlyAway(self.inst) end)),
			}, .25)		
			self.bt = BT(self.inst, root)
		else
			local root = PriorityNode(
			{
				WhileNode(function()
					if self.inst.components.health.currenthealth < self.inst.components.health.maxhealth then
						-- SAT TALK when bird is hurt - > FlyAway
						if self.inst.prefab == "crow" then
							self.inst.components.talker:Say(" ѽ ѽ ѽ !")
						else
							self.inst.components.talker:Say("   !")
						end
						return true 
					else
						return false
					end
				end, "die",
					ActionNode(function() return FlyAway(self.inst) end)),
					EventNode(self.inst, "gohome", 
						ActionNode(function() return FlyAway(self.inst) end)),
			}, .25)		
			self.bt = BT(self.inst, root)
		end	
	end		
end

return BirdBrain