require "behaviours/wander"
require "behaviours/faceentity"
require "behaviours/chaseandattack"
require "behaviours/panic"
require "behaviours/follow"
require "behaviours/attackwall"
require "behaviours/chattynode"
require "behaviours/runaway"
require "behaviours/standstill"
--require "behaviours/doaction"

local STOP_RUN_DIST = 10
local SEE_PLAYER_DIST = 5
local WANDER_DIST_DAY = 5
local WANDER_DIST_NIGHT = 20
local START_FACE_DIST = 4
local KEEP_FACE_DIST = 6

local MAX_CHASE_TIME = 6

local MIN_FOLLOW_DIST = 1
local TARGET_FOLLOW_DIST = 5
local MAX_FOLLOW_DIST = 5

-- SAT TALK
local PETBEEFALO_TALK_SAT_WANDER = {"   һ   .","   ,    һ  ."," ţ Ⱥ ͬ  .","    .","    Ч  .","   Ұ ţ ,    ţ Ⱥ ."}
local PETBEEFALO_TALK_SAT_WANDER_STAY = {"     ."}
local PETBEEFALO_TALK_SAT_FOLLOWHAPPY = {" ż !"}
local PETBEEFALO_TALK_SAT_HURT = { "    !"}
local PETBEEFALO_TALK_SAT_HURT_HUNGRY = { "    !","  Ҫ ʳ  !"}
local PETBEEFALO_TALK_SAT_FOLLOWHUNGRY = {" Ҫ   !","    ,       һ  !"}
local PETBEEFALO_TALK_SAT_ATTACK = {"     !","   !","  ȥ !"}
local PETBEEFALO_TALK_SAT_FOLLOWANGRY = {"û       !"}


local function GetWanderDistFn(inst)
    if GetClock() and not GetClock():IsDay() then
        return WANDER_DIST_NIGHT
    else
        return WANDER_DIST_DAY
    end
end

local BeefaloBrain = Class(Brain, function(self, inst)
    Brain._ctor(self, inst)
end)

function BeefaloBrain:OnStart()
    local root = PriorityNode(
    {	-- On fire
        WhileNode( function() return self.inst.components.health.takingfiredamage end, "OnFire", Panic(self.inst)),
		-- Attack Wall
		IfNode( function() return self.inst.components.combat.target ~= nil end, "hastarget", AttackWall(self.inst)),
		-- Chase and attack 
		--** Stop attacking if satori is far
		WhileNode(function()
				local player = GetPlayer()
				local bf = Point(self.inst.Transform:GetWorldPosition())
                local pl = Point(player.Transform:GetWorldPosition())
				local dist = distsq(pl, bf)
				--  PETBEEFALO if it is stay but SAT is near(500) , it will attack and it will be in follow
				if dist < 400 and self.inst.components.staycommand:IsCurrentlyStaying() == true and self.inst.components.combat.target ~= nil then
					self.inst.components.staycommand:SetStaying(false)
				end
				if self.inst.components.combat.target ~= nil == self.inst.components.staycommand:IsCurrentlyStaying() == true then
					-- ATTACK IN STAY MODE
					return true
				end			
				if dist < 400 then
				 	return true 
				else
					-- IF SAT RUN AWAY , PETBEEFALO leave combat
					self.inst.components.combat.target = nil
					return false
				end
			end, "die",
			ChattyNode(self.inst,PETBEEFALO_TALK_SAT_ATTACK,
				ChaseAndAttack(self.inst, MAX_CHASE_TIME))),
		-- RunAway
		--** Pet leaves if it is very hungry	
		WhileNode(function()
				local player = GetPlayer()
				local pt = Point(self.inst.Transform:GetWorldPosition())
                local hp = Point(player.Transform:GetWorldPosition())
				if distsq(hp, pt) > 250 and self.inst.components.hunger.current < 1 then
					player.components.talker:Say("   Ǹ !     !")
					GetPlayer().components.leader:RemoveFollower(self.inst)
					self.inst:Remove()
					return true 
				else
					return false
				end
			end, "die",
			ChattyNode(self.inst,PETBEEFALO_TALK_SAT_FOLLOWANGRY,			
				RunAway(self.inst, "character", 200, 300))),
		-- RunAway - TALK
		--** Pet Run if it is  hungry				
		WhileNode(function() 
				if self.inst.components.hunger.current < 1 then
					return true 
				else
					return false
				end
			end, "angry",
			ChattyNode(self.inst,PETBEEFALO_TALK_SAT_FOLLOWANGRY,			
				RunAway(self.inst, "character", 200, 300))),
		-- FOLLOW - TALK		
		--** Pet complain if it is  hungry	or hurt				
		WhileNode(function() 
				if self.inst.components.hunger.current < 12 and self.inst.components.health.currenthealth < (TUNING.BEEFALO_HEALTH/2) 
															and self.inst.components.staycommand:IsCurrentlyStaying() == false then
					return true 
				else
					return false
				end
			end, "hungryhurt",
			ChattyNode(self.inst,PETBEEFALO_TALK_SAT_HURT_HUNGRY,
			Follow(self.inst, function() return self.inst.components.follower and self.inst.components.follower.leader end, MIN_FOLLOW_DIST, TARGET_FOLLOW_DIST, MAX_FOLLOW_DIST, false))),
		-- FOLLOW - TALK		
		--** Pet complain if it is  hungry		
		WhileNode(function() 
				if self.inst.components.hunger.current < 12 and self.inst.components.staycommand:IsCurrentlyStaying() == false then
					return true 
				else
					return false
				end
			end, "hungry",
			ChattyNode(self.inst,PETBEEFALO_TALK_SAT_FOLLOWHUNGRY,
				Follow(self.inst, function() return self.inst.components.follower and self.inst.components.follower.leader end, MIN_FOLLOW_DIST, TARGET_FOLLOW_DIST, MAX_FOLLOW_DIST, false))),
		--  FOLLOW - TALK	
		--** Pet complain if it is  hurt	
		WhileNode(function() 
				if self.inst.components.health.currenthealth < (TUNING.BEEFALO_HEALTH/2) and self.inst.components.staycommand:IsCurrentlyStaying() == false then
					return true 
				else
					return false
				end
			end, "hurt",
			ChattyNode(self.inst,PETBEEFALO_TALK_SAT_HURT,
				Follow(self.inst, function() return self.inst.components.follower and self.inst.components.follower.leader end, MIN_FOLLOW_DIST, TARGET_FOLLOW_DIST, MAX_FOLLOW_DIST, false))),	
		--  FOLLOW - TALK	
		--** Pet is  happy
		WhileNode(function() 
				if self.inst.components.staycommand:IsCurrentlyStaying() == false then
					return true 
				else
					return false
				end
			end, "happy",
			ChattyNode(self.inst,PETBEEFALO_TALK_SAT_FOLLOWHAPPY,
				Follow(self.inst, function() return self.inst.components.follower and self.inst.components.follower.leader end, MIN_FOLLOW_DIST, TARGET_FOLLOW_DIST, MAX_FOLLOW_DIST, false))),
		--  WANDER - TALK	
		--** Pet is  happy
		WhileNode(function() 
				if self.inst.components.staycommand:IsCurrentlyStaying() == false then
					return true 
				else
					return false
				end
			end, "wander follow",
			ChattyNode(self.inst,PETBEEFALO_TALK_SAT_WANDER,
				Wander(self.inst, function() return Vector3(GetPlayer().Transform:GetWorldPosition()) end, GetWanderDistFn))),
		-- STAND STILL	--> if PETBEEFALO is stay 	
		WhileNode(function() 
				if self.inst.components.staycommand:IsCurrentlyStaying() == true then -- TRUE
					local pos = self.inst.components.staycommand:Position()
					self.inst.Transform:SetPosition( pos.x, pos.y, pos.z )
					return true 
				else
					return false
				end
			end, "standstill",	
			ChattyNode(self.inst,PETBEEFALO_TALK_SAT_WANDER_STAY,
				StandStill(self.inst)))					
    }, .25)
    
    self.bt = BT(self.inst, root)
    
end

return BeefaloBrain