require "behaviours/wander"
require "behaviours/faceentity"
require "behaviours/chaseandattack"
require "behaviours/panic"
require "behaviours/runaway"
require "behaviours/follow"
require "behaviours/chattynode"
require "behaviours/runaway"
require "behaviours/standstill"


local MAX_CHASE_TIME = 6
local WANDER_DIST_DAY = 20
local WANDER_DIST_NIGHT = 5

local RUN_AWAY_DIST = 6
local STOP_RUN_AWAY_DIST = 12
local START_FACE_DIST = 14
local KEEP_FACE_DIST = 20

--SAT-TALKS
local PETKOALEFANT_TALK_SAT_WANDER = {"     ."}
local PETKOALEFANT_TALK_SAT_WANDER_STAY = {"    ."}
local PETKOALEFANT_TALK_SAT_FOLLOWHAPPY = {"   ."}
local PETKOALEFANT_TALK_SAT_FOLLOWHUNGRY = {"   ι   ?"}
local PETKOALEFANT_TALK_SAT_FOLLOWHUNGRY_HURT = {"   ι   ?","     . . ."}
local PETKOALEFANT_TALK_SAT_FOLLOWHURT = {"     . . ."}
local PETKOALEFANT_TALK_SAT_ATTACK = {"  ϲ  ս  !"," Ҫ       !"}
local PETKOALEFANT_TALK_SAT_FOLLOWANGRY = {"       !"}


local function GetWanderDistFn(inst)
    if GetClock() and not GetClock():IsDay() then
        return WANDER_DIST_NIGHT
    else
        return WANDER_DIST_DAY
    end
end

local function GetFaceTargetFn(inst)
    local target = GetClosestInstWithTag("player", inst, START_FACE_DIST)
    if target and not target:HasTag("notarget") then
        return target
    end
end

local function KeepFaceTargetFn(inst, target)
    return inst:GetDistanceSqToInst(target) <= KEEP_FACE_DIST * KEEP_FACE_DIST and not target:HasTag("notarget")
end

local function ShouldRunAway(guy)
	return guy:HasTag("character") and not guy:HasTag("notarget")
end

-- SAT HEATING
local function HeatingSat (player)
	if player.components.temperature.current  < 30 then
		player.components.temperature.current = player.components.temperature.current + 1
		if player.components.temperature.current > 0 then
    		player:PushEvent("stopfreezing")
		end
	end
end


local KoalefantBrain = Class(Brain, function(self, inst)
    Brain._ctor(self, inst)
end)

function KoalefantBrain:OnStart()
    
    local root = PriorityNode(
    {   -- On fire
        WhileNode( function() return self.inst.components.health.takingfiredamage end, "OnFire", Panic(self.inst)),
		-- Chase and attack 
		--** Stop attacking if satori is far
		WhileNode(function()
				-----------------***HEATING***----------------------
				local player = GetPlayer()
				local bf = Point(self.inst.Transform:GetWorldPosition())
                local pl = Point(player.Transform:GetWorldPosition())
				local dist = distsq(pl, bf)
				
				if dist < 50 then
					HeatingSat(player)
				end	
				--*************************************************--
				--  PETKOALEFANT if it is stay but SAT is near(500) , it will attack and it will be in follow
				if dist < 500 and self.inst.components.staycommand:IsCurrentlyStaying() == true and self.inst.components.combat.target ~= nil then
					self.inst.components.staycommand:SetStaying(false)
				end
				if self.inst.components.combat.target ~= nil == self.inst.components.staycommand:IsCurrentlyStaying() == true then
					-- ATTACK IN STAY MODE
					return true
				end			
				if dist < 500 then
					return true 
				else
					-- IF SAT RUN AWAY , PETKOALEFANT leave combat
					self.inst.components.combat.target = nil
					return false
				end
			end, "die",
		ChattyNode(self.inst,PETKOALEFANT_TALK_SAT_ATTACK,	
			ChaseAndAttack(self.inst, MAX_CHASE_TIME))),
		-- RunAway
		--** Pet leaves if it is very hungry				
		WhileNode(function()
				local player = GetPlayer()
				local pt = Point(self.inst.Transform:GetWorldPosition())
                local hp = Point(player.Transform:GetWorldPosition())
				if distsq(hp, pt) > 300 and self.inst.components.hunger.current < 1 then 
					player.components.talker:Say("   Ǹ !     !")
					GetPlayer().components.leader:RemoveFollower(self.inst)
					self.inst:Remove()
					return true 
				else
					return false
				end
			end, "die",
			ChattyNode(self.inst,PETKOALEFANT_TALK_SAT_FOLLOWANGRY,
				RunAway(self.inst, "character", 200, 300))),	
		-- RunAway - TALK
		--** Pet Run if it is  hungry				
		WhileNode(function() 
				if self.inst.components.hunger.current < 1 then 
					return true 
				else
					return false
				end
			end, "angry",
			ChattyNode(self.inst,PETKOALEFANT_TALK_SAT_FOLLOWANGRY,			
				RunAway(self.inst, "character", 200, 300))),
		-- FOLLOW - TALK		
		--** Pet complain if it is  hungry	or hurt	
		WhileNode(function() 
				if self.inst.components.hunger.current < 15 and self.inst.components.health.currenthealth < (TUNING.KOALEFANT_HEALTH/2) 
															and self.inst.components.staycommand:IsCurrentlyStaying() == false then
					return true 
				else
					return false
				end
			end, "hungry",			
			ChattyNode(self.inst,PETKOALEFANT_TALK_SAT_FOLLOWHUNGRY_HURT,
				Follow(self.inst, function() return self.inst.components.follower and self.inst.components.follower.leader end, 1, 5, 5, false))),
		-- FOLLOW - TALK		
		--** Pet complain if it is  hungry	
		WhileNode(function() 
				if self.inst.components.hunger.current < 15 and self.inst.components.staycommand:IsCurrentlyStaying() == false then
					return true 
				else
					return false
				end
			end, "hungry",			
			ChattyNode(self.inst,PETKOALEFANT_TALK_SAT_FOLLOWHUNGRY,
				Follow(self.inst, function() return self.inst.components.follower and self.inst.components.follower.leader end, 1, 5, 5, false))),
		--  FOLLOW - TALK	
		--** Pet complain if it is  hurt	
		WhileNode(function() 
				if self.inst.components.health.currenthealth < (TUNING.KOALEFANT_HEALTH/2) and self.inst.components.staycommand:IsCurrentlyStaying() == false then
					return true 
				else
					return false
				end
			end, "hungry",			
			ChattyNode(self.inst,PETKOALEFANT_TALK_SAT_FOLLOWHURT,
				Follow(self.inst, function() 
						return self.inst.components.follower and self.inst.components.follower.leader end, 1, 5, 5, false))),
		--  FOLLOW - TALK	
		--** Pet is  happy
		WhileNode(function() 
				if self.inst.components.staycommand:IsCurrentlyStaying() == false then
					return true 
				else
					return false
				end
			end, "happy",		
			ChattyNode(self.inst,PETKOALEFANT_TALK_SAT_FOLLOWHAPPY,
				Follow(self.inst, function() return self.inst.components.follower and self.inst.components.follower.leader end, 1, 5, 5, false))),	
		-- WANDER - TALK		
		--** Pet complain if it is  hungry	or hurt	
		WhileNode(function() 
				if self.inst.components.hunger.current < 15 and self.inst.components.health.currenthealth < (TUNING.KOALEFANT_HEALTH/2)
															and self.inst.components.staycommand:IsCurrentlyStaying() == false then
					return true 
				else
					return false
				end
			end, "hungry",			
			ChattyNode(self.inst,PETKOALEFANT_TALK_SAT_FOLLOWHUNGRY_HURT,
				Wander(self.inst))),
		-- WANDER - TALK		
		--** Pet complain if it is  hungry	
		WhileNode(function() 
				if self.inst.components.hunger.current < 15 and self.inst.components.staycommand:IsCurrentlyStaying() == false then
					return true 
				else
					return false
				end
			end, "hungry",			
			ChattyNode(self.inst,PETKOALEFANT_TALK_SAT_FOLLOWHUNGRY,
				Wander(self.inst))),
		-- WANDER - TALK		
		--** Pet complain if it is hurt	
		WhileNode(function() 
				if self.inst.components.health.currenthealth < (TUNING.KOALEFANT_HEALTH/2) and self.inst.components.staycommand:IsCurrentlyStaying() == false then
					return true 
				else
					return false
				end
			end, "hungry",			
			ChattyNode(self.inst,PETKOALEFANT_TALK_SAT_FOLLOWHURT,
						Wander(self.inst))),
		-- WANDER - TALK - 		
		--** Pet is  happy	
		WhileNode(function() 
				if self.inst.components.staycommand:IsCurrentlyStaying() == false then
					return true 
				else
					return false
				end
			end, "wander follow",		
			ChattyNode(self.inst,PETKOALEFANT_TALK_SAT_WANDER,
				Wander(self.inst))),
		--STAND STILL	--> if PETKOALEFANT is stay 	
		WhileNode(function() 
				if self.inst.components.staycommand:IsCurrentlyStaying() == true then -- TRUE
					local pos = self.inst.components.staycommand:Position()
					self.inst.Transform:SetPosition( pos.x, pos.y, pos.z )
					return true 
				else
					return false
				end
			end, "standstill",	
			ChattyNode(self.inst,PETKOALEFANT_TALK_SAT_WANDER_STAY,
				StandStill(self.inst)))	
		
    }, .25)
    
    self.bt = BT(self.inst, root)
end

return KoalefantBrain