require "behaviours/wander"
require "behaviours/runaway"
require "behaviours/doaction"
require "behaviours/panic"
require "behaviours/follow"
require "behaviours/chattynode"

local STOP_RUN_DIST = 300
local SEE_PLAYER_DIST = 200

local AVOID_PLAYER_DIST = 200
local AVOID_PLAYER_STOP = 300

local SEE_BAIT_DIST = 20
local MAX_WANDER_DIST = 20

local MIN_FOLLOW_DIST = 1
local TARGET_FOLLOW_DIST = 2 
local MAX_FOLLOW_DIST = 5

-- SAT TALK
local PETRABBIT_TALK_SAT_WANDER = {"ϲ   !"," "}
local PETRABBIT_TALK_SAT_FOLLOWHAPPY = {"  !"," "}
local PETRABBIT_TALK_SAT_FOLLOWHUNGRY = {"  !"," "}
local PETRABBIT_TALK_SAT_FOLLOWHUNGRY_HURT = {"  ! !"," !"," "}
local PETRABBIT_TALK_SAT_FOLLOWANGRY  = {"û    ?     !"," "}
local PETRABBIT_TALK_SAT_FOLLOWHURT = {" !"," "}


local RabbitBrain = Class(Brain, function(self, inst)
    Brain._ctor(self, inst)
end)

local function GoHomeAction(inst)
    if inst.components.homeseeker and 
       inst.components.homeseeker.home and 
       inst.components.homeseeker.home:IsValid() and
	   inst.sg:HasStateTag("trapped") == false then
        return BufferedAction(inst, inst.components.homeseeker.home, ACTIONS.GOHOME)
    end
end

local function EatFoodAction(inst)

    local target = FindEntity(inst, SEE_BAIT_DIST, function(item) return inst.components.eater:CanEat(item) and item.components.bait and not item:HasTag("planted") and not (item.components.inventoryitem and item.components.inventoryitem:IsHeld()) end)
    if target then
        local act = BufferedAction(inst, target, ACTIONS.EAT)
        act.validfn = function() return not (target.components.inventoryitem and target.components.inventoryitem:IsHeld()) end
        return act
    end
end


function RabbitBrain:OnStart()
    local clock = GetClock()
    
    local root = PriorityNode(
    {	-- On fire
        WhileNode( function() return self.inst.components.health.takingfiredamage end, "OnFire", Panic(self.inst)),
		-- EAT FOOD
        DoAction(self.inst, EatFoodAction),
		-- RunAway
		--** Pet leaves if it is very hungry	
		WhileNode(function()
				local player = GetPlayer()
				local pt = Point(self.inst.Transform:GetWorldPosition())
                local hp = Point(player.Transform:GetWorldPosition())
				if distsq(hp, pt) > 150 and self.inst.components.hunger.current < 1 then 
					player.components.talker:Say("   Ǹ !     !")
					return true 
				else
					return false
				end
			end, "die",
			ChattyNode(self.inst,PETRABBIT_TALK_SAT_FOLLOWHUNGRY,	
				Follow(self.inst, function()
					GetPlayer().components.leader:RemoveFollower(self.inst)
					self.inst:Remove()				
				return self.inst.components.follower and self.inst.components.follower.leader end, MIN_FOLLOW_DIST, TARGET_FOLLOW_DIST, MAX_FOLLOW_DIST))),			
		-- RunAway - TALK
		--** Pet Run if it is  hungry	
		WhileNode(function() 
				if self.inst.components.hunger.current < 1 then
					return true 
				else
					return false
				end
			end, "hungry",
			ChattyNode(self.inst,PETRABBIT_TALK_SAT_FOLLOWANGRY,
				RunAway(self.inst, "scarytoprey", AVOID_PLAYER_DIST, AVOID_PLAYER_STOP))),
		-- RunAway - TALK
		--** Pet Run if it is  hungry			
		WhileNode(function() 
				if self.inst.components.hunger.current < 1 then
					return true 
				else
					return false
				end
			end, "hungry",
			ChattyNode(self.inst,PETRABBIT_TALK_SAT_FOLLOWANGRY,
				RunAway(self.inst, "scarytoprey", SEE_PLAYER_DIST, STOP_RUN_DIST, nil, true))),
		-- FOLLOW - TALK		
		--** Pet complain if it is  hungry	or hurt		
		WhileNode(function() 
				if self.inst.components.hunger.current < 10 and self.inst.components.health.currenthealth < (TUNING.RABBIT_HEALTH/2) then
					return true 
				else
					return false
				end
			end, "hungry",
			ChattyNode(self.inst,PETRABBIT_TALK_SAT_FOLLOWHUNGRY_HURT,	
				Follow(self.inst, function()
				return self.inst.components.follower and self.inst.components.follower.leader end, MIN_FOLLOW_DIST, TARGET_FOLLOW_DIST, MAX_FOLLOW_DIST))),
		-- FOLLOW - TALK		
		--** Pet complain if it is  hungry	or hurt				
		WhileNode(function() 
				if self.inst.components.hunger.current < 10 and self.inst.components.health.currenthealth < (TUNING.RABBIT_HEALTH/2) then
					return true 
				else
					return false
				end
			end, "hungry",
			ChattyNode(self.inst,PETRABBIT_TALK_SAT_FOLLOWHUNGRY_HURT,	
				Wander(self.inst, function() return self.inst.components.knownlocations:GetLocation("home") end, MAX_WANDER_DIST))),
		-- FOLLOW - TALK		
		--** Pet complain if it is  hungry	
		WhileNode(function() 
				if self.inst.components.hunger.current < 10 then
					return true 
				else
					return false
				end
			end, "hungry",
			ChattyNode(self.inst,PETRABBIT_TALK_SAT_FOLLOWHUNGRY,	
				Follow(self.inst, function()
				return self.inst.components.follower and self.inst.components.follower.leader end, MIN_FOLLOW_DIST, TARGET_FOLLOW_DIST, MAX_FOLLOW_DIST))),
		-- FOLLOW - TALK		
		--** Pet complain if it is  hungry			
		WhileNode(function() 
				if self.inst.components.hunger.current < 10 then
					return true 
				else
					return false
				end
			end, "hungry",
			ChattyNode(self.inst,PETRABBIT_TALK_SAT_FOLLOWHUNGRY,	
				Wander(self.inst, function() return self.inst.components.knownlocations:GetLocation("home") end, MAX_WANDER_DIST))),
		--  FOLLOW - TALK	
		--** Pet complain if it is  hurt	
		WhileNode(function() 
				if self.inst.components.health.currenthealth < (TUNING.RABBIT_HEALTH/2)  then
					return true 
				else
					return false
				end
			end, "hungry",
			ChattyNode(self.inst,PETRABBIT_TALK_SAT_FOLLOWHURT,	
				Follow(self.inst, function()
				return self.inst.components.follower and self.inst.components.follower.leader end, MIN_FOLLOW_DIST, TARGET_FOLLOW_DIST, MAX_FOLLOW_DIST))),
		--  FOLLOW - TALK	
		--** Pet complain if it is  hurt			
		WhileNode(function() 
				if self.inst.components.health.currenthealth < (TUNING.RABBIT_HEALTH/2)  then
					return true 
				else
					return false
				end
			end, "hungry",
			ChattyNode(self.inst,PETRABBIT_TALK_SAT_FOLLOWHURT,	
				Wander(self.inst, function() return self.inst.components.knownlocations:GetLocation("home") end, MAX_WANDER_DIST))),		
		--  FOLLOW - TALK	
		--** Pet is  happy
		ChattyNode(self.inst,PETRABBIT_TALK_SAT_FOLLOWHAPPY,
			Follow(self.inst, function()
			return self.inst.components.follower and self.inst.components.follower.leader end, MIN_FOLLOW_DIST, TARGET_FOLLOW_DIST, MAX_FOLLOW_DIST)),			
        --  WANDER - TALK	
		--** Pet is  happy
		ChattyNode(self.inst,PETRABBIT_TALK_SAT_WANDER,
			Wander(self.inst, function() return self.inst.components.knownlocations:GetLocation("home") end, MAX_WANDER_DIST))
    }, .25)
    self.bt = BT(self.inst, root)
end

return RabbitBrain

