require "behaviours/wander"
require "behaviours/chaseandattack"
require "behaviours/panic"
require "behaviours/follow"
require "behaviours/chattynode"
require "behaviours/runaway"
require "behaviours/standstill"

local MAX_CHASE_TIME = 20
local MAX_WANDER_DIST = 16
local MAX_CHASEAWAY_DIST = 32
local START_FACE_DIST = 6
local KEEP_FACE_DIST = 8
local WARN_BEFORE_ATTACK_TIME = 2


--- FOLLOW LEADER - SAT
local MIN_FOLLOW_DIST = 1
local TARGET_FOLLOW_DIST = 5
local MAX_FOLLOW_DIST = 5
-----WANDER DIST
local WANDER_DIST_DAY = 5
local WANDER_DIST_NIGHT = 10

local PETTALLBIRD_TALK_SAT_ATTACK		= {"   !","    !"}
local PETTALLBIRD_TALK_SAT_FOLLOWANGRY 	= {"   !"}
local PETTALLBIRD_TALK_SAT_HURT_HUNGRY  = {"ι  !   !","    !"}
local PETTALLBIRD_TALK_SAT_FOLLOWHUNGRY = {"ι  !   !"}
local PETTALLBIRD_TALK_SAT_HURT			= {"    !","     "}
local PETTALLBIRD_TALK_SAT_FOLLOWHAPPY 	= {"  ̫ Զ !"}
local PETTALLBIRD_TALK_SAT_WANDER		= {"    Զ  һ   !","      !"}
local PETTALLBIRD_TALK_SAT_WANDER_STAY	= {" Ҫ ȥ  ? ! ","  Ȼ     "}
local PETTALLBIRD_TALK_SAT_YANDERE		= {"  ˭ ! ?","       ô ? !"}





local function GetWanderDistFn(inst)
    if GetClock() and not GetClock():IsDay() then
        return WANDER_DIST_NIGHT
    else
        return WANDER_DIST_DAY
    end
end

local TallbirdBrain = Class(Brain, function(self, inst)
    Brain._ctor(self, inst)
end)


local function displayer(inst)
	local player = GetPlayer()
	local bf = Point(inst.Transform:GetWorldPosition())
	local pl = Point(player.Transform:GetWorldPosition())
	local dist = distsq(pl, bf)
	return dist
end


local function Satpenalty()

    local old_percent = GetPlayer().components.health:GetPercent()
	-- DAMAGE TALLBIRD TO SATORI
	if GetPlayer().components.health.currenthealth > 5 then
		--GetPlayer().components.health:SetVal(GetPlayer().components.health.currenthealth -5)
		GetPlayer().components.health:DoDelta(-5, false,"pettalbbird")
	else
		local dam = 1-GetPlayer().components.health.currenthealth
		GetPlayer().components.health:DoDelta(dam, false,"pettalbbird")
	end
	-- REFRESH DISPLAY
	GetPlayer():PushEvent("healthdeltaSat", {oldpercent = old_percent, newpercent = GetPlayer().components.health:GetPercent(), overtime=nil, cause=nil})
	GetPlayer().sg:GoToState("hit")
	GetPlayer():PushEvent("badaura")
	
end

function TallbirdBrain:OnStart()

    local clock = GetClock()
    
    local root = PriorityNode(
	{
		WhileNode( function() return self.inst.components.health.takingfiredamage end, "OnFire", Panic(self.inst)),
		----------------------------------------------------------------------------------------------------
		-----------------------------?  ?  ?  ? YANDERE BEHAVIOUR ?  ?  ?  ?  ?  ? ----------------------------
		WhileNode(function()
					if self.inst.family > GetPlayer().components.leader.numfollowers then
						self.inst.family = GetPlayer().components.leader.numfollowers
					end
					local dist = displayer(self.inst) -- Distance PLAYER - PET
					if self.inst.components.staycommand:IsCurrentlyStaying() == false and self.inst.family < GetPlayer().components.leader.numfollowers then
						if dist > 15 then
						    local hp = Point(GetPlayer().Transform:GetWorldPosition())
						    self.inst.components.locomotor:GoToPoint(hp, nil, true)
							return true
						end	
					end
					return false
				end,	
			StandStill(self.inst)),
		
		WhileNode(function()
				if self.inst.components.staycommand:IsCurrentlyStaying() == false and self.inst.family < GetPlayer().components.leader.numfollowers then										
					self.inst.family = GetPlayer().components.leader.numfollowers					
					--self.inst.SoundEmitter:PlaySound("dontstarve/creatures/tallbird/attack")
					--self.inst.components.locomotor:StopMoving()
					--self.inst.AnimState:PlayAnimation("atk_pre")
					self.inst:FacePoint(Point(GetPlayer().Transform:GetWorldPosition()))					
					self.inst.sg:GoToState("attack")
					--GetPlayer().components.health:DoDelta(-5)
					-- SIMULATE DAMAGE SATORI-----
					Satpenalty()	--------------
					------------------------------
					return true 
				else
					return false
				end
			end, "yandere",
			ChattyNode(self.inst,PETTALLBIRD_TALK_SAT_YANDERE,
				Wander(self.inst, function() return Vector3(GetPlayer().Transform:GetWorldPosition()) end, GetWanderDistFn))),	
		-------------------------------------------------?  ?  ?  ?  ? -------------------------------------------			
		-- Chase and attack 
		--** Stop attacking if satori is far
		WhileNode(function()
				--[[local player = GetPlayer()
				local bf = Point(self.inst.Transform:GetWorldPosition())
                local pl = Point(player.Transform:GetWorldPosition())
				local dist = distsq(pl, bf)--]]
				local dist = displayer(self.inst) -- Distance PLAYER - PET
				
				--  TALLBIRD if it is stay but SAT is near(500) , it will attack and it will be in follow
				if dist < 400 and self.inst.components.staycommand:IsCurrentlyStaying() == true and self.inst.components.combat.target ~= nil then
					self.inst.components.staycommand:SetStaying(false)
				end
				if self.inst.components.combat.target ~= nil == self.inst.components.staycommand:IsCurrentlyStaying() == true then
					-- ATTACK IN STAY MODE
					return true
				end			
				if dist < 400 then
				 	return true 
				else
					-- IF SAT RUN AWAY , TALLBIRD leave combat
					self.inst.components.combat.target = nil
					return false
				end
			end, "die",
			ChattyNode(self.inst,PETTALLBIRD_TALK_SAT_ATTACK,
				ChaseAndAttack(self.inst, MAX_CHASE_TIME))),
		-- RunAway
		--** Pet leaves if it is very hungry	
		WhileNode(function()
				local player = GetPlayer()
				local pt = Point(self.inst.Transform:GetWorldPosition())
                local hp = Point(player.Transform:GetWorldPosition())
				if distsq(hp, pt) > 250 and self.inst.components.hunger.current < 1 then
					player.components.talker:Say("   Ǹ !     !")
					self.inst:Remove()
					return true 
				else
					return false
				end
			end, "die",
			ChattyNode(self.inst,PETTALLBIRD_TALK_SAT_FOLLOWANGRY,			
				RunAway(self.inst, "character", 200, 300))),		
		-- RunAway - TALK
		--** Pet Run if it is  hungry				
		WhileNode(function() 
				if self.inst.components.hunger.current < 1 then
					return true 
				else
					return false
				end
			end, "angry",
			ChattyNode(self.inst,PETTALLBIRD_TALK_SAT_FOLLOWANGRY,			
				RunAway(self.inst, "character", 200, 300))),
		
		-- FOLLOW - TALK		
		--** Pet complain if it is  hungry	or hurt				
		WhileNode(function() 
				if self.inst.components.hunger.current < 12 and self.inst.components.health.currenthealth < (TUNING.TALLBIRD_HEALTH/2) 
															and self.inst.components.staycommand:IsCurrentlyStaying() == false then
					return true 
				else
					return false
				end
			end, "hungryhurt",
			ChattyNode(self.inst,PETTALLBIRD_TALK_SAT_HURT_HUNGRY,
			Follow(self.inst, function() return self.inst.components.follower and self.inst.components.follower.leader end, MIN_FOLLOW_DIST, TARGET_FOLLOW_DIST, MAX_FOLLOW_DIST, false))),			
		-- FOLLOW - TALK		
		--** Pet complain if it is  hungry		
		WhileNode(function() 
				if self.inst.components.hunger.current < 12 and self.inst.components.staycommand:IsCurrentlyStaying() == false then
					return true 
				else
					return false
				end
			end, "hungry",
			ChattyNode(self.inst,PETTALLBIRD_TALK_SAT_FOLLOWHUNGRY,
				Follow(self.inst, function() return self.inst.components.follower and self.inst.components.follower.leader end, MIN_FOLLOW_DIST, TARGET_FOLLOW_DIST, MAX_FOLLOW_DIST, false))),
		--  FOLLOW - TALK	
		--** Pet complain if it is  hurt	
		WhileNode(function() 
				if self.inst.components.health.currenthealth < (TUNING.TALLBIRD_HEALTH/2) and self.inst.components.staycommand:IsCurrentlyStaying() == false then
					return true 
				else
					return false
				end
			end, "hurt",
			ChattyNode(self.inst,PETTALLBIRD_TALK_SAT_HURT,
				Follow(self.inst, function() return self.inst.components.follower and self.inst.components.follower.leader end, MIN_FOLLOW_DIST, TARGET_FOLLOW_DIST, MAX_FOLLOW_DIST, false))),	
		
		--  FOLLOW - TALK	
		--** Pet is  happy
		WhileNode(function() 
				if self.inst.components.staycommand:IsCurrentlyStaying() == false then
					return true 
				else
					return false
				end
			end, "happy",
			ChattyNode(self.inst,PETTALLBIRD_TALK_SAT_FOLLOWHAPPY,
				Follow(self.inst, function() return self.inst.components.follower and self.inst.components.follower.leader end, MIN_FOLLOW_DIST, TARGET_FOLLOW_DIST, MAX_FOLLOW_DIST, false))),			
		--  WANDER - TALK	
		--** Pet is  happy
		WhileNode(function() 
				if self.inst.components.staycommand:IsCurrentlyStaying() == false then
					return true 
				else
					return false
				end
			end, "wander follow",
			ChattyNode(self.inst,PETTALLBIRD_TALK_SAT_WANDER,
				Wander(self.inst, function() return Vector3(GetPlayer().Transform:GetWorldPosition()) end, GetWanderDistFn))),			
		-- STAND STILL	--> if TALLBIRD is stay 	
		WhileNode(function() 
				if self.inst.components.staycommand:IsCurrentlyStaying() == true then -- TRUE
					local pos = self.inst.components.staycommand:Position()
					self.inst.Transform:SetPosition( pos.x, pos.y, pos.z )
					return true 
				else
					return false
				end
			end, "standstill",	
			ChattyNode(self.inst,PETTALLBIRD_TALK_SAT_WANDER_STAY,
				StandStill(self.inst)))	
		
	},1)
    
    self.bt = BT(self.inst, root) 
           
end

function TallbirdBrain:OnInitializationComplete()
    self.inst.components.knownlocations:RememberLocation("home", Point(self.inst.Transform:GetWorldPosition()))
end

return TallbirdBrain