require "behaviours/wander"
require "behaviours/runaway"
require "behaviours/doaction"
require "behaviours/panic"
require "behaviours/chattynode"

local STOP_RUN_DIST = 10
local SEE_PLAYER_DIST = 5

local AVOID_PLAYER_DIST = 3
local AVOID_PLAYER_STOP = 6

local SEE_BAIT_DIST = 20
local MAX_WANDER_DIST = 20

-- SAT TALK
local RABBIT_TALK_SAT_FOOD 	 = {"  !","   !"," ζ !"," "," "}
local RABBIT_TALK_SAT_HOME	 = {"  !   !"," Ҫ   !   !"," Ҫ   !   !","     !"," "," "}
local RABBIT_TALK_SAT_WANDER = {"   ?","     ?","   ?"," ?"," "," "}


local RabbitBrain = Class(Brain, function(self, inst)
    Brain._ctor(self, inst)
end)

local function GoHomeAction(inst)
    if inst.components.homeseeker and 
       inst.components.homeseeker.home and 
       inst.components.homeseeker.home:IsValid() and
	   inst.sg:HasStateTag("trapped") == false then
        return BufferedAction(inst, inst.components.homeseeker.home, ACTIONS.GOHOME)
    end
end

local function EatFoodAction(inst)

    local target = FindEntity(inst, SEE_BAIT_DIST, function(item) return inst.components.eater:CanEat(item) and item.components.bait and not item:HasTag("planted") and not (item.components.inventoryitem and item.components.inventoryitem:IsHeld()) end)
    if target then
        local act = BufferedAction(inst, target, ACTIONS.EAT)
        act.validfn = function() return not (target.components.inventoryitem and target.components.inventoryitem:IsHeld()) end
        return act
    end
end


function RabbitBrain:OnStart()
    local clock = GetClock()
    if GetPlayer().prefab ~= "sat" then 
		if SEASONS.AUTUMN then 
		--************ D  L  C *********--
			local seasonmgr = GetSeasonManager()    
			local root = PriorityNode(
			{
				WhileNode( function() return self.inst.components.health.takingfiredamage end, "OnFire", Panic(self.inst)),
				RunAway(self.inst, "scarytoprey", AVOID_PLAYER_DIST, AVOID_PLAYER_STOP),
				RunAway(self.inst, "scarytoprey", SEE_PLAYER_DIST, STOP_RUN_DIST, nil, true),
				EventNode(self.inst, "gohome", 
					DoAction(self.inst, GoHomeAction, "go home", true )),
				WhileNode(function() return clock and not clock:IsDay() end, "IsNight",
					DoAction(self.inst, GoHomeAction, "go home", true )),
				WhileNode(function() return seasonmgr and seasonmgr:GetSeason() == SEASONS.SPRING end, "IsSpring",
					DoAction(self.inst, GoHomeAction, "go home", true )),
				DoAction(self.inst, EatFoodAction),
				Wander(self.inst, function() return self.inst.components.knownlocations:GetLocation("home") end, MAX_WANDER_DIST)
			}, .25)
			self.bt = BT(self.inst, root)	
		else
			local root = PriorityNode(
			{
				WhileNode( function() return self.inst.components.health.takingfiredamage end, "OnFire", Panic(self.inst)),
				RunAway(self.inst, "scarytoprey", AVOID_PLAYER_DIST, AVOID_PLAYER_STOP),
				RunAway(self.inst, "scarytoprey", SEE_PLAYER_DIST, STOP_RUN_DIST, nil, true),
				EventNode(self.inst, "gohome", 
					DoAction(self.inst, GoHomeAction, "go home", true )),
				WhileNode(function() return clock and not clock:IsDay() end, "IsNight",
					DoAction(self.inst, GoHomeAction, "go home", true )),
				DoAction(self.inst, EatFoodAction),
				Wander(self.inst, function() return self.inst.components.knownlocations:GetLocation("home") end, MAX_WANDER_DIST)
			}, .25)
			self.bt = BT(self.inst, root)
		end
	else
		-- behaviour with sat
		if SEASONS.AUTUMN then 
		--************ D  L  C *********--
			local seasonmgr = GetSeasonManager()    
			local root = PriorityNode(
			{
				WhileNode( function() return self.inst.components.health.takingfiredamage end, "OnFire", Panic(self.inst)),
				EventNode(self.inst, "gohome", 
					DoAction(self.inst, GoHomeAction, "go home", true )),
				ChattyNode(self.inst,RABBIT_TALK_SAT_HOME,
					WhileNode(function() return clock and not clock:IsDay() end, "IsNight",
						DoAction(self.inst, GoHomeAction, "go home", true ))),
				ChattyNode(self.inst,RABBIT_TALK_SAT_HOME,		
					WhileNode(function() return seasonmgr and seasonmgr:GetSeason() == SEASONS.SPRING end, "IsSpring",
						DoAction(self.inst, GoHomeAction, "go home", true ))),		
				ChattyNode(self.inst,RABBIT_TALK_SAT_FOOD,
					DoAction(self.inst, EatFoodAction)),
				ChattyNode(self.inst,RABBIT_TALK_SAT_WANDER,
					Wander(self.inst, function() return self.inst.components.knownlocations:GetLocation("home") end, MAX_WANDER_DIST))
			}, .25)
			self.bt = BT(self.inst, root)	
		else			
			local root = PriorityNode(
			{
				WhileNode( function() return self.inst.components.health.takingfiredamage end, "OnFire", Panic(self.inst)),
				EventNode(self.inst, "gohome", 
					DoAction(self.inst, GoHomeAction, "go home", true )),
				ChattyNode(self.inst,RABBIT_TALK_SAT_HOME,
					WhileNode(function() return clock and not clock:IsDay() end, "IsNight",
						DoAction(self.inst, GoHomeAction, "go home", true ))),
				ChattyNode(self.inst,RABBIT_TALK_SAT_FOOD,
					DoAction(self.inst, EatFoodAction)),
				ChattyNode(self.inst,RABBIT_TALK_SAT_WANDER,
					Wander(self.inst, function() return self.inst.components.knownlocations:GetLocation("home") end, MAX_WANDER_DIST))
			}, .25)
			self.bt = BT(self.inst, root)
		end
	end
end


return RabbitBrain
