require "behaviours/chaseandattack"
require "behaviours/wander"
require "behaviours/faceentity"
require "behaviours/follow"
require "behaviours/standstill"
require "behaviours/chattynode"
require "behaviours/runaway"


local MIN_FOLLOW_DIST = 1
local MAX_FOLLOW_DIST = 7
local TARGET_FOLLOW_DIST = (MAX_FOLLOW_DIST+MIN_FOLLOW_DIST)/2

local MAX_CHASE_TIME = 10
local MAX_CHASE_TIME_SPRING = 10

local TRADE_DIST = 20

local SEE_FOOD_DIST = 15
local FIND_FOOD_HUNGER_PERCENT = 0.75 -- if hunger below this, forage for nearby food

--local MAX_WANDER_DIST = 20
--local MAX_CHASE_DIST = 30

local START_RUN_DIST = 2
local STOP_RUN_DIST = 4

----------------------------
local WANDER_DIST_DAY = 20
local WANDER_DIST_NIGHT = 5

local SMALL_TALK_SAT_EATING = {"  !"}

local SMALL_TALK_SAT_WANDER = {"  ?"}
local SMALL_TALK_SAT_FOLLOWHAPPY = {"  !"}
local SMALL_TALK_SAT_HURT = { " !"}
local SMALL_TALK_SAT_HURTHUNGRY = { " !","  !"}
local SMALL_TALK_SAT_FOLLOWHUNGRY = {"  !"}
local SMALL_TALK_SAT_ATTACK = {"  !  !"}

local TEEN_TALK_SAT_WANDER = {"  ʼ ϲ    ."}
local TEEN_TALK_SAT_FOLLOWHAPPY = {"    ."}
local TEEN_TALK_SAT_HURT = { "  !   æ !"}
local TEEN_TALK_SAT_HURTHUNGRY = { "  ...  !   !","  !   æ !"}
local TEEN_TALK_SAT_FOLLOWHUNGRY = {"  ...  !   !"}
local TEEN_TALK_SAT_ATTACK = {"ι !    !"}


local function IsHungry(inst)
    return inst.components.hunger and inst.components.hunger:GetPercent() < FIND_FOOD_HUNGER_PERCENT
end

local function IsStarving(inst)
    return inst.components.hunger and inst.components.hunger:IsStarving()
end

local function ShouldStandStill(inst)
    return inst.components.hunger and inst.components.hunger:IsStarving() and not inst:HasTag("teenbird") 
end

local function eating(inst)
	return inst.eating
end

local function CanSeeFood(inst)
    local target = FindEntity(inst, SEE_FOOD_DIST, function(item) return inst.components.eater:CanEat(item) end)
    if target then
        --print("CanSeeFood", inst.name, target.name)
    end
    return target
end

local function FindFoodAction(inst)
    local target = CanSeeFood(inst)
    if target then
        return BufferedAction(inst, target, ACTIONS.EAT)
    end
end

local function GetTraderFn(inst)

	if SEASONS.AUTUMN then 
		--************ D  L  C *********--
		return (not inst:HasTag("springbird")) and (inst.components.follower.leader and inst.components.trader:IsTryingToTradeWithMe(inst.components.follower.leader)) and inst.components.follower.leader or nil
	else
		return (inst.components.follower.leader and inst.components.trader:IsTryingToTradeWithMe(inst.components.follower.leader)) and inst.components.follower.leader or nil
	end
end

local function KeepTraderFn(inst, target)
    return inst.components.trader:IsTryingToTradeWithMe(target)
end

local function ShouldRunAwayFromPlayer(inst, player)
	if SEASONS.AUTUMN then 
			--************ D  L  C *********--
		return inst:HasTag("springbird") or not inst.components.follower.leader -- REMOVED "inst:HasTag("teenbird") and " from return

	else
		return inst:HasTag("teenbird") and not inst.components.follower.leader
	end
end

local function SpringMod(amt)
	if 	SEASONS.AUTUMN then 
		if GetSeasonManager() and GetSeasonManager():IsSpring() then
			return amt * TUNING.SPRING_COMBAT_MOD
		else
			return amt
		end
	else
		return amt
	end	
end

local SmallBirdBrain = Class(Brain, function(self, inst)
    Brain._ctor(self, inst)
end)



local function GetWanderDistFn(inst)
    if GetClock() and not GetClock():IsDay() then
        return WANDER_DIST_NIGHT
    else
        return WANDER_DIST_DAY
    end
end

function SmallBirdBrain:OnStart()
	if GetPlayer().prefab ~= "sat" then 
		local root =  PriorityNode(
		{
			FaceEntity(self.inst, GetTraderFn, KeepTraderFn),
			-- when starving prefer finding food over fighting
			SequenceNode{
				ConditionNode(function() return IsStarving(self.inst) and CanSeeFood(self.inst) end, "SeesFoodToEat"),
				ParallelNodeAny {
					WaitNode(math.random()*.5),
					PriorityNode {
						StandStill(self.inst, ShouldStandStill),
						Follow(self.inst, function() return self.inst.components.follower.leader end, MIN_FOLLOW_DIST, TARGET_FOLLOW_DIST, MAX_FOLLOW_DIST),
					},
				},
				DoAction(self.inst, function() return FindFoodAction(self.inst) end),
			},
			WhileNode(function()
					if SEASONS.AUTUMN then 
						--************ D  L  C *********--
						return true
					else 
						return false
					end
				end,"Springmode",
			SequenceNode{
				ConditionNode(function() return self.inst.components.combat.target ~= nil end, "HasTarget"),
				WaitNode(math.random()*.9),
				ChaseAndAttack(self.inst, SpringMod(MAX_CHASE_TIME)),
			}),				
			SequenceNode{
				ConditionNode(function() return self.inst.components.combat.target ~= nil end, "HasTarget"),
				WaitNode(math.random()*.9),
				ChaseAndAttack(self.inst, MAX_CHASE_TIME),
				
			},
			RunAway(self.inst, "player", START_RUN_DIST, STOP_RUN_DIST, function(target) return ShouldRunAwayFromPlayer(self.inst, target) end ),
			SequenceNode{
				ConditionNode(function() return IsHungry(self.inst) and CanSeeFood(self.inst) end, "SeesFoodToEat"),
				ParallelNodeAny {
					WaitNode(1 + math.random()*2),
					PriorityNode {
						StandStill(self.inst, ShouldStandStill),
						Follow(self.inst, function() return self.inst.components.follower.leader end, MIN_FOLLOW_DIST, TARGET_FOLLOW_DIST, MAX_FOLLOW_DIST),
					},
				},
				DoAction(self.inst, function() return FindFoodAction(self.inst) end),
			},
			PriorityNode {
				StandStill(self.inst, ShouldStandStill),
				Follow(self.inst, function() return self.inst.components.follower.leader end, MIN_FOLLOW_DIST, TARGET_FOLLOW_DIST, MAX_FOLLOW_DIST),
			},
			Wander(self.inst, function() if self.inst.components.follower.leader then return Vector3(self.inst.components.follower.leader.Transform:GetWorldPosition()) end end, MAX_FOLLOW_DIST- 1, {minwalktime=.5, randwalktime=.5, minwaittime=6, randwaittime=3})
		},.25)
		self.bt = BT(self.inst, root)
	else
		local root = PriorityNode(
    {
		FaceEntity(self.inst, GetTraderFn, KeepTraderFn),
	    -- Attack  & LOSE TARGET because sat is far
		WhileNode(function()				-----------*****  T E E N
				local player = GetPlayer()
				local bf = Point(self.inst.Transform:GetWorldPosition())
                local pl = Point(player.Transform:GetWorldPosition())
				if self.inst:HasTag("teenbird") then
					--print("teen: "..self.inst.components.hunger.current)
				else
					--print("small: "..self.inst.components.hunger.current)
				end
				if distsq(pl, bf) < 300 then
					if self.inst:HasTag("teenbird") then
						if SEASONS.AUTUMN then 
						--************ D  L  C *********--
							MAX_CHASE_TIME_SPRING = SpringMod(MAX_CHASE_TIME)	
						else
							MAX_CHASE_TIME_SPRING = MAX_CHASE_TIME
						end	
						return true
					else
						return false
					end	
				else
					self.inst.components.combat.target = nil
					return false
				end
			end, "die",
			ChattyNode(self.inst,TEEN_TALK_SAT_ATTACK,
				ChaseAndAttack(self.inst, MAX_CHASE_TIME_SPRING))),
		WhileNode(function()				-----------*****  S M A L L
				local player = GetPlayer()
				local bf = Point(self.inst.Transform:GetWorldPosition())
                local pl = Point(player.Transform:GetWorldPosition())
				if distsq(pl, bf) < 300 and self.inst.components.combat.target then
					if SEASONS.AUTUMN then 
						--************ D  L  C *********--
						MAX_CHASE_TIME_SPRING = SpringMod(MAX_CHASE_TIME)	
					else
						MAX_CHASE_TIME_SPRING = MAX_CHASE_TIME
					end	
					return true 
				else
					self.inst.components.combat.target = nil
					return false
				end
			end, "die",
			ChattyNode(self.inst,SMALL_TALK_SAT_ATTACK,
				ChaseAndAttack(self.inst, MAX_CHASE_TIME_SPRING))),
-----------------------------------------------------------------------------
		WhileNode(function() 				-----------*****  T E E N
				if self.inst.eating == true and self.inst:HasTag("teenbird") then
					self.inst.eating = false
					return true
	
				else
					return false
				end
			end, "hungry",
			ChattyNode(self.inst,SMALL_TALK_SAT_EATING,
				StandStill(self.inst))),
		WhileNode(function() 				-----------*****  SMALL
				if self.inst.eating == true  then
					return true
	
				else
					return false
				end
			end, "hungry",
			ChattyNode(self.inst,SMALL_TALK_SAT_EATING,
				StandStill(self.inst))),		
		-- BEHAVIOUR WHEN IS HUNGRY & HURT				
		WhileNode(function() 				-----------*****  T E E N
				if not(IsStarving(self.inst)) and self.inst.components.hunger.current < 12 and self.inst.components.health.currenthealth < (TUNING.TEENBIRD_HEALTH/2) then
					if self.inst:HasTag("teenbird") then
						return true
					else
						return false
					end	
				else
					return false
				end
			end, "hungry",
			ChattyNode(self.inst,TEEN_TALK_SAT_HURTHUNGRY,
			Follow(self.inst, function() return self.inst.components.follower and self.inst.components.follower.leader end, MIN_FOLLOW_DIST, TARGET_FOLLOW_DIST, MAX_FOLLOW_DIST, false))),
		WhileNode(function() 				-----------*****  S M A L L
				if  not(IsStarving(self.inst)) and self.inst.components.hunger.current < 12 and self.inst.components.health.currenthealth < (TUNING.SMALLBIRD_HEALTH/2) then
					return true 
				else
					return false
				end
			end, "hungry",
			ChattyNode(self.inst,SMALL_TALK_SAT_HURTHUNGRY,
			Follow(self.inst, function() return self.inst.components.follower and self.inst.components.follower.leader end, MIN_FOLLOW_DIST, TARGET_FOLLOW_DIST, MAX_FOLLOW_DIST, false))),
	--------------------------------------------------------------------------------------------------------------
        -- BEHAVIOUR WHEN IS HUNGRY 		
		WhileNode(function() 				-----------*****  T E E N
				if not(IsStarving(self.inst)) and self.inst.components.hunger.current < (self.inst.components.hunger.max/2) then
					if self.inst:HasTag("teenbird") then
						return true
					else
						return false
					end	 
				else
					return false
				end
			end, "hungry",
			ChattyNode(self.inst,TEEN_TALK_SAT_FOLLOWHUNGRY,
				Follow(self.inst, function() return self.inst.components.follower and self.inst.components.follower.leader end, MIN_FOLLOW_DIST, TARGET_FOLLOW_DIST, MAX_FOLLOW_DIST, false))),		
		WhileNode(function() 				-----------*****  S M A L L
				if not(IsStarving(self.inst)) and  self.inst.components.hunger.current < (self.inst.components.hunger.max/2)  then
					return true 
				else
					return false
				end
			end, "hungry",
			ChattyNode(self.inst,SMALL_TALK_SAT_FOLLOWHUNGRY,
				Follow(self.inst, function() return self.inst.components.follower and self.inst.components.follower.leader end, MIN_FOLLOW_DIST, TARGET_FOLLOW_DIST, MAX_FOLLOW_DIST, false))),	
	--------------------------------------------------------------------------------------------------------------
        -- BEHAVIOUR WHEN IS HURT		 
		WhileNode(function() 				-----------*****  T E E N
				if not(IsStarving(self.inst)) and  self.inst.components.health.currenthealth < (TUNING.TEENBIRD_HEALTH/2) then
					if self.inst:HasTag("teenbird") then
						return true
					else
						return false
					end	
				else
					return false
				end
			end, "hungry",
			ChattyNode(self.inst,TEEN_TALK_SAT_HURT,
				Follow(self.inst, function() return self.inst.components.follower and self.inst.components.follower.leader end, MIN_FOLLOW_DIST, TARGET_FOLLOW_DIST, MAX_FOLLOW_DIST, false))),
		WhileNode(function() 				-----------*****  S M A L L
				if not(IsStarving(self.inst)) and  self.inst.components.health.currenthealth < (TUNING.SMALLBIRD_HEALTH/2) then
					return true 
				else
					return false
				end
			end, "hungry",
			ChattyNode(self.inst,SMALL_TALK_SAT_HURT,
				Follow(self.inst, function() return self.inst.components.follower and self.inst.components.follower.leader end, MIN_FOLLOW_DIST, TARGET_FOLLOW_DIST, MAX_FOLLOW_DIST, false))),
	--------------------------------------------------------------------------------------------------------------
        -- BEHAVIOUR WHEN IS HAPPY			
		WhileNode(function()			-----------*****  T E E N
				if not(IsStarving(self.inst)) and self.inst:HasTag("teenbird") then
					return true
				else
					return false
				end	
			end, "followhappyteen",
			ChattyNode(self.inst,TEEN_TALK_SAT_FOLLOWHAPPY,
				Follow(self.inst, function() return self.inst.components.follower and self.inst.components.follower.leader end, MIN_FOLLOW_DIST, TARGET_FOLLOW_DIST, MAX_FOLLOW_DIST, false))),
		WhileNode(function()			-----------*****  T E E N
				if not(IsStarving(self.inst)) then
					return true
				else
					return false
				end	
			end, "followhappyteen",		
			ChattyNode(self.inst,SMALL_TALK_SAT_FOLLOWHAPPY,
				Follow(self.inst, function() return self.inst.components.follower and self.inst.components.follower.leader end, MIN_FOLLOW_DIST, TARGET_FOLLOW_DIST, MAX_FOLLOW_DIST, false))),
	--------------------------------------------------------------------------------------------------------------
		SequenceNode{
				ConditionNode(function() return IsStarving(self.inst) and CanSeeFood(self.inst) end, "SeesFoodToEat"),
				ParallelNodeAny {
					WaitNode(math.random()*.5),
					PriorityNode {
						StandStill(self.inst, ShouldStandStill),
						Follow(self.inst, function() return self.inst.components.follower.leader end, MIN_FOLLOW_DIST, TARGET_FOLLOW_DIST, MAX_FOLLOW_DIST),
					},
				},
				DoAction(self.inst, function() return FindFoodAction(self.inst) end),
			},
			WhileNode(function()
					if SEASONS.AUTUMN then 
						--************ D  L  C *********--
						return true
					else 
						return false
					end
				end,"Springmode",
			SequenceNode{
				ConditionNode(function() return self.inst.components.combat.target ~= nil end, "HasTarget"),
				WaitNode(math.random()*.9),
				ChaseAndAttack(self.inst, SpringMod(MAX_CHASE_TIME)),
			}),	
			SequenceNode{
				ConditionNode(function() return self.inst.components.combat.target ~= nil end, "HasTarget"),
				WaitNode(math.random()*.9),
				ChaseAndAttack(self.inst, MAX_CHASE_TIME),
			},
			RunAway(self.inst, "player", START_RUN_DIST, STOP_RUN_DIST, function(target) return ShouldRunAwayFromPlayer(self.inst, target) end ),
			SequenceNode{
				ConditionNode(function() return IsHungry(self.inst) and CanSeeFood(self.inst) end, "SeesFoodToEat"),
				ParallelNodeAny {
					WaitNode(1 + math.random()*2),
					PriorityNode {
						StandStill(self.inst, ShouldStandStill),
						Follow(self.inst, function() return self.inst.components.follower.leader end, MIN_FOLLOW_DIST, TARGET_FOLLOW_DIST, MAX_FOLLOW_DIST),
					},
				},
				DoAction(self.inst, function() return FindFoodAction(self.inst) end),
			},
			PriorityNode {
				StandStill(self.inst, ShouldStandStill),
				Follow(self.inst, function() return self.inst.components.follower.leader end, MIN_FOLLOW_DIST, TARGET_FOLLOW_DIST, MAX_FOLLOW_DIST),
			},
			Wander(self.inst, function() if self.inst.components.follower.leader then return Vector3(self.inst.components.follower.leader.Transform:GetWorldPosition()) end end, MAX_FOLLOW_DIST- 1, {minwalktime=.5, randwalktime=.5, minwaittime=6, randwaittime=3})	
	
    }, .25)
    
    self.bt = BT(self.inst, root)
    
	end	
 end

return SmallBirdBrain