local assets=
{
	Asset("ANIM", "anim/beefalo_basic.zip"),
	Asset("ANIM", "anim/beefalo_actions.zip"),
	Asset("ANIM", "anim/beefalo_build.zip"),
	Asset("ANIM", "anim/beefalo_heat_build.zip"),
	Asset("ANIM", "anim/beefalo_shaved_build.zip"),
	Asset("SOUND", "sound/beefalo.fsb"),
}

local prefabs =
{
    "meat",
    "poop",
    "beefalowool",
    "horn",
}

SetSharedLootTable( 'beefalo',
{
    {'meat',            1.00},
    {'meat',            1.00},
    {'meat',            1.00},
    {'meat',            1.00},
    {'beefalowool',     1.00},
    {'beefalowool',     1.00},
    {'beefalowool',     1.00},
    {'horn',            0.33},
})

local sounds = 
{
    walk = "dontstarve/beefalo/walk",
    grunt = "dontstarve/beefalo/grunt",
    yell = "dontstarve/beefalo/yell",
    swish = "dontstarve/beefalo/tail_swish",
    curious = "dontstarve/beefalo/curious",
    angry = "dontstarve/beefalo/angry",
	--SAT
	chew =  "dontstarve/beefalo/chew",
}


local function Retarget(inst)
	--GetPlayer().components.dynamicmusic:OnStartDanger()
    local newtarget = FindEntity(inst, 20, function(guy)
            return  guy.components.combat and 
                    inst.components.combat:CanTarget(guy) and
                    (guy.components.combat.target == GetPlayer() or GetPlayer().components.combat.target == guy)
    end)

    return newtarget
end

-- MUSIC COMBAT STAR IF BEEFALO HAVE NEW TARGET
local function OnNewTarget(inst, data)
	
	if data ~= nil then
		if data.target then
			local bf = Point(inst.Transform:GetWorldPosition())
			local tar = Point(data.target.Transform:GetWorldPosition())
			local dist = distsq(tar, bf)
			if dist > 500 or data.target:HasTag("petsat") then -- FAR or DON'T HIT FAMILY
			   inst.components.combat.target = nil 
			end
		end 
		if  data.target
			and not data.target:HasTag("prey")
			and not data.target:HasTag("bird")
			and not data.target:HasTag("wall")
			and not data.target:HasTag("butterfly")
			and not data.target:HasTag("shadow")
			and not data.target:HasTag("veggie")
			and not data.target:HasTag("smashable") then
			GetPlayer().components.dynamicmusic:OnStartDanger()
		end
	end
	
	
	--GetPlayer().components.dynamicmusic:OnStartDanger()
    --if inst.components.follower and data and data.target and data.target == inst.components.follower.leader then
    --    inst.components.follower:SetLeader(nil)
    --end
end

local function OnAttacked(inst, data)
    inst.components.combat:SetTarget(data.attacker)
    inst.components.combat:ShareTarget(data.attacker, 30,function(dude)
        return dude:HasTag("beefalo") and not dude:HasTag("player") and not dude.components.health:IsDead()
    end, 5)
end

local function GetStatus(inst)
    if inst.components.follower.leader ~= nil then
        return "FOLLOWER"
    elseif inst.components.beard and inst.components.beard.bits == 0 then
        return "NAKED"
    end
end

--SAT FOLLOW
local function MakeFollower(inst, leader)
    inst.Physics:SetCollisionGroup(COLLISION.CHARACTERS)
    inst.Physics:ClearCollisionMask()
    inst.Physics:CollidesWith(COLLISION.WORLD)
    inst.Physics:CollidesWith(COLLISION.OBSTACLES)
    inst.Physics:CollidesWith(COLLISION.CHARACTERS)    
    inst.DynamicShadow:Enable(true)
    if leader and leader.components.leader then
        leader.components.leader:AddFollower(inst)
    end
    
end

-------------------SAT
local function ontalk(inst, script)
	inst.SoundEmitter:PlaySound(inst.sounds.walk)
end

local function LoadFollower(inst, leader)	
    inst.sg:GoToState("idle")
end

-- SLEEPER WAKEUP 
-- PETS ONLY SLEEP ONE TIME AT DAY IF THEY WAKE UP , THEY DON'T SLEEP AGAIN THIS DAY
-- PETS WAKE UP IF SAT ARE FAR or NORMAL EVENTS
local function ShouldWakeUp(inst)
	local player = GetPlayer()
	local bf = Point(inst.Transform:GetWorldPosition())
    local pl = Point(player.Transform:GetWorldPosition())
	local dist = distsq(pl, bf)
	if dist > 400 then
		inst.sleepingday = GetClock().numcycles
		return true 
	end
    return DefaultWakeTest(inst)
end

local function ShouldSleep(inst)
	if inst.sleepingday < GetClock().numcycles then
		return DefaultSleepTest(inst)
	else
		return false
	end
end

----------TRADE
local function ShouldAcceptFood(inst, item)
    if item.prefab == "cutgrass" then
		return true
	else
		return false
	end	
end
local function OnGetFoodFromPlayer(inst, giver, item)
	inst.components.hunger:DoDelta(5)
	inst.components.health:DoDelta(10)
	inst.SoundEmitter:PlaySound(inst.sounds.chew)
	
	inst.components.locomotor:StopMoving()
	inst.AnimState:PlayAnimation("graze_loop", true)     
end
local function OnRefuseNotFromPlayer(inst, item)
	inst.SoundEmitter:PlaySound(inst.sounds.grunt)
	inst.components.locomotor:StopMoving()
	inst.AnimState:PlayAnimation("shake")
end

	STRINGS.NAMES.PETBEEFALO = "   ţ"
	STRINGS.CHARACTERS.GENERIC.DESCRIBE.PETBEEFALO =  "          ."


local function fn(Sim)
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
	local sound = inst.entity:AddSoundEmitter()
	inst.sounds = sounds
	local shadow = inst.entity:AddDynamicShadow()
	shadow:SetSize( 6, 2 )
    inst.Transform:SetFourFaced()

    MakeCharacterPhysics(inst, 100, .5)
	
	------- TAG FAMILY SAT
	inst:AddTag("petsat")
	------------------------
    
    inst:AddTag("beefalo")
    anim:SetBank("beefalo")
    anim:SetBuild("beefalo_build")
    anim:PlayAnimation("idle_loop", true)
    
    inst:AddTag("animal")
    inst:AddTag("largecreature")


    local hair_growth_days = 3

    inst:AddComponent("beard")
    -- assume the beefalo has already grown its hair
    inst.components.beard.bits = 3
    inst.components.beard.daysgrowth = hair_growth_days + 1 
    inst.components.beard.onreset = function()
        inst.sg:GoToState("shaved")
    end
    
    inst.components.beard.canshavetest = function() if not inst.components.sleeper:IsAsleep() then return false, "AWAKEBEEFALO" end return true end
    
    inst.components.beard.prize = "beefalowool"
    inst.components.beard:AddCallback(0, function()
        if inst.components.beard.bits == 0 then
            anim:SetBuild("beefalo_shaved_build")
        end
    end)
    inst.components.beard:AddCallback(hair_growth_days, function()
        if inst.components.beard.bits == 0 then
            inst.hairGrowthPending = true
        end
    end)
    
    inst:AddComponent("eater")
    inst.components.eater:SetVegetarian()	
    
    inst:AddComponent("combat")
    inst.components.combat.hiteffectsymbol = "beefalo_body"
    inst.components.combat:SetDefaultDamage(TUNING.BEEFALO_DAMAGE*1.25)
    inst.components.combat:SetRetargetFunction(1, Retarget) 
     
    inst:AddComponent("health")
    inst.components.health:SetMaxHealth(TUNING.BEEFALO_HEALTH)
	inst.components.health:StartRegen(2, 1)  -- REG HP

    inst:AddComponent("lootdropper")
    inst.components.lootdropper:SetChanceLootTable('beefalo')    
    
    inst:AddComponent("inspectable")
    inst.components.inspectable.getstatus = GetStatus
    
    inst:AddComponent("knownlocations")
	
    inst:AddComponent("herdmember")
    	
	-------------FOLLOWER
	inst:AddComponent("follower")
	local player =  GetPlayer()
	inst.components.follower:SetLeader(player)
	--------------------	
    inst:ListenForEvent("newcombattarget", OnNewTarget)
    inst:ListenForEvent("attacked", OnAttacked)

    inst:AddComponent("periodicspawner")
    inst.components.periodicspawner:SetPrefab("poop")
    inst.components.periodicspawner:SetRandomTimes(40, 60)
    inst.components.periodicspawner:SetDensityInRange(20, 2)
    inst.components.periodicspawner:SetMinimumSpacing(8)
    inst.components.periodicspawner:Start()

    MakeLargeBurnableCharacter(inst, "beefalo_body")
    MakeLargeFreezableCharacter(inst, "beefalo_body")
    
    inst:AddComponent("locomotor") -- locomotor must be constructed before the stategraph
    inst.components.locomotor.walkspeed = 5
    inst.components.locomotor.runspeed = 14
    
	---------------SLEEPER
    inst:AddComponent("sleeper")
    inst.components.sleeper:SetResistance(3)
	inst.components.sleeper:SetSleepTest(ShouldSleep)
    inst.components.sleeper:SetWakeTest(ShouldWakeUp)
	inst.sleepingday = -1 --********* NEW VAR TO CONTROL SLEEP/WAKE
    -------------------------------
	
	-------------TALKER
	inst:AddComponent("talker")
    inst.components.talker.ontalk = ontalk
    inst.components.talker.fontsize = 35
    inst.components.talker.font = TALKINGFONT
    inst.components.talker.colour = Vector3(255/255, 215/255, 0/255)
    inst.components.talker.offset = Vector3(0,-400,0)
	-------------HUNGER----------------
	inst:AddComponent("hunger")
	inst.components.hunger:SetMax(25)
	inst.components.hunger:SetRate(25 / (TUNING.TOTAL_DAY_TIME*3 ))
	inst.components.hunger:SetKillRate(0)
	--------------TRADE-------------------
	inst:AddComponent("trader")
	inst.components.trader:SetAcceptTest(ShouldAcceptFood)
	inst.components.trader.onaccept = OnGetFoodFromPlayer
	inst.components.trader.onrefuse = OnRefuseNotFromPlayer
	------------------STAYCOMAND---------------------------	
	inst:AddComponent("staycommand")	
	-----------------------------------    
    local brain = require "brains/petbeefalobrain"
    inst:SetBrain(brain)
    inst:SetStateGraph("SGpetBeefalo")
	inst.entity:AddMiniMapEntity()
    inst.MiniMapEntity:SetIcon("petbeefaloicon.tex")
    return inst

end

return Prefab( "forest/animals/petbeefalo", fn, assets, prefabs) 
