local brain = require "brains/petkoalefantbrain"
local brain = require "brains/petkoalefantbrain"

local assets=
{
	Asset("ANIM", "anim/koalefant_basic.zip"),
    Asset("ANIM", "anim/koalefant_actions.zip"),
    --Asset("ANIM", "anim/koalefant_build.zip"),
    Asset("ANIM", "anim/koalefant_summer_build.zip"),
    Asset("ANIM", "anim/koalefant_winter_build.zip"),
	Asset("SOUND", "sound/koalefant.fsb"),
}

local prefabs =
{
    "meat",
    "poop",
    "trunk_summer",
    "trunk_winter",
}

local loot_summer = {"meat","meat","meat","meat","meat","meat","meat","meat","trunk_summer"}
local loot_winter = {"meat","meat","meat","meat","meat","meat","meat","meat","trunk_winter"}


local WAKE_TO_RUN_DISTANCE = 10
local SLEEP_NEAR_ENEMY_DISTANCE = 14

-- SLEEPER WAKEUP 
-- PETS ONLY SLEEP ONE TIME AT DAY IF THEY WAKE UP , THEY DON'T SLEEP AGAIN THIS DAY
-- PETS WAKE UP IF SAT ARE FAR or NORMAL EVENTS
local function ShouldWakeUp(inst)
	local player = GetPlayer()
	local bf = Point(inst.Transform:GetWorldPosition())
    local pl = Point(player.Transform:GetWorldPosition())
	local dist = distsq(pl, bf)
	if dist > 400 then
		inst.sleepingday = GetClock().numcycles
		return true 
	end
    return DefaultWakeTest(inst)
end

local function ShouldSleep(inst)
	if inst.sleepingday < GetClock().numcycles then
		return DefaultSleepTest(inst)
	else
		return false
	end
end

local function Retarget(inst)

end

local function KeepTarget(inst, target)
    return distsq(Vector3(target.Transform:GetWorldPosition() ), Vector3(inst.Transform:GetWorldPosition() ) ) < TUNING.KOALEFANT_CHASE_DIST * TUNING.KOALEFANT_CHASE_DIST
end

local function OnNewTarget(inst, data)
	
	if data ~= nil then
		if data.target then
			if data.target:HasTag("petsat") then
				-- DON'T HIT FAMILY
				inst.components.combat.target = nil 
			end
		end
	end

end

local function GetStatus(inst)

end

local function OnAttacked(inst, data)
    inst.components.combat:SetTarget(data.attacker)
	
end


-------------------SAT
local function ontalk(inst, script)
	inst.SoundEmitter:PlaySound("dontstarve/rabbit/hop")

end

local function LoadFollower(inst, leader)	
    inst.sg:GoToState("idle")
end

----------TRADE
local function ShouldAcceptFood(inst, item)
    if (item.prefab == "eggplant" or item.prefab == "pumpkin" or item.prefab == "eggplant_cooked" or item.prefab == "pumpkin_cooked") then  --*********************
		return true
	else
		return false
	end	
end
local function OnGetFromPlayer(inst, giver, item)
	inst.components.hunger:DoDelta(25)
	inst.components.health:DoDelta(50)
	inst.SoundEmitter:PlaySound("dontstarve/creatures/koalefant/chew")	
	inst.components.locomotor:StopMoving()
	inst.AnimState:PlayAnimation("graze_loop", true)    
end
local function OnRefuseFromPlayer(inst, item)
	inst.SoundEmitter:PlaySound("dontstarve/creatures/koalefant/shake")
	inst.components.locomotor:StopMoving()
	inst.AnimState:PlayAnimation("shake")
end



local function create_base(sim)
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
	local sound = inst.entity:AddSoundEmitter()
	local shadow = inst.entity:AddDynamicShadow()
	shadow:SetSize( 4.5, 2 )
    inst.Transform:SetFourFaced()

    MakeCharacterPhysics(inst, 100, .75)
    
    inst:AddTag("petkoalefant")
	
    ------- TAG FAMILY SAT
	inst:AddTag("petsat")
	------------------------
    anim:SetBank("koalefant")
    anim:PlayAnimation("idle_loop", true)
    
    inst:AddTag("animal")
    inst:AddTag("largecreature")

    
    inst:AddComponent("eater")
    inst.components.eater:SetVegetarian()
	-------------TALKER
	inst:AddComponent("talker")
    inst.components.talker.ontalk = ontalk
    inst.components.talker.fontsize = 35
    inst.components.talker.font = TALKINGFONT
    inst.components.talker.colour = Vector3(152/255, 251/255, 152/255)
    inst.components.talker.offset = Vector3(0,-400,0)
	------------FOLLOWER
	inst:AddComponent("follower")
	local player =  GetPlayer()
	inst.components.follower:SetLeader(player)
	-------------HUNGER----------------
	inst:AddComponent("hunger")
	inst.components.hunger:SetMax(25)
	inst.components.hunger:SetRate(25 / (TUNING.TOTAL_DAY_TIME*6))
	inst.components.hunger:SetKillRate(0)
	--------------TRADE-------------------
	inst:AddComponent("trader")
	inst.components.trader:SetAcceptTest(ShouldAcceptFood)
	inst.components.trader.onaccept = OnGetFromPlayer
	inst.components.trader.onrefuse = OnRefuseFromPlayer
	------------------STAYCOMAND---------------------------	
	inst:AddComponent("staycommand")	
	-----------------------------------
	inst:AddComponent("sleeper")
    inst.components.sleeper:SetResistance(3)
    inst.components.sleeper:SetSleepTest(ShouldSleep)
    inst.components.sleeper:SetWakeTest(ShouldWakeUp)
	inst.sleepingday = -1 --********* NEW VAR TO CONTROL SLEEP/WAKE
    -------------------------------
    inst:AddComponent("combat")
    inst.components.combat.hiteffectsymbol = "beefalo_body"
    inst.components.combat:SetDefaultDamage(TUNING.KOALEFANT_DAMAGE*1.5)
    inst.components.combat:SetRetargetFunction(1, Retarget)
    inst.components.combat:SetKeepTargetFunction(KeepTarget)
    inst:ListenForEvent("newcombattarget", OnNewTarget)
    inst:ListenForEvent("attacked", function(inst, data) OnAttacked(inst, data) end)
    
     
    inst:AddComponent("health")
    inst.components.health:SetMaxHealth(TUNING.KOALEFANT_HEALTH)
	inst.components.health:StartRegen(2, 1)

    inst:AddComponent("lootdropper")
    
    inst:AddComponent("inspectable")
    inst.components.inspectable.getstatus = GetStatus
    
    inst:AddComponent("knownlocations")
    
    inst:AddComponent("periodicspawner")
    inst.components.periodicspawner:SetPrefab("poop")
    inst.components.periodicspawner:SetRandomTimes(40, 60)
    inst.components.periodicspawner:SetDensityInRange(20, 2)
    inst.components.periodicspawner:SetMinimumSpacing(8)
    inst.components.periodicspawner:Start()

    MakeLargeBurnableCharacter(inst, "beefalo_body")
    MakeLargeFreezableCharacter(inst, "beefalo_body")

    inst:AddComponent("locomotor") -- locomotor must be constructed before the stategraph
    inst.components.locomotor.walkspeed = 5 -- SAT default = 1.5
    inst.components.locomotor.runspeed = 14 -- SAT default = 7
    

    
    inst:SetBrain(brain)
    inst:SetStateGraph("SGpetkoalefant")
	inst.entity:AddMiniMapEntity()
    inst.MiniMapEntity:SetIcon("petkoalefanticon.tex")
    return inst
end

local function create_summer(sim)
	local inst = create_base(sim)

    inst.AnimState:SetBuild("koalefant_summer_build")
    inst.components.lootdropper:SetLoot(loot_summer)
	
	STRINGS.NAMES.PETKOALEFANT_SUMMER = "   "
	STRINGS.CHARACTERS.GENERIC.DESCRIBE.PETKOALEFANT_SUMMER =  " ë   , ů   . . ."

	return inst
end

local function create_winter(sim)
	local inst = create_base(sim)

    inst.AnimState:SetBuild("koalefant_winter_build")
    inst.components.lootdropper:SetLoot(loot_winter)
	
	STRINGS.NAMES.PETKOALEFANT_WINTER = "  "
	STRINGS.CHARACTERS.GENERIC.DESCRIBE.PETKOALEFANT_WINTER =  " ë   , ů   . . ."

	return inst
end

return Prefab( "forest/animals/petkoalefant_summer", create_summer, assets, prefabs),
	   Prefab( "forest/animals/petkoalefant_winter", create_winter, assets, prefabs) 
