
local assets=
{
	Asset("ANIM", "anim/ds_rabbit_basic.zip"),
	Asset("ANIM", "anim/rabbit_build.zip"),
	Asset("ANIM", "anim/beard_monster.zip"),
	Asset("ANIM", "anim/rabbit_winter_build.zip"),
	Asset("SOUND", "sound/rabbit.fsb"),
}

local prefabs =
{
    "smallmeat",
    "cookedsmallmeat",
    "beardhair",
}

STRINGS.NAMES.PETRABBIT = "   "
STRINGS.CHARACTERS.GENERIC.DESCRIBE.PETRABBIT =  "    ,     ."

local rabbitsounds = 
{
    scream = "dontstarve/rabbit/scream",
    hurt = "dontstarve/rabbit/scream_short",
}

local beardsounds = 
{
    scream = "dontstarve/rabbit/beardscream",
    hurt = "dontstarve/rabbit/beardscream_short",
}

local wintersounds = 
{
    scream = "dontstarve/rabbit/winterscream",
    hurt = "dontstarve/rabbit/winterscream_short",
}

local function onpickup(inst)

end


local brain = require "brains/petrabbitbrain"

local function BecomeRabbit(inst)
	inst.colorskin = "brown"
	if not inst.israbbit or inst.iswinterrabbit then
		inst.AnimState:SetBuild("rabbit_build")
	    inst.components.lootdropper:SetLoot({"smallmeat"})
	    inst.israbbit = true
	    inst.iswinterrabbit = false
		inst.components.sanityaura.aura = TUNING.SANITYAURA_TINY
		inst.components.inventoryitem:ChangeImageName("rabbit")
		inst.sounds = rabbitsounds
		STRINGS.NAMES.PETRABBIT = "   "
		STRINGS.CHARACTERS.GENERIC.DESCRIBE.PETRABBIT =  "    ,     ."
		inst.components.talker.colour = Vector3(250/255, 160/255, 122/255)
	end
end

local function BecomeBeardling(inst)
	if inst.israbbit or inst.iswinterrabbit then
		inst.AnimState:SetBuild("beard_monster")
	    inst.components.lootdropper:SetLoot{}
		inst.components.lootdropper:AddRandomLoot("beardhair", .5)	    
		inst.components.lootdropper:AddRandomLoot("monstermeat", 1)	    
		inst.components.lootdropper:AddRandomLoot("nightmarefuel", 1)	  
		inst.components.lootdropper.numrandomloot = 1  
		inst.components.sanityaura.aura = -TUNING.SANITYAURA_MED		
	    inst.israbbit = false
	    inst.iswinterrabbit = false
	    inst.components.inventoryitem:ChangeImageName("beard_monster")
		inst.sounds = beardsounds
		STRINGS.NAMES.PETRABBIT = "     "
		STRINGS.CHARACTERS.GENERIC.DESCRIBE.PETRABBIT =  "  ʲ ô ? !      ? !"
		inst.components.talker.colour = Vector3(255/255, 60/255, 0/255)
	end
end

local function DonWinterFur(inst)
	inst.colorskin = "white"
	if not inst.iswinterrabbit or inst.israbbit then
		inst.AnimState:SetBuild("rabbit_winter_build")
		inst.components.lootdropper:SetLoot({"smallmeat"})
		inst.israbbit = false
	    inst.iswinterrabbit = true
		inst.components.sanityaura.aura = TUNING.SANITYAURA_TINY
		inst.components.inventoryitem:ChangeImageName("rabbit_winter")
		inst.sounds = wintersounds
		STRINGS.NAMES.PETRABBIT = "     "
		STRINGS.CHARACTERS.GENERIC.DESCRIBE.PETRABBIT =  "    ,     ."
		inst.components.talker.colour = Vector3(255/255, 160/255, 122/255)
	end
end

local function CheckTransformState(inst)
	if not inst.components.health:IsDead() then
		local player = GetPlayer()
		if player.components.sanity:GetPercent() > TUNING.BEARDLING_SANITY then
			if SEASONS.AUTUMN then 
			--************ D  L  C *********--
				if not GetSeasonManager() or not GetSeasonManager():IsWinter() then
					BecomeRabbit(inst)
				else
					DonWinterFur(inst)
				end
				--[[
				if GetWorld():IsCave() then
					if GetSeasonManager():IsWinter() then
						print("WINTER")					
					elseif GetSeasonManager():IsSummer() then
						print("SUMMER ")
					else
						print("SPRING OR FALL")	
					end
				end	--}]]	
			else
					if GetSeasonManager():IsWinter() or inst.colorskin == "white" then
						--print("WINTER")	
						DonWinterFur(inst)	
					elseif GetSeasonManager():IsSummer() or inst.colorskin == "brown" then
						--print("SUMMER ")
					else
						--print("SPRING OR FALL")	
					end
				--[[if not GetSeasonManager() or GetSeasonManager():IsSummer() then
					BecomeRabbit(inst)
				else
					DonWinterFur(inst)
				end--]]
			end
		else
			BecomeBeardling(inst)			
		end
	end
end

local function ondrop(inst)

	inst.sg:GoToState("stunned")
	CheckTransformState(inst)
end


local function OnWake(inst)
	CheckTransformState(inst)
	inst.checktask = inst:DoPeriodicTask(10, CheckTransformState)
end

local function OnSleep(inst)
	 if inst.checktask then
	 	inst.checktask:Cancel()
	 	inst.checktask = nil
	 end
end

local function GetCookProductFn(inst)
	if inst.israbbit or inst.iswinterrabbit then
		return "cookedsmallmeat" 
	else 
		return "cookedmonstermeat"
	end
end

local function OnCookedFn(inst)
	inst.SoundEmitter:PlaySound("dontstarve/rabbit/scream_short")

end

local function OnAttacked(inst, data)
    local x,y,z = inst.Transform:GetWorldPosition()
    local ents = TheSim:FindEntities(x,y,z, 30, {'rabbit'})
    
    local num_friends = 0
    local maxnum = 5
    for k,v in pairs(ents) do
        v:PushEvent("gohome")
        num_friends = num_friends + 1
        
        if num_friends > maxnum then
            break
        end
    end
end

--SAT FOLLOW
local function MakeFollower(inst, leader)
    inst.Physics:SetCollisionGroup(COLLISION.CHARACTERS)
    inst.Physics:ClearCollisionMask()
    inst.Physics:CollidesWith(COLLISION.WORLD)
    inst.Physics:CollidesWith(COLLISION.OBSTACLES)
    inst.Physics:CollidesWith(COLLISION.CHARACTERS)    
    inst.DynamicShadow:Enable(true)
    if leader and leader.components.leader then
        leader.components.leader:AddFollower(inst)
    end
    
end

-------------------SAT
local function ontalk(inst, script)
	inst.SoundEmitter:PlaySound("dontstarve/rabbit/hop")
end

local function LoadFollower(inst, leader)	
    inst.sg:GoToState("idle")
end

----------TRADE
local function ShouldAcceptCarrot(inst, item)
    if (item.prefab == "carrot" or item.prefab == "berries") and inst.components.hunger.current < 23 then
		return true
	else
		return false
	end	
end
local function OnGetCarrotFromPlayer(inst, giver, item)
	inst.components.hunger:DoDelta(5)
	inst.SoundEmitter:PlaySound("dontstarve/rabbit/hop")
	inst.components.locomotor:StopMoving()
	inst.AnimState:PlayAnimation("rabbit_eat_pre", false)
end
local function OnRefuseNotCarrot(inst, item)
	inst.SoundEmitter:PlaySound(inst.sounds.scream)
	inst.components.locomotor:StopMoving()
	inst.AnimState:PlayAnimation("lookup_pst")
end

-- SLEEPER WAKEUP 
-- PETS ONLY SLEEP ONE TIME AT DAY IF THEY WAKE UP , THEY DON'T SLEEP AGAIN THIS DAY
-- PETS WAKE UP IF SAT ARE FAR or NORMAL EVENTS
local function ShouldWakeUp(inst)
	local player = GetPlayer()
	local bf = Point(inst.Transform:GetWorldPosition())
    local pl = Point(player.Transform:GetWorldPosition())
	local dist = distsq(pl, bf)
	if dist > 400 then
		inst.sleepingday = GetClock().numcycles
		return true 
	end
    return DefaultWakeTest(inst)
end

local function ShouldSleep(inst)
	if inst.sleepingday < GetClock().numcycles then
		return DefaultSleepTest(inst)
	else
		return false
	end
end

local function fn(Sim)
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
    local physics = inst.entity:AddPhysics()
	local sound = inst.entity:AddSoundEmitter()
	local shadow = inst.entity:AddDynamicShadow()
	shadow:SetSize( 1, .75 )
    inst.Transform:SetFourFaced()

    MakeCharacterPhysics(inst, 1, 0.5)
	
	------- TAG FAMILY SAT
	inst:AddTag("petsat")
	------------------------

    anim:SetBank("rabbit")
    anim:SetBuild("rabbit_build")
    anim:PlayAnimation("idle")
    
    inst:AddComponent("locomotor") -- locomotor must be constructed before the stategraph
    inst.components.locomotor.runspeed = TUNING.RABBIT_RUN_SPEED * 2
	-------------TALKER
	inst:AddComponent("talker")
    inst.components.talker.ontalk = ontalk
    inst.components.talker.fontsize = 35
    inst.components.talker.font = TALKINGFONT
    inst.components.talker.colour = Vector3(255/255, 160/255, 122/255)
    inst.components.talker.offset = Vector3(0,-400,0)
	-------------FOLLOWER
	inst:AddComponent("follower")
	local player =  GetPlayer()
	inst.components.follower:SetLeader(player)
	-------------HUNGER----------------
	inst:AddComponent("hunger")
	inst.components.hunger:SetMax(25)
	inst.components.hunger:SetRate(25 / (TUNING.TOTAL_DAY_TIME*3 ))
	inst.components.hunger:SetKillRate(0)
	--------------TALKER-------------------
	inst:AddComponent("trader")
	inst.components.trader:SetAcceptTest(ShouldAcceptCarrot)
	inst.components.trader.onaccept = OnGetCarrotFromPlayer
	inst.components.trader.onrefuse = OnRefuseNotCarrot
	-----------------------------------
	
    inst:SetStateGraph("SGpetrabbit")

    inst:AddTag("animal")
    inst:AddTag("prey")
    inst:AddTag("rabbit")
    inst:AddTag("smallcreature")
    inst:AddTag("canbetrapped")    

    inst:SetBrain(brain)
    
    inst.data = {}
    
    inst:AddComponent("eater")
    inst.components.eater:SetVegetarian()

	inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.nobounce = true
	inst.components.inventoryitem.canbepickedup = true
	inst.components.inventoryitem:SetOnPickupFn(onpickup)
	inst.components.inventoryitem:SetOnDroppedFn(ondrop)
	inst:AddComponent("sanityaura")

    
    inst:AddComponent("knownlocations")
    inst:AddComponent("combat")
    inst.components.combat.hiteffectsymbol = "chest"
    inst:AddComponent("health")
    inst.components.health:SetMaxHealth(TUNING.RABBIT_HEALTH)
	inst.components.health:StartRegen(1, 1)
    inst.components.health.murdersound = "dontstarve/rabbit/scream_short"
	-- NO MURDER
	inst.components.health.canmurder = false 
    
    MakeSmallBurnableCharacter(inst, "chest")
    MakeTinyFreezableCharacter(inst, "chest")

    inst:AddComponent("lootdropper")
    
    inst:AddComponent("inspectable")
	
    inst:AddComponent("sleeper")
	inst.components.sleeper:SetSleepTest(ShouldSleep)
    inst.components.sleeper:SetWakeTest(ShouldWakeUp)
	inst.sleepingday = -1 --********* NEW VAR TO CONTROL SLEEP/WAKE
    -------------------------------

	BecomeRabbit(inst)
    CheckTransformState(inst)
    inst.CheckTransformState = CheckTransformState
	
	inst.OnEntityWake = OnWake
	inst.OnEntitySleep = OnSleep    
    
    inst.OnSave = function(inst, data)
        if not inst.israbbit then
			data.israbbit = inst.israbbit
		end
        data.iswinterrabbit = inst.iswinterrabbit or nil
		data.colorskin = inst.colorskin
    end        
    
    inst.OnLoad = function(inst, data)
        if data then
				local israbbit = data.israbbit or true
		        if not israbbit and not data.iswinterrabbit then
					BecomeBeardling(inst)
				else if not israbbit and data.iswinterrabbit then
					DonWinterFur(inst)					
		        end
		    end
			inst.colorskin = data.colorskin
	    end 
    end
        
    inst:ListenForEvent("attacked", OnAttacked)

    return inst
end

return Prefab( "forest/animals/petrabbit", fn, assets, prefabs) 
