
local assets=
{
	Asset("ANIM", "anim/ds_tallbird_basic.zip"),
	Asset("SOUND", "sound/tallbird.fsb"),
}
    
    
local prefabs =
{
    "meat",
}

local loot = { "meat", "meat" }

local function Retarget(inst)

    local newtarget = FindEntity(inst, 20, function(guy)
            return  guy.components.combat and 
                    inst.components.combat:CanTarget(guy) and
                    (guy.components.combat.target == GetPlayer() or GetPlayer().components.combat.target == guy)
    end)

    return newtarget
end

-- MUSIC COMBAT STAR IF TALLBIRD HAVE NEW TARGET
local function OnNewTarget(inst, data)
	if data ~= nil then
		if data.target then
			local bf = Point(inst.Transform:GetWorldPosition())
			local tar = Point(data.target.Transform:GetWorldPosition())
			local dist = distsq(tar, bf)
			if dist > 400 or data.target:HasTag("petsat") then -- FAR or DON'T HIT FAMILY
			   inst.components.combat.target = nil 
			end
		end 
		if  data.target
			and not data.target:HasTag("prey")
			and not data.target:HasTag("bird")
			and not data.target:HasTag("wall")
			and not data.target:HasTag("butterfly")
			and not data.target:HasTag("shadow")
			and not data.target:HasTag("veggie")
			and not data.target:HasTag("smashable") then
			GetPlayer().components.dynamicmusic:OnStartDanger()
		end
	end
	--GetPlayer().components.dynamicmusic:OnStartDanger()
    --if inst.components.follower and data and data.target and data.target == inst.components.follower.leader then
    --   inst.components.follower:SetLeader(nil)
    --end
end

local function OnAttacked(inst, data)
    inst.components.combat:SetTarget(data.attacker)    
end

-------------------SAT
local function ontalk(inst, script)
	inst.SoundEmitter:PlaySound("dontstarve/rabbit/hop")
end

local function LoadFollower(inst, leader)	
    inst.sg:GoToState("idle")
end



--SAT FOLLOW
local function MakeFollower(inst, leader)
    inst.Physics:SetCollisionGroup(COLLISION.CHARACTERS)
    inst.Physics:ClearCollisionMask()
    inst.Physics:CollidesWith(COLLISION.WORLD)
    inst.Physics:CollidesWith(COLLISION.OBSTACLES)
    inst.Physics:CollidesWith(COLLISION.CHARACTERS)    
    inst.DynamicShadow:Enable(true)
    if leader and leader.components.leader then
        leader.components.leader:AddFollower(inst)
    end
    
end

-- SLEEPER WAKEUP 
-- PETS ONLY SLEEP ONE TIME AT DAY IF THEY WAKE UP , THEY DON'T SLEEP AGAIN THIS DAY
-- PETS WAKE UP IF SAT ARE FAR or NORMAL EVENTS
local function ShouldWakeUp(inst)
	local player = GetPlayer()
	local bf = Point(inst.Transform:GetWorldPosition())
    local pl = Point(player.Transform:GetWorldPosition())
	local dist = distsq(pl, bf)
	if dist > 400 then
		inst.sleepingday = GetClock().numcycles
		return true 
	end
    return DefaultWakeTest(inst)
end

local function ShouldSleep(inst)
	if inst.sleepingday < GetClock().numcycles then
		return DefaultSleepTest(inst)
	else
		return false
	end
end

local function OnAttacked(inst, data)
    inst.components.combat:SuggestTarget(data.attacker)
end

----------TRADE
local function ShouldAcceptFood(inst, item)
    if item.components.edible.foodtype == "MEAT" then -- 23
		return true
	else
		return false
	end	
end

local function OnGetFoodFromPlayer(inst, giver, item)
	inst.components.hunger:DoDelta(5)
	inst.components.health:DoDelta(10)
	inst.SoundEmitter:PlaySound("dontstarve/creatures/teenbird/chirp")
	
	inst.components.locomotor:StopMoving()
	inst.AnimState:PlayAnimation("hungry", true)    
end
local function OnRefuseNotFromPlayer(inst, item)
	inst.SoundEmitter:PlaySound("dontstarve/creatures/teenbird/scratch_ground")
	inst.components.locomotor:StopMoving()
	inst.AnimState:PlayAnimation("taunt")
end




	STRINGS.NAMES.PETTALLBIRD = "   "
	STRINGS.CHARACTERS.GENERIC.DESCRIBE.PETTALLBIRD =  "  Ϊ   ͬ  ."

local function fn(Sim)
	local inst = CreateEntity()
	
    inst.entity:AddTransform()
	inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter()
	inst.entity:AddLightWatcher()
    --inst.Transform:SetScale(1.5,1.5,1.5)
	local shadow = inst.entity:AddDynamicShadow()
	shadow:SetSize( 2.75, 1)
    inst.Transform:SetFourFaced()
    
    ------- TAG FAMILY SAT
	inst:AddTag("petsat")
	------------------------

    
    MakeCharacterPhysics(inst, 10, .5)

    
    inst:AddTag("tallbird")
    inst:AddTag("animal")
    inst:AddTag("largecreature")
    inst.AnimState:SetBank("tallbird")
    inst.AnimState:SetBuild("ds_tallbird_basic")
    inst.AnimState:PlayAnimation("idle")
    inst.AnimState:Hide("beakfull")
    
    inst:AddComponent("locomotor") -- locomotor must be constructed before the stategraph
    inst.components.locomotor.walkspeed = 10 -- Basic = 7

    
    inst:AddComponent("lootdropper")
    inst.components.lootdropper:SetLoot(loot)   
    ---------------------        
    inst:AddComponent("eater")
    inst.components.eater:SetCarnivore()
    inst.components.eater:SetCanEatHorrible()
    inst.components.eater.strongstomach = true -- can eat monster meat!
    ------------------
    inst:AddComponent("health")
    inst.components.health:SetMaxHealth(TUNING.TALLBIRD_HEALTH)
    inst.components.health:StartRegen(2, 1)  -- REG HP
    ------------------    
    inst:AddComponent("combat")
    inst.components.combat.hiteffectsymbol = "head"
    inst.components.combat:SetDefaultDamage(TUNING.TALLBIRD_DAMAGE*1.5)
    inst.components.combat:SetAttackPeriod(TUNING.TALLBIRD_ATTACK_PERIOD)
    inst.components.combat:SetRetargetFunction(3, Retarget)
    ---------------------------------
    MakeLargeBurnableCharacter(inst, "head")
    MakeLargeFreezableCharacter(inst, "head")
	------------------    
    inst:AddComponent("knownlocations") 
	------------------       
    inst:AddComponent("inspectable") 
	-------------FOLLOWER
	inst:AddComponent("follower")
	local player =  GetPlayer()
	inst.components.follower:SetLeader(player)	
	---------------SLEEPER
    inst:AddComponent("sleeper")
    inst.components.sleeper:SetResistance(3)
	inst.components.sleeper:SetSleepTest(ShouldSleep)
    inst.components.sleeper:SetWakeTest(ShouldWakeUp)
	inst.sleepingday = -1 --********* NEW VAR TO CONTROL SLEEP/WAKE
	-------------TALKER
	inst:AddComponent("talker")
    inst.components.talker.ontalk = ontalk
    inst.components.talker.fontsize = 35
    inst.components.talker.font = TALKINGFONT
    inst.components.talker.colour = Vector3(221/255, 160/255, 221/255)
    inst.components.talker.offset = Vector3(0,-800,0)
   	-------------HUNGER----------------
	inst:AddComponent("hunger")
	inst.components.hunger:SetMax(25)
	inst.components.hunger:SetRate(25 / (TUNING.TOTAL_DAY_TIME*3 ))
	inst.components.hunger:SetKillRate(0)
    --------------TRADE-------------------
	inst:AddComponent("trader")
	inst.components.trader:SetAcceptTest(ShouldAcceptFood)
	inst.components.trader.onaccept = OnGetFoodFromPlayer
	inst.components.trader.onrefuse = OnRefuseNotFromPlayer
	------------------STAYCOMAND---------------------------	
	inst:AddComponent("staycommand")	
	----------------LISTENNERS---------    
    inst:ListenForEvent("newcombattarget", OnNewTarget)
    inst:ListenForEvent("attacked", OnAttacked)
    ----------------BRAIN   & SG ------------------- 
    local brain = require "brains/pettallbirdbrain"
    inst:SetBrain(brain)
	inst:SetStateGraph("SGpettallbird")
    --  ICON MINIPAT	
    inst.entity:AddMiniMapEntity()
    inst.MiniMapEntity:SetIcon("pettallbirdicon.tex")
	-------------------------------------------
	------ VAR -- YANDERE BEHAVIOUR
	inst.family = GetPlayer().components.leader.numfollowers
	
	--[[
	inst.OnSave = function(inst, data)
		data.family = inst.family
    end        
    
    inst.OnLoad = function(inst, data)    
		if data then
			inst.family = data.family			
		end
    end   --]]       
	
    return inst
end

return Prefab( "forest/monsters/pettallbird", fn, assets, prefabs) 
