local MakePlayerCharacter = require "prefabs/player_common"


local assets = {

        Asset( "ANIM", "anim/player_basic.zip" ),
        Asset( "ANIM", "anim/player_idles_shiver.zip" ),
        Asset( "ANIM", "anim/player_actions.zip" ),
        Asset( "ANIM", "anim/player_actions_axe.zip" ),
        Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
        Asset( "ANIM", "anim/player_actions_shovel.zip" ),
        Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
        Asset( "ANIM", "anim/player_actions_eat.zip" ),
        Asset( "ANIM", "anim/player_actions_item.zip" ),
        Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
        Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
        Asset( "ANIM", "anim/player_actions_fishing.zip" ),
        Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
        Asset( "ANIM", "anim/player_bush_hat.zip" ),
        Asset( "ANIM", "anim/player_attacks.zip" ),
        Asset( "ANIM", "anim/player_idles.zip" ),
        Asset( "ANIM", "anim/player_rebirth.zip" ),
        Asset( "ANIM", "anim/player_jump.zip" ),
        Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
        Asset( "ANIM", "anim/player_teleport.zip" ),
        Asset( "ANIM", "anim/wilson_fx.zip" ),
        Asset( "ANIM", "anim/player_one_man_band.zip" ),
        Asset( "ANIM", "anim/shadow_hands.zip" ),
        Asset( "SOUND", "sound/sfx.fsb" ),
        Asset( "SOUND", "sound/wilson.fsb" ),
        Asset( "ANIM", "anim/beard.zip" ),

		-- Don't forget to include your character's custom assets!
        Asset( "ANIM", "anim/sat.zip" ),
}
local prefabs = {}


local function onsanitychange(inst, data)

	if inst.components.sanity.current > 200 then
	   inst.components.combat.damagemultiplier = 1.25   
    else
	   inst.components.combat.damagemultiplier = 0.75 
    end
	
end

local fn = function(inst)

	-- choose which sounds this character will play
	inst.soundsname = "wendy"

	-- a minimap icon must be specified
	--inst.MiniMapEntity:SetIcon( "wilson.png" )
	inst.entity:AddMiniMapEntity()
    inst.MiniMapEntity:SetIcon("saticon.tex")

	-- todo: Add an example special power here.
	inst.components.sanity:SetMax(300)
	inst.components.health.maxhealth = 100
	inst:ListenForEvent("sanitydelta", onsanitychange)
	--[[
	inst:DoPeriodicTask(5, function()
		if inst.Musictheme == "sat" then
			print("MUSICA BIEN")
		elseif inst.Musictheme == "not" then
			print("MUSICA DEFAULT")
		else
			print("Un Cristo")
		end
	end)--]]
	
	
end

return MakePlayerCharacter("sat", prefabs, assets, fn)
