local brain = require "brains/tallbirdbrain"

local assets=
{
	Asset("ANIM", "anim/ds_tallbird_basic.zip"),
	Asset("SOUND", "sound/tallbird.fsb"),
}
    
    
local prefabs =
{
    "meat",
}

local loot = { "meat", "meat" }
local MAX_CHASEAWAY_DIST = 32
local MAX_CHASE_DIST = 256
--SAT
local TALLBIRD_SEE_EGG_DIST = 8

local function ontalk(inst, script)
	inst.SoundEmitter:PlaySound("dontstarve/rabbit/hop")
end

local function SpringMod(amt)
    if GetSeasonManager() and GetSeasonManager():IsSpring() then
        return amt * TUNING.SPRING_COMBAT_MOD
    else
        return amt
    end
end

local function FindThreatToNest(inst)
	if GetPlayer().prefab ~= "sat" then 
		if inst.components.homeseeker and inst.components.homeseeker:HasHome() then
			return FindEntity(inst.components.homeseeker.home, TUNING.TALLBIRD_DEFEND_DIST, function(guy)
				return (guy:HasTag("character") or guy:HasTag("animal") or guy:HasTag("monster") )
					and not guy:HasTag("tallbird")
					and guy.components.health
					and not guy.components.health:IsDead()
					and inst.components.combat:CanTarget(guy)
			end)
		end
	else
		if inst.components.homeseeker and inst.components.homeseeker:HasHome() then
			if SEASONS.AUTUMN then 
			--************ D  L  C *********--			
		        return FindEntity(inst.components.homeseeker.home, SpringMod(TUNING.TALLBIRD_DEFEND_DIST), function(guy)
		            return (guy:HasTag("character") or guy:HasTag("animal") or guy:HasTag("monster") )
		                and not guy:HasTag("tallbird")
		                and not guy:HasTag("springbird")
		                and guy.components.health
		                and not guy.components.health:IsDead()
		                and inst.components.combat:CanTarget(guy)
		        end)
			else
				return FindEntity(inst.components.homeseeker.home, TUNING.TALLBIRD_DEFEND_DIST, function(guy)
					return (guy:HasTag("character") or guy:HasTag("animal") or guy:HasTag("monster") )
						and not guy:HasTag("tallbird")
						and not guy:HasTag("player")
						and guy.components.health
						and not guy.components.health:IsDead()
						and inst.components.combat:CanTarget(guy)
				end)
			end
		end
	end	
end

-- SAT -> Boolean IF OBJECT IS A TALLBIRDEGG
local function is_an_tallbirdegg(item)
	return item.prefab == "tallbirdegg" 
end


local function Retarget(inst)
	if GetPlayer().prefab ~= "sat" then
		if SEASONS.AUTUMN then 
		--************ D  L  C *********--
			local newtarget = FindThreatToNest(inst)		    
		    if not newtarget then
		        newtarget = FindEntity(inst, SpringMod(TUNING.TALLBIRD_TARGET_DIST), function(guy)
		            return guy:HasTag("pig")
		                   and not guy:HasTag("werepig")
		                   and guy.components.health
		                   and not guy.components.health:IsDead()
		                   and inst.components.combat:CanTarget(guy)
		        end)
		    end
		
		    if not newtarget then
		        newtarget = FindEntity(inst, SpringMod(TUNING.TALLBIRD_TARGET_DIST), function(guy)
		            return (guy:HasTag("character") or guy:HasTag("monster") )
		                and not guy:HasTag("tallbird")
		                and not guy:HasTag("springbird")
		                and guy.components.health
		                and not guy.components.health:IsDead()
		                and inst.components.combat:CanTarget(guy)
		        end)
		    end
		
		    return newtarget
		else 
			local newtarget = FindThreatToNest(inst) 
			if not newtarget then
				newtarget = FindEntity(inst, TUNING.TALLBIRD_TARGET_DIST, function(guy)
					return guy:HasTag("pig")
						   and not guy:HasTag("werepig")
						   and guy.components.health
						   and not guy.components.health:IsDead()
						   and inst.components.combat:CanTarget(guy)
				end)
			end
			if not newtarget then
				newtarget = FindEntity(inst, TUNING.TALLBIRD_TARGET_DIST, function(guy)
					return (guy:HasTag("character") or guy:HasTag("monster") )
						and not guy:HasTag("tallbird")
						and guy.components.health
						and not guy.components.health:IsDead()
						and inst.components.combat:CanTarget(guy)
				end)
			end
			return newtarget
		end	
	else
		local DIST = TUNING.TALLBIRD_TARGET_DIST
		if SEASONS.AUTUMN and  GetSeasonManager() and GetSeasonManager():IsSpring() then 
			--************ D  L  C *********--
			DIST = DIST * TUNING.SPRING_COMBAT_MOD
		end		
		-- Target SAT IF SHE HAVE TALLBIRDEGG IN HER INVENTORY
		local newtarget = FindThreatToNest(inst) 
		newtarget = FindEntity(inst, TUNING.TALLBIRD_TARGET_DIST, 
			function(guy)
				if guy.components.health and not guy.components.health:IsDead() and inst.components.combat:CanTarget(guy) then
					if guy:HasTag("player") and guy.components.inventory and guy:GetDistanceSqToInst(inst) < TALLBIRD_SEE_EGG_DIST*TALLBIRD_SEE_EGG_DIST and guy.components.inventory:FindItem(is_an_tallbirdegg) then return guy end
				end
			end)
		-- Target other mobs
		if not newtarget then
			newtarget = FindEntity(inst, DIST, 
			function(guy)
				if guy:HasTag("rabbit") then
					return guy:HasTag("rabbit")
					and guy.components.health
					and not guy.components.health:IsDead()
					and inst.components.combat:CanTarget(guy)
				end	
			end)
		end	
		if not newtarget then
			newtarget = FindEntity(inst,DIST, function(guy)
				if guy:HasTag("beefalo") then
					return guy:HasTag("beefalo")
					and guy.components.health
					and not guy.components.health:IsDead()
					and inst.components.combat:CanTarget(guy)
				end	
			end)
		end	
		if not newtarget then
			newtarget = FindEntity(inst,DIST, function(guy)
				if guy:HasTag("petkoalefant") then
					return guy:HasTag("petkoalefant")
					and guy.components.health
					and not guy.components.health:IsDead()
					and inst.components.combat:CanTarget(guy)
				end	
			end)
		end	
		if not newtarget then
			newtarget = FindEntity(inst,DIST, function(guy)
				return guy:HasTag("pig")
					   and not guy:HasTag("werepig")
					   and guy.components.health
					   and not guy.components.health:IsDead()
					   and inst.components.combat:CanTarget(guy)
			end)
		end	
		if not newtarget then
			newtarget = FindEntity(inst,DIST, function(guy)
				return (guy:HasTag("character") or guy:HasTag("monster") )
					and not (guy:HasTag("tallbird") or guy:HasTag("player"))
					and guy.components.health
					and not guy.components.health:IsDead()
					and inst.components.combat:CanTarget(guy)
			end)
		end
		return newtarget
	end	
end

local function KeepTarget(inst, target)
    local home = inst.components.homeseeker and inst.components.homeseeker.home
    if home and home.components.pickable then
		if SEASONS.AUTUMN then
		--************ D  L  C *********--
			if not home.components.pickable:CanBePicked() and target == home.thief then
	            return distsq(Vector3(home.Transform:GetWorldPosition() ), Vector3(inst.Transform:GetWorldPosition() ) ) < SpringMod(MAX_CHASE_DIST*MAX_CHASE_DIST)
	        else
	            return distsq(Vector3(home.Transform:GetWorldPosition() ), Vector3(inst.Transform:GetWorldPosition() ) ) < SpringMod(MAX_CHASEAWAY_DIST*MAX_CHASEAWAY_DIST)
	        end
		else
	        if not home.components.pickable:CanBePicked() and target == home.thief then
	            return distsq(Vector3(home.Transform:GetWorldPosition() ), Vector3(inst.Transform:GetWorldPosition() ) ) < MAX_CHASE_DIST*MAX_CHASE_DIST
	        else
	            return distsq(Vector3(home.Transform:GetWorldPosition() ), Vector3(inst.Transform:GetWorldPosition() ) ) < MAX_CHASEAWAY_DIST*MAX_CHASEAWAY_DIST
	        end

		end
    else
        return true
    end
end

local function ShouldSleep(inst)
    return DefaultSleepTest(inst) and not FindThreatToNest(inst)
end

local function ShouldWake(inst)
    return DefaultWakeTest(inst) or FindThreatToNest(inst)
end

local function OnAttacked(inst, data)
    inst.components.combat:SuggestTarget(data.attacker)
end

local function OnEntitySleep(inst, data)
    inst.entitysleeping = true
    if inst.pending_spawn_smallbird then
        local smallbird = SpawnPrefab("smallbird")
        smallbird:PushEvent("SetUpSpringSmallBird", {smallbird=smallbird, tallbird=inst})
        inst.pending_spawn_smallbird = false
    end
end

local function OnEntityWake(inst, data)
    inst.entitysleeping = false
end

local function fn(Sim)
	local inst = CreateEntity()
	
    inst.entity:AddTransform()
	inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter()
	inst.entity:AddLightWatcher()
    --inst.Transform:SetScale(1.5,1.5,1.5)
	local shadow = inst.entity:AddDynamicShadow()
	shadow:SetSize( 2.75, 1)
    inst.Transform:SetFourFaced()
    
    
	------------------SATORI--------
	inst:AddComponent("talker")
    inst.components.talker.ontalk = ontalk
    inst.components.talker.fontsize = 35
    inst.components.talker.font = TALKINGFONT
    inst.components.talker.colour = Vector3(133/255, 140/255, 167/255)
    inst.components.talker.offset = Vector3(0,-800,0)
	--------------------------------
    
    MakeCharacterPhysics(inst, 10, .5)

    
    inst:AddTag("tallbird")
    inst:AddTag("animal")
    inst:AddTag("largecreature")
    inst.AnimState:SetBank("tallbird")
    inst.AnimState:SetBuild("ds_tallbird_basic")
    inst.AnimState:PlayAnimation("idle")
    inst.AnimState:Hide("beakfull")
    
    inst:AddComponent("locomotor") -- locomotor must be constructed before the stategraph
    inst.components.locomotor.walkspeed = 7

    inst:SetStateGraph("SGtallbird")
    
    
    inst:AddComponent("lootdropper")
    inst.components.lootdropper:SetLoot(loot)
   
    ---------------------        
    
    
    ------------------
    inst:AddComponent("health")
    inst.components.health:SetMaxHealth(TUNING.TALLBIRD_HEALTH)

    ------------------
    
    inst:AddComponent("combat")
    inst.components.combat.hiteffectsymbol = "head"
    inst.components.combat:SetDefaultDamage(TUNING.TALLBIRD_DAMAGE)
    inst.components.combat:SetAttackPeriod(TUNING.TALLBIRD_ATTACK_PERIOD)
    inst.components.combat:SetRetargetFunction(3, Retarget)
    inst.components.combat:SetKeepTargetFunction(KeepTarget)
    inst.components.combat:SetRange(TUNING.TALLBIRD_ATTACK_RANGE)

    MakeLargeBurnableCharacter(inst, "head")
    MakeLargeFreezableCharacter(inst, "head")
    ------------------
    
    inst:AddComponent("knownlocations")
	
	if SEASONS.AUTUMN then 
		--************ D  L  C *********--
		inst:AddComponent("leader")
	end	
    ------------------
    
    inst:AddComponent("eater")
    inst.components.eater:SetOmnivore()
    
    ------------------
    inst:AddComponent("sleeper")
    inst.components.sleeper:SetResistance(3)
    inst.components.sleeper.testperiod = GetRandomWithVariance(6, 2)
    inst.components.sleeper:SetSleepTest(function() 
        local sleep = GetClock():IsNight() and not inst.components.combat.target
        return sleep
    end)
    
    inst.components.sleeper:SetWakeTest(function() 
        local sleep = GetClock():IsDay() or inst.components.combat.target
        return sleep
    end)
    ------------------
    
    inst:AddComponent("inspectable")
    
    ------------------
    
    inst:SetBrain(brain)

    inst:ListenForEvent("attacked", OnAttacked)


	if SEASONS.AUTUMN then 
		--************ D  L  C *********--
		inst:ListenForEvent("entitysleep", OnEntitySleep)
	    inst:ListenForEvent("entitywake", OnEntityWake)
	end

    return inst
end

return Prefab( "forest/monsters/tallbird", fn, assets, prefabs) 
