require "TimedActions/ISBaseTimedAction"

SuicideActionAnim = ISBaseTimedAction:derive("SuicideActionAnim")

function SuicideActionAnim:isValid()
	return true
end

function SuicideActionAnim:update()
	local uispeed = UIManager.getSpeedControls():getCurrentGameSpeed()
    if uispeed ~= 1 then
        UIManager.getSpeedControls():SetCurrentGameSpeed(1)
    end

	if self:getJobDelta() > 0.1 and not self.isOff then
		self.character:splatBloodFloorBig(0.7);
		UIManager.FadeOut(self.character:getPlayerNum(), 1.5)
		UIManager.setFadeBeforeUI(self.character:getPlayerNum(), true)
		self.isOff = true
	end

	if self:getJobDelta() > self.shotTime and not self.isStartSound then
		self.character:getEmitter():playSound(self.item:getSwingSound())
		self.isStartSound = true
	end
end

function SuicideActionAnim:start()
	self:setActionAnim(self.anim)
end

function SuicideActionAnim:stop()
	UIManager.FadeIn(self.character:getPlayerNum(), 1)
	ISBaseTimedAction.stop(self)
end

function SuicideActionAnim:perform()	
	self.character:Kill(self.character)
	UIManager.FadeIn(self.character:getPlayerNum(), 15)
	ISBaseTimedAction.perform(self)
end

function SuicideActionAnim:new(character, item, anim, shotTime, maxTime)
	local o = {}
	setmetatable(o, self)
	self.__index = self
	o.character = character
	o.item = item
	o.anim = anim
	o.shotTime = shotTime
	o.maxTime = maxTime
	
	return o
end




