local twoHandWeapon = {
    "VarmintRifle",
    "HuntingRifle",
    "Shotgun",
    "DoubleBarrelShotgun",
    "DoubleBarrelShotgunSawnoff",
    "ShotgunSawnoff",
    "AssaultRifle",
    "AssaultRifle2",

    -- scrap guns
    "HPS",

    "HDBS",
    "SR",
    "SRB",
    "SSMGUnfolded",
    "SSMGFolded",
    "SlamFire",
    "SAR",
    "SARB",
    "SSR"
}

local oneHandWeapon = {
    "Pistol",
    "Pistol2",
    "Pistol3",
    "Revolver",
    "Revolver_Long",
    "Revolver_Short",

    "HP",
}

local oneHandAnims = {
    "Suicide_OneHand_1",
    "Suicide_OneHand_2",
    "Suicide_OneHand_3",
}

local function actionTwoHandWeaponStart(dummy, button, playerObj, item)
    if button.internal == "NO" then return end

    ISInventoryPaneContextMenu.equipWeapon(item, true, true, playerObj:getPlayerNum())
    ISTimedActionQueue.add(SuicideActionAnim:new(playerObj, item, "Suicide_TwoHand", 0.5, 120))
end

local function actionTwoHandWeaponFunc(playerObj, item)
    if item:getCurrentAmmoCount() == 0 then
        playerObj:Say(getText("UI_no_Ammo"))
        return
    end

    local playerNum = playerObj:getPlayerNum()
	local modal = ISModalDialog:new(0, 0, 350, 150, getText("UI_suicide_are_you_sure"),
		true, nil, actionTwoHandWeaponStart, playerNum, playerObj, item)
	modal:initialise()
	modal.prevFocus = getPlayerMechanicsUI(playerNum)
	modal.moveWithMouse = true
	modal:addToUIManager()
	if JoypadState.players[playerNum+1] then
		setJoypadFocus(playerNum, modal)
	end
end

local function actionOneHandWeaponStart(dummy, button, playerObj, item)
    if button.internal == "NO" then return end

    ISInventoryPaneContextMenu.equipWeapon(item, true, false, playerObj:getPlayerNum())
    ISTimedActionQueue.add(SuicideActionAnim:new(playerObj, item, oneHandAnims[1 + ZombRand(3)], 0.35, 100))
end

local function actionOneHandWeaponFunc(playerObj, item)
    if item:getCurrentAmmoCount() == 0 then
        playerObj:Say(getText("UI_no_Ammo"))
        return
    end

    local playerNum = playerObj:getPlayerNum()
	local modal = ISModalDialog:new(0, 0, 350, 150, getText("UI_suicide_are_you_sure"),
		true, nil, actionOneHandWeaponStart, playerNum, playerObj, item)
	modal:initialise()
	modal.prevFocus = getPlayerMechanicsUI(playerNum)
	modal.moveWithMouse = true
	modal:addToUIManager()
	if JoypadState.players[playerNum+1] then
		setJoypadFocus(playerNum, modal)
	end
end




local function suicideContextMenu( player, context, items)
    local playerObj = getSpecificPlayer(player)

    items = ISInventoryPane.getActualItems(items)

    for _, item in ipairs(items) do
        for i, weapon in ipairs(twoHandWeapon) do
            if item:getType() == weapon then
                context:addOption(getText("UI_Suicide"), playerObj, actionTwoHandWeaponFunc, item);   
            end
        end

        for i, weapon in ipairs(oneHandWeapon) do
            if item:getType() == weapon then
                context:addOption(getText("UI_Suicide"), playerObj, actionOneHandWeaponFunc, item);   
            end
        end
	end
end

Events.OnFillInventoryObjectContextMenu.Add(suicideContextMenu);
