/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb.criteria;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.criteria.AbstractQuery;
import javax.persistence.criteria.CollectionJoin;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Fetch;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.ListJoin;
import javax.persistence.criteria.MapJoin;
import javax.persistence.criteria.ParameterExpression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.criteria.SetJoin;
import javax.persistence.criteria.Subquery;
import javax.persistence.metamodel.EntityType;
import org.hibernate.ejb.criteria.CriteriaBuilderImpl;
import org.hibernate.ejb.criteria.CriteriaQueryCompiler;
import org.hibernate.ejb.criteria.FromImpl;
import org.hibernate.ejb.criteria.JoinImplementors;
import org.hibernate.ejb.criteria.ParameterRegistry;
import org.hibernate.ejb.criteria.QueryStructure;
import org.hibernate.ejb.criteria.RootImpl;
import org.hibernate.ejb.criteria.expression.ExpressionImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CriteriaSubqueryImpl<T>
extends ExpressionImpl<T>
implements Subquery<T> {
    private final AbstractQuery<?> parent;
    private final QueryStructure<T> queryStructure;
    private Expression<T> selection;
    private Set<Join<?, ?>> correlatedJoins = new HashSet();
    private final FromImpl.JoinScope joinScope = new FromImpl.JoinScope(){

        public void addJoin(Join join) {
            CriteriaSubqueryImpl.this.correlatedJoins.add(join);
        }

        public void addFetch(Fetch fetch) {
            throw new UnsupportedOperationException("Cannot define fetch from a subquery correlation");
        }

        public boolean isCorrelated() {
            return true;
        }

        public From getCorrelationParent() {
            return null;
        }
    };

    public CriteriaSubqueryImpl(CriteriaBuilderImpl criteriaBuilder, Class<T> javaType, AbstractQuery<?> parent) {
        super(criteriaBuilder, javaType);
        this.parent = parent;
        this.queryStructure = new QueryStructure(this, criteriaBuilder);
    }

    public FromImpl.JoinScope getJoinScope() {
        return this.joinScope;
    }

    public AbstractQuery<?> getParent() {
        return this.parent;
    }

    @Override
    public void registerParameters(ParameterRegistry registry) {
        for (ParameterExpression<?> param : this.queryStructure.getParameters()) {
            registry.registerParameter(param);
        }
    }

    public Class<T> getResultType() {
        return this.getJavaType();
    }

    public Set<Root<?>> getRoots() {
        return this.queryStructure.getRoots();
    }

    public <X> Root<X> from(EntityType<X> entityType) {
        return this.queryStructure.from(entityType);
    }

    public <X> Root<X> from(Class<X> entityClass) {
        return this.queryStructure.from(entityClass);
    }

    public Subquery<T> distinct(boolean applyDistinction) {
        this.queryStructure.setDistinct(applyDistinction);
        return this;
    }

    public boolean isDistinct() {
        return this.queryStructure.isDistinct();
    }

    public Expression<T> getSelection() {
        return this.selection;
    }

    public Subquery<T> select(Expression<T> expression) {
        this.queryStructure.setSelection((Selection<T>)this.selection);
        this.selection = expression;
        return this;
    }

    public Predicate getRestriction() {
        return this.queryStructure.getRestriction();
    }

    public Subquery<T> where(Expression<Boolean> expression) {
        this.queryStructure.setRestriction(this.queryBuilder().wrap(expression));
        return this;
    }

    public Subquery<T> where(Predicate ... predicates) {
        this.queryStructure.setRestriction(this.queryBuilder().and(predicates));
        return this;
    }

    public List<Expression<?>> getGroupList() {
        return this.queryStructure.getGroupings();
    }

    public Subquery<T> groupBy(Expression<?> ... groupings) {
        this.queryStructure.setGroupings(groupings);
        return this;
    }

    public Subquery<T> groupBy(List<Expression<?>> groupings) {
        this.queryStructure.setGroupings(groupings);
        return this;
    }

    public Predicate getGroupRestriction() {
        return this.queryStructure.getHaving();
    }

    public Subquery<T> having(Expression<Boolean> expression) {
        this.queryStructure.setHaving(this.queryBuilder().wrap(expression));
        return this;
    }

    public Subquery<T> having(Predicate ... predicates) {
        this.queryStructure.setHaving(this.queryBuilder().and(predicates));
        return this;
    }

    public Set<Join<?, ?>> getCorrelatedJoins() {
        return this.correlatedJoins;
    }

    public <Y> Root<Y> correlate(Root<Y> source) {
        return ((RootImpl)source).correlateTo(this);
    }

    public <X, Y> Join<X, Y> correlate(Join<X, Y> source) {
        return ((JoinImplementors.JoinImplementor)source).correlateTo(this);
    }

    public <X, Y> CollectionJoin<X, Y> correlate(CollectionJoin<X, Y> source) {
        return ((JoinImplementors.CollectionJoinImplementor)source).correlateTo(this);
    }

    public <X, Y> SetJoin<X, Y> correlate(SetJoin<X, Y> source) {
        return ((JoinImplementors.SetJoinImplementor)source).correlateTo(this);
    }

    public <X, Y> ListJoin<X, Y> correlate(ListJoin<X, Y> source) {
        return ((JoinImplementors.ListJoinImplementor)source).correlateTo(this);
    }

    public <X, K, V> MapJoin<X, K, V> correlate(MapJoin<X, K, V> source) {
        return ((JoinImplementors.MapJoinImplementor)source).correlateTo(this);
    }

    public <U> Subquery<U> subquery(Class<U> subqueryType) {
        return this.queryStructure.subquery(subqueryType);
    }

    @Override
    public String render(CriteriaQueryCompiler.RenderingContext renderingContext) {
        StringBuilder subqueryBuffer = new StringBuilder("(");
        this.queryStructure.render(subqueryBuffer, renderingContext);
        subqueryBuffer.append(')');
        return subqueryBuffer.toString();
    }

    @Override
    public String renderProjection(CriteriaQueryCompiler.RenderingContext renderingContext) {
        throw new IllegalStateException("Subquery cannot occur in select clause");
    }
}

