/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb.criteria;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.persistence.criteria.CollectionJoin;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Fetch;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.ListJoin;
import javax.persistence.criteria.MapJoin;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.SetJoin;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.CollectionAttribute;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.ListAttribute;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.MapAttribute;
import javax.persistence.metamodel.PluralAttribute;
import javax.persistence.metamodel.SetAttribute;
import javax.persistence.metamodel.SingularAttribute;
import javax.persistence.metamodel.Type;
import org.hibernate.ejb.criteria.BasicCollectionJoinImpl;
import org.hibernate.ejb.criteria.BasicListJoinImpl;
import org.hibernate.ejb.criteria.BasicMapJoinImpl;
import org.hibernate.ejb.criteria.BasicPathUsageException;
import org.hibernate.ejb.criteria.BasicSetJoinImpl;
import org.hibernate.ejb.criteria.CollectionJoinImpl;
import org.hibernate.ejb.criteria.CriteriaBuilderImpl;
import org.hibernate.ejb.criteria.CriteriaQueryCompiler;
import org.hibernate.ejb.criteria.JoinImpl;
import org.hibernate.ejb.criteria.JoinImplementors;
import org.hibernate.ejb.criteria.ListJoinImpl;
import org.hibernate.ejb.criteria.MapJoinImpl;
import org.hibernate.ejb.criteria.PathImpl;
import org.hibernate.ejb.criteria.SetJoinImpl;
import org.hibernate.ejb.criteria.TableExpressionMapper;
import org.hibernate.ejb.criteria.expression.CollectionExpression;
import org.hibernate.ejb.criteria.expression.EntityTypeExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FromImpl<Z, X>
extends PathImpl<X>
implements From<Z, X>,
TableExpressionMapper {
    public static final JoinType DEFAULT_JOIN_TYPE = JoinType.INNER;
    private final Expression<Class<? extends X>> type;
    private Set<Join<X, ?>> joins;
    private Set<Fetch<X, ?>> fetches;
    private JoinScope<X> joinScope = new JoinScope<X>(){

        @Override
        public void addJoin(Join<X, ?> join) {
            if (FromImpl.this.joins == null) {
                FromImpl.this.joins = new LinkedHashSet();
            }
            FromImpl.this.joins.add(join);
        }

        @Override
        public void addFetch(Fetch<X, ?> fetch) {
            if (FromImpl.this.fetches == null) {
                FromImpl.this.fetches = new LinkedHashSet();
            }
            FromImpl.this.fetches.add(fetch);
        }

        @Override
        public boolean isCorrelated() {
            return false;
        }

        @Override
        public From<?, X> getCorrelationParent() {
            return null;
        }
    };

    protected FromImpl(CriteriaBuilderImpl criteriaBuilder, EntityType<X> entityType) {
        super(criteriaBuilder, entityType.getBindableJavaType(), null, null, entityType);
        this.type = new EntityTypeExpression<Class<? extends X>>(criteriaBuilder, entityType.getBindableJavaType());
    }

    public FromImpl(CriteriaBuilderImpl criteriaBuilder, Class<X> javaType, PathImpl<Z> origin, Attribute<? super Z, ?> attribute, ManagedType<X> model) {
        super(criteriaBuilder, javaType, origin, attribute, model);
        this.type = new EntityTypeExpression<Class<? extends X>>(criteriaBuilder, model.getJavaType());
    }

    protected void defineJoinScope(JoinScope<X> joinScope) {
        this.joinScope = joinScope;
    }

    @Override
    public Expression<Class<? extends X>> type() {
        return this.type;
    }

    protected abstract Attribute<X, ?> getAttribute(String var1);

    public Set<Join<X, ?>> getJoins() {
        return this.joins;
    }

    public <Y> Join<X, Y> join(SingularAttribute<? super X, Y> singularAttribute) {
        return this.join(singularAttribute, DEFAULT_JOIN_TYPE);
    }

    public <Y> Join<X, Y> join(SingularAttribute<? super X, Y> attribute, JoinType jt) {
        JoinImplementors.JoinImplementor<? super X, Y> join = this.constructJoin(attribute, jt);
        this.joinScope.addJoin(join);
        return join;
    }

    private <Y> JoinImplementors.JoinImplementor<X, Y> constructJoin(SingularAttribute<? super X, Y> attribute, JoinType jt) {
        if (Type.PersistenceType.BASIC.equals((Object)attribute.getType().getPersistenceType())) {
            throw new BasicPathUsageException("Cannot join to attribute of basic type", (Attribute<?, ?>)attribute);
        }
        if (jt.equals((Object)JoinType.RIGHT)) {
            throw new UnsupportedOperationException("RIGHT JOIN not supported");
        }
        Class attributeType = attribute.getBindableJavaType();
        return new JoinImpl(this.queryBuilder(), attributeType, this, attribute, jt);
    }

    public <Y> CollectionJoin<X, Y> join(CollectionAttribute<? super X, Y> collection) {
        return this.join(collection, DEFAULT_JOIN_TYPE);
    }

    public <Y> CollectionJoin<X, Y> join(CollectionAttribute<? super X, Y> collection, JoinType jt) {
        JoinImplementors.CollectionJoinImplementor<? super X, Y> join = this.constructJoin(collection, jt);
        this.joinScope.addJoin(join);
        return join;
    }

    private <Y> JoinImplementors.CollectionJoinImplementor<X, Y> constructJoin(CollectionAttribute<? super X, Y> collection, JoinType jt) {
        if (jt.equals((Object)JoinType.RIGHT)) {
            throw new UnsupportedOperationException("RIGHT JOIN not supported");
        }
        Class attributeType = collection.getBindableJavaType();
        JoinImpl join = this.isBasicCollection((PluralAttribute)collection) ? new BasicCollectionJoinImpl<X, Y>(this.queryBuilder(), attributeType, this, collection, jt) : new CollectionJoinImpl(this.queryBuilder(), attributeType, this, collection, jt);
        return join;
    }

    private boolean isBasicCollection(PluralAttribute collection) {
        return Type.PersistenceType.BASIC.equals((Object)collection.getElementType().getPersistenceType());
    }

    public <Y> SetJoin<X, Y> join(SetAttribute<? super X, Y> set) {
        return this.join(set, DEFAULT_JOIN_TYPE);
    }

    public <Y> SetJoin<X, Y> join(SetAttribute<? super X, Y> set, JoinType jt) {
        JoinImplementors.SetJoinImplementor<? super X, Y> join = this.constructJoin(set, jt);
        this.joinScope.addJoin(join);
        return join;
    }

    private <Y> JoinImplementors.SetJoinImplementor<X, Y> constructJoin(SetAttribute<? super X, Y> set, JoinType jt) {
        if (jt.equals((Object)JoinType.RIGHT)) {
            throw new UnsupportedOperationException("RIGHT JOIN not supported");
        }
        Class attributeType = set.getBindableJavaType();
        JoinImpl join = this.isBasicCollection((PluralAttribute)set) ? new BasicSetJoinImpl(this.queryBuilder(), attributeType, this, set, jt) : new SetJoinImpl(this.queryBuilder(), attributeType, this, set, jt);
        return join;
    }

    public <Y> ListJoin<X, Y> join(ListAttribute<? super X, Y> list) {
        return this.join(list, DEFAULT_JOIN_TYPE);
    }

    public <Y> ListJoin<X, Y> join(ListAttribute<? super X, Y> list, JoinType jt) {
        JoinImplementors.ListJoinImplementor<? super X, Y> join = this.constructJoin(list, jt);
        this.joinScope.addJoin(join);
        return join;
    }

    private <Y> JoinImplementors.ListJoinImplementor<X, Y> constructJoin(ListAttribute<? super X, Y> list, JoinType jt) {
        if (jt.equals((Object)JoinType.RIGHT)) {
            throw new UnsupportedOperationException("RIGHT JOIN not supported");
        }
        Class attributeType = list.getBindableJavaType();
        JoinImpl join = this.isBasicCollection((PluralAttribute)list) ? new BasicListJoinImpl(this.queryBuilder(), attributeType, this, list, jt) : new ListJoinImpl(this.queryBuilder(), attributeType, this, list, jt);
        return join;
    }

    public <K, V> MapJoin<X, K, V> join(MapAttribute<? super X, K, V> map) {
        return this.join(map, DEFAULT_JOIN_TYPE);
    }

    public <K, V> MapJoin<X, K, V> join(MapAttribute<? super X, K, V> map, JoinType jt) {
        JoinImplementors.MapJoinImplementor<? super X, K, V> join = this.constructJoin(map, jt);
        this.joinScope.addJoin(join);
        return join;
    }

    private <K, V> JoinImplementors.MapJoinImplementor<X, K, V> constructJoin(MapAttribute<? super X, K, V> map, JoinType jt) {
        if (jt.equals((Object)JoinType.RIGHT)) {
            throw new UnsupportedOperationException("RIGHT JOIN not supported");
        }
        Class attributeType = map.getBindableJavaType();
        JoinImpl join = this.isBasicCollection((PluralAttribute)map) ? new BasicMapJoinImpl<X, K, V>(this.queryBuilder(), attributeType, this, map, jt) : new MapJoinImpl<X, K, V>(this.queryBuilder(), attributeType, this, map, jt);
        return join;
    }

    public <X, Y> Join<X, Y> join(String attributeName) {
        return this.join(attributeName, DEFAULT_JOIN_TYPE);
    }

    public <X, Y> Join<X, Y> join(String attributeName, JoinType jt) {
        if (jt.equals((Object)JoinType.RIGHT)) {
            throw new UnsupportedOperationException("RIGHT JOIN not supported");
        }
        Attribute<X, ?> attribute = this.getAttribute(attributeName);
        if (attribute.isCollection()) {
            PluralAttribute pluralAttribute = (PluralAttribute)attribute;
            if (PluralAttribute.CollectionType.COLLECTION.equals((Object)pluralAttribute.getCollectionType())) {
                return this.join((CollectionAttribute)attribute, jt);
            }
            if (PluralAttribute.CollectionType.LIST.equals((Object)pluralAttribute.getCollectionType())) {
                return this.join((ListAttribute)attribute, jt);
            }
            if (PluralAttribute.CollectionType.SET.equals((Object)pluralAttribute.getCollectionType())) {
                return this.join((SetAttribute)attribute, jt);
            }
            return this.join((MapAttribute)attribute, jt);
        }
        return this.join((SingularAttribute)attribute, jt);
    }

    public <X, Y> CollectionJoin<X, Y> joinCollection(String attributeName) {
        return this.joinCollection(attributeName, DEFAULT_JOIN_TYPE);
    }

    public <X, Y> CollectionJoin<X, Y> joinCollection(String attributeName, JoinType jt) {
        Attribute<X, ?> attribute = this.getAttribute(attributeName);
        if (!attribute.isCollection()) {
            throw new IllegalArgumentException("Requested attribute was not a collection");
        }
        PluralAttribute pluralAttribute = (PluralAttribute)attribute;
        if (!PluralAttribute.CollectionType.COLLECTION.equals((Object)pluralAttribute.getCollectionType())) {
            throw new IllegalArgumentException("Requested attribute was not a collection");
        }
        return this.join((CollectionAttribute)attribute, jt);
    }

    public <X, Y> SetJoin<X, Y> joinSet(String attributeName) {
        return this.joinSet(attributeName, DEFAULT_JOIN_TYPE);
    }

    public <X, Y> SetJoin<X, Y> joinSet(String attributeName, JoinType jt) {
        Attribute<X, ?> attribute = this.getAttribute(attributeName);
        if (!attribute.isCollection()) {
            throw new IllegalArgumentException("Requested attribute was not a set");
        }
        PluralAttribute pluralAttribute = (PluralAttribute)attribute;
        if (!PluralAttribute.CollectionType.SET.equals((Object)pluralAttribute.getCollectionType())) {
            throw new IllegalArgumentException("Requested attribute was not a set");
        }
        return this.join((SetAttribute)attribute, jt);
    }

    public <X, Y> ListJoin<X, Y> joinList(String attributeName) {
        return this.joinList(attributeName, DEFAULT_JOIN_TYPE);
    }

    public <X, Y> ListJoin<X, Y> joinList(String attributeName, JoinType jt) {
        Attribute<X, ?> attribute = this.getAttribute(attributeName);
        if (!attribute.isCollection()) {
            throw new IllegalArgumentException("Requested attribute was not a list");
        }
        PluralAttribute pluralAttribute = (PluralAttribute)attribute;
        if (!PluralAttribute.CollectionType.LIST.equals((Object)pluralAttribute.getCollectionType())) {
            throw new IllegalArgumentException("Requested attribute was not a list");
        }
        return this.join((ListAttribute)attribute, jt);
    }

    public <X, K, V> MapJoin<X, K, V> joinMap(String attributeName) {
        return this.joinMap(attributeName, DEFAULT_JOIN_TYPE);
    }

    public <X, K, V> MapJoin<X, K, V> joinMap(String attributeName, JoinType jt) {
        Attribute<X, ?> attribute = this.getAttribute(attributeName);
        if (!attribute.isCollection()) {
            throw new IllegalArgumentException("Requested attribute was not a map");
        }
        PluralAttribute pluralAttribute = (PluralAttribute)attribute;
        if (!PluralAttribute.CollectionType.MAP.equals((Object)pluralAttribute.getCollectionType())) {
            throw new IllegalArgumentException("Requested attribute was not a map");
        }
        return this.join((MapAttribute)attribute, jt);
    }

    public Set<Fetch<X, ?>> getFetches() {
        return this.fetches;
    }

    public Set<Fetch<X, ?>> internalGetFetches() {
        return this.fetches;
    }

    public <Y> Fetch<X, Y> fetch(SingularAttribute<? super X, Y> singularAttribute) {
        return this.fetch(singularAttribute, DEFAULT_JOIN_TYPE);
    }

    public <Y> Fetch<X, Y> fetch(SingularAttribute<? super X, Y> attribute, JoinType jt) {
        JoinImplementors.JoinImplementor<? super X, Y> fetch = this.constructJoin(attribute, jt);
        this.joinScope.addFetch(fetch);
        return fetch;
    }

    public <Y> Fetch<X, Y> fetch(PluralAttribute<? super X, ?, Y> pluralAttribute) {
        return this.fetch(pluralAttribute, DEFAULT_JOIN_TYPE);
    }

    public <Y> Fetch<X, Y> fetch(PluralAttribute<? super X, ?, Y> pluralAttribute, JoinType jt) {
        JoinImplementors.JoinImplementor<Object, Object> fetch = PluralAttribute.CollectionType.COLLECTION.equals((Object)pluralAttribute.getCollectionType()) ? this.constructJoin((CollectionAttribute)pluralAttribute, jt) : (PluralAttribute.CollectionType.LIST.equals((Object)pluralAttribute.getCollectionType()) ? this.constructJoin((ListAttribute)pluralAttribute, jt) : (PluralAttribute.CollectionType.SET.equals((Object)pluralAttribute.getCollectionType()) ? this.constructJoin((SetAttribute)pluralAttribute, jt) : this.constructJoin((MapAttribute)pluralAttribute, jt)));
        this.joinScope.addFetch(fetch);
        return fetch;
    }

    public <X, Y> Fetch<X, Y> fetch(String attributeName) {
        return this.fetch(attributeName, DEFAULT_JOIN_TYPE);
    }

    public <X, Y> Fetch<X, Y> fetch(String attributeName, JoinType jt) {
        Attribute<X, ?> attribute = this.getAttribute(attributeName);
        if (attribute.isCollection()) {
            return this.fetch((PluralAttribute)attribute, jt);
        }
        return this.fetch((SingularAttribute)attribute, jt);
    }

    @Override
    public <Y> Path<Y> get(SingularAttribute<? super X, Y> attribute) {
        if (Attribute.PersistentAttributeType.BASIC.equals((Object)attribute.getPersistentAttributeType())) {
            return new PathImpl(this.queryBuilder(), attribute.getJavaType(), this, (Attribute<?, ?>)attribute, attribute.getBindableType());
        }
        return this.join(attribute);
    }

    @Override
    public <E, C extends Collection<E>> Expression<C> get(PluralAttribute<X, C, E> collection) {
        return new CollectionExpression<C>(this.queryBuilder(), collection.getJavaType(), this, collection);
    }

    @Override
    public <K, V, M extends Map<K, V>> Expression<M> get(MapAttribute<X, K, V> map) {
        return new CollectionExpression<K>(this.queryBuilder(), map.getJavaType(), this, map);
    }

    @Override
    public <Y> Path<Y> get(String attributeName) {
        Attribute<X, ?> attribute = this.getAttribute(attributeName);
        if (attribute.isCollection()) {
            PluralAttribute pluralAttribute = (PluralAttribute)attribute;
            if (PluralAttribute.CollectionType.COLLECTION.equals((Object)pluralAttribute.getCollectionType())) {
                return this.join((CollectionAttribute)attribute);
            }
            if (PluralAttribute.CollectionType.LIST.equals((Object)pluralAttribute.getCollectionType())) {
                return this.join((ListAttribute)attribute);
            }
            if (PluralAttribute.CollectionType.SET.equals((Object)pluralAttribute.getCollectionType())) {
                return this.join((SetAttribute)attribute);
            }
            return this.join((MapAttribute)attribute);
        }
        return this.get((SingularAttribute)attribute);
    }

    @Override
    public String getPathIdentifier() {
        return this.getAlias();
    }

    @Override
    public String render(CriteriaQueryCompiler.RenderingContext renderingContext) {
        this.prepareAlias(renderingContext);
        return this.getAlias();
    }

    @Override
    public String renderProjection(CriteriaQueryCompiler.RenderingContext renderingContext) {
        this.prepareAlias(renderingContext);
        return this.getAlias();
    }

    @Override
    public String renderTableExpression(CriteriaQueryCompiler.RenderingContext renderingContext) {
        this.prepareAlias(renderingContext);
        return ((EntityType)this.getModel()).getName() + " as " + this.getAlias();
    }

    @Override
    public void prepareAlias(CriteriaQueryCompiler.RenderingContext renderingContext) {
        if (this.getAlias() == null) {
            this.setAlias(renderingContext.generateAlias());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface JoinScope<X> {
        public void addJoin(Join<X, ?> var1);

        public void addFetch(Fetch<X, ?> var1);

        public boolean isCorrelated();

        public From<?, X> getCorrelationParent();
    }
}

