/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb.criteria;

import javax.persistence.criteria.From;
import javax.persistence.criteria.JoinType;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.ManagedType;
import org.hibernate.ejb.criteria.CriteriaBuilderImpl;
import org.hibernate.ejb.criteria.CriteriaQueryCompiler;
import org.hibernate.ejb.criteria.CriteriaSubqueryImpl;
import org.hibernate.ejb.criteria.FromImpl;
import org.hibernate.ejb.criteria.JoinImplementors;
import org.hibernate.ejb.criteria.PathImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JoinImpl<Z, X>
extends FromImpl<Z, X>
implements JoinImplementors.JoinImplementor<Z, X> {
    private final ManagedType<X> managedType = this.getManagedType();
    private final JoinType joinType;
    private From<Z, X> correlationParent;

    public JoinImpl(CriteriaBuilderImpl criteriaBuilder, Class<X> javaType, PathImpl<Z> lhs, Attribute<? super Z, ?> joinProperty, JoinType joinType) {
        super(criteriaBuilder, javaType, lhs, joinProperty, criteriaBuilder.getEntityManagerFactory().getMetamodel().managedType(javaType));
        this.joinType = joinType;
    }

    protected ManagedType<X> getManagedType() {
        return (ManagedType)this.getModel();
    }

    public From<?, Z> getParent() {
        return (From)this.getParentPath();
    }

    @Override
    public Attribute<? super Z, ?> getAttribute() {
        return super.getAttribute();
    }

    public JoinType getJoinType() {
        return this.joinType;
    }

    @Override
    protected Attribute<X, ?> getAttribute(String name) {
        return this.managedType.getAttribute(name);
    }

    @Override
    public JoinImplementors.JoinImplementor<Z, X> correlateTo(CriteriaSubqueryImpl subquery) {
        JoinImpl correlation = new JoinImpl(this.queryBuilder(), this.getJavaType(), this.getParentPath(), this.getAttribute(), this.getJoinType());
        correlation.defineJoinScope(subquery.getJoinScope());
        correlation.correlationParent = this;
        return correlation;
    }

    public boolean isCorrelated() {
        return false;
    }

    public From<Z, X> getCorrelationParent() {
        return this.correlationParent;
    }

    @Override
    public String renderTableExpression(CriteriaQueryCompiler.RenderingContext renderingContext) {
        this.prepareAlias(renderingContext);
        ((FromImpl)this.getParent()).prepareAlias(renderingContext);
        return this.getParent().getAlias() + '.' + this.getAttribute().getName() + " as " + this.getAlias();
    }
}

