/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb.criteria.predicate;

import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Selection;
import org.hibernate.ejb.criteria.CriteriaBuilderImpl;
import org.hibernate.ejb.criteria.CriteriaQueryCompiler;
import org.hibernate.ejb.criteria.ParameterContainer;
import org.hibernate.ejb.criteria.ParameterRegistry;
import org.hibernate.ejb.criteria.expression.BinaryOperatorExpression;
import org.hibernate.ejb.criteria.expression.ExpressionImplementor;
import org.hibernate.ejb.criteria.expression.LiteralExpression;
import org.hibernate.ejb.criteria.predicate.AbstractSimplePredicate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComparisonPredicate
extends AbstractSimplePredicate
implements BinaryOperatorExpression<Boolean> {
    private final ComparisonOperator comparisonOperator;
    private final Expression<?> leftHandSide;
    private final Expression<?> rightHandSide;

    public ComparisonPredicate(CriteriaBuilderImpl criteriaBuilder, ComparisonOperator comparisonOperator, Expression<?> leftHandSide, Expression<?> rightHandSide) {
        super(criteriaBuilder);
        this.comparisonOperator = comparisonOperator;
        this.leftHandSide = leftHandSide;
        this.rightHandSide = rightHandSide;
    }

    public ComparisonPredicate(CriteriaBuilderImpl criteriaBuilder, ComparisonOperator comparisonOperator, Expression<?> leftHandSide, Object rightHandSide) {
        super(criteriaBuilder);
        this.comparisonOperator = comparisonOperator;
        this.leftHandSide = leftHandSide;
        this.rightHandSide = new LiteralExpression<Object>(criteriaBuilder, rightHandSide);
    }

    public ComparisonOperator getComparisonOperator() {
        return this.comparisonOperator;
    }

    @Override
    public Expression getLeftHandOperand() {
        return this.leftHandSide;
    }

    @Override
    public Expression getRightHandOperand() {
        return this.rightHandSide;
    }

    @Override
    public void registerParameters(ParameterRegistry registry) {
        ParameterContainer.Helper.possibleParameter((Selection)this.getLeftHandOperand(), registry);
        ParameterContainer.Helper.possibleParameter((Selection)this.getRightHandOperand(), registry);
    }

    @Override
    public String render(CriteriaQueryCompiler.RenderingContext renderingContext) {
        return ((ExpressionImplementor)this.getLeftHandOperand()).render(renderingContext) + this.getComparisonOperator().rendered() + ((ExpressionImplementor)this.getRightHandOperand()).render(renderingContext);
    }

    @Override
    public String renderProjection(CriteriaQueryCompiler.RenderingContext renderingContext) {
        return this.render(renderingContext);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ComparisonOperator {
        EQUAL{

            public ComparisonOperator negated() {
                return NOT_EQUAL;
            }

            public String rendered() {
                return "=";
            }
        }
        ,
        NOT_EQUAL{

            public ComparisonOperator negated() {
                return EQUAL;
            }

            public String rendered() {
                return "<>";
            }
        }
        ,
        LESS_THAN{

            public ComparisonOperator negated() {
                return GREATER_THAN_OR_EQUAL;
            }

            public String rendered() {
                return "<";
            }
        }
        ,
        LESS_THAN_OR_EQUAL{

            public ComparisonOperator negated() {
                return GREATER_THAN;
            }

            public String rendered() {
                return "<=";
            }
        }
        ,
        GREATER_THAN{

            public ComparisonOperator negated() {
                return LESS_THAN_OR_EQUAL;
            }

            public String rendered() {
                return ">";
            }
        }
        ,
        GREATER_THAN_OR_EQUAL{

            public ComparisonOperator negated() {
                return LESS_THAN;
            }

            public String rendered() {
                return ">=";
            }
        };


        public abstract ComparisonOperator negated();

        public abstract String rendered();
    }
}

