/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb.metamodel;

import java.lang.reflect.Member;
import java.util.Iterator;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.IdentifiableType;
import javax.persistence.metamodel.Type;
import org.hibernate.EntityMode;
import org.hibernate.annotations.common.AssertionFailure;
import org.hibernate.ejb.metamodel.AbstractIdentifiableType;
import org.hibernate.ejb.metamodel.AbstractManagedType;
import org.hibernate.ejb.metamodel.AttributeImplementor;
import org.hibernate.ejb.metamodel.BasicTypeImpl;
import org.hibernate.ejb.metamodel.EmbeddableTypeImpl;
import org.hibernate.ejb.metamodel.MappedSuperclassTypeImpl;
import org.hibernate.ejb.metamodel.MetadataContext;
import org.hibernate.ejb.metamodel.PluralAttributeImpl;
import org.hibernate.ejb.metamodel.SingularAttributeImpl;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.Map;
import org.hibernate.mapping.OneToMany;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Value;
import org.hibernate.tuple.entity.EntityMetamodel;
import org.hibernate.type.ComponentType;
import org.hibernate.type.EmbeddedComponentType;
import org.hibernate.type.EntityType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeFactory {
    private final MetadataContext context;

    public AttributeFactory(MetadataContext context) {
        this.context = context;
    }

    public <X, Y> AttributeImplementor<X, Y> buildAttribute(AbstractManagedType<X> ownerType, Property property, boolean getMember) {
        AttributeImplementor<X, Y> attribute;
        AttributeContext attrContext = AttributeFactory.getAttributeContext(property);
        if (attrContext.isCollection()) {
            attribute = this.buildPluralAttribute(ownerType, property, attrContext, getMember);
        } else {
            Type<X> attrType = this.getType(ownerType, attrContext.getElementTypeStatus(), attrContext.getElementValue(), getMember);
            attribute = new SingularAttributeImpl<X, X>(property.getName(), property.getType().getReturnedClass(), ownerType, getMember ? this.determineStandardJavaMember(ownerType, property) : null, false, false, property.isOptional(), attrType, attrContext.getElementAttributeType());
        }
        return attribute;
    }

    private <X, Y, V, K> AttributeImplementor<X, Y> buildPluralAttribute(AbstractManagedType<X> ownerType, Property property, AttributeContext attrContext, boolean getMember) {
        PluralAttributeImpl<X, ?, X> attribute;
        Type<X> attrType = this.getType(ownerType, attrContext.getElementTypeStatus(), attrContext.getElementValue(), getMember);
        Class<?> collectionClass = attrContext.getCollectionClass();
        if (java.util.Map.class.isAssignableFrom(collectionClass)) {
            Type<X> keyType = this.getType(ownerType, attrContext.getKeyTypeStatus(), attrContext.getKeyValue(), getMember);
            attribute = PluralAttributeImpl.create(ownerType, attrType, collectionClass, keyType).member(getMember ? this.determineStandardJavaMember(ownerType, property) : null).property(property).persistentAttributeType(attrContext.getElementAttributeType()).build();
        } else {
            attribute = PluralAttributeImpl.create(ownerType, attrType, collectionClass, null).member(getMember ? this.determineStandardJavaMember(ownerType, property) : null).property(property).persistentAttributeType(attrContext.getElementAttributeType()).build();
        }
        return attribute;
    }

    private <X> Type<X> getType(AbstractManagedType owner, AttributeContext.TypeStatus elementTypeStatus, Value value, boolean getMember) {
        org.hibernate.type.Type type = value.getType();
        switch (elementTypeStatus) {
            case BASIC: {
                return this.buildBasicType(type);
            }
            case EMBEDDABLE: {
                return this.buildEmbeddableType(owner, value, type, getMember);
            }
            case ENTITY: {
                return this.buildEntityType(type);
            }
        }
        throw new AssertionFailure("Unknown AttributeContext.TypeStatus: " + (Object)((Object)elementTypeStatus));
    }

    private <X> Type<X> buildBasicType(org.hibernate.type.Type type) {
        Class clazz = type.getReturnedClass();
        return new BasicTypeImpl(clazz, Type.PersistenceType.BASIC);
    }

    private <X> Type<X> buildEntityType(org.hibernate.type.Type type) {
        String entityName = ((EntityType)type).getAssociatedEntityName();
        return this.context.locateEntityType(entityName);
    }

    private <X> Type<X> buildEmbeddableType(AbstractManagedType owner, Value value, org.hibernate.type.Type type, boolean getMember) {
        Class clazz = type.getReturnedClass();
        EmbeddableTypeImpl embeddableType = new EmbeddableTypeImpl(clazz, owner, (ComponentType)type);
        this.context.registerEmbeddedableType(embeddableType);
        Component component = (Component)value;
        Iterator subProperties = component.getPropertyIterator();
        while (subProperties.hasNext()) {
            Property property = (Property)subProperties.next();
            embeddableType.getBuilder().addAttribute(this.buildAttribute(embeddableType, property, getMember));
        }
        embeddableType.lock();
        return embeddableType;
    }

    public <X, Y> SingularAttributeImpl<X, Y> buildIdAttribute(AbstractIdentifiableType<X> ownerType, Property property, boolean getMember) {
        AttributeContext attrContext = AttributeFactory.getAttributeContext(property);
        Type<X> attrType = this.getType(ownerType, attrContext.getElementTypeStatus(), attrContext.getElementValue(), getMember);
        Class idJavaType = property.getType().getReturnedClass();
        return new SingularAttributeImpl.Identifier<X, X>(property.getName(), idJavaType, ownerType, getMember ? this.determineIdentifierJavaMember(ownerType, property) : null, attrType, attrContext.getElementAttributeType());
    }

    private Member determineIdentifierJavaMember(IdentifiableType ownerType, Property property) {
        EntityMetamodel entityMetamodel = this.getDeclarerEntityMetamodel(ownerType);
        if (!property.getName().equals(entityMetamodel.getIdentifierProperty().getName())) {
            return this.determineVirtualIdentifierJavaMember(entityMetamodel, property);
        }
        return entityMetamodel.getTuplizer(EntityMode.POJO).getIdentifierGetter().getMember();
    }

    private Member determineVirtualIdentifierJavaMember(EntityMetamodel entityMetamodel, Property property) {
        if (!entityMetamodel.getIdentifierProperty().isVirtual()) {
            throw new IllegalArgumentException("expecting IdClass mapping");
        }
        org.hibernate.type.Type type = entityMetamodel.getIdentifierProperty().getType();
        if (!EmbeddedComponentType.class.isInstance(type)) {
            throw new IllegalArgumentException("expecting IdClass mapping");
        }
        EmbeddedComponentType componentType = (EmbeddedComponentType)type;
        return componentType.getTuplizerMapping().getTuplizer(EntityMode.POJO).getGetter(componentType.getPropertyIndex(property.getName())).getMember();
    }

    private EntityMetamodel getDeclarerEntityMetamodel(IdentifiableType<?> ownerType) {
        Type.PersistenceType persistenceType = ownerType.getPersistenceType();
        if (persistenceType == Type.PersistenceType.ENTITY) {
            return this.context.getSessionFactory().getEntityPersister(ownerType.getJavaType().getName()).getEntityMetamodel();
        }
        if (persistenceType == Type.PersistenceType.MAPPED_SUPERCLASS) {
            PersistentClass persistentClass = this.context.getPersistentClassHostingProperties((MappedSuperclassTypeImpl)ownerType);
            return this.context.getSessionFactory().getEntityPersister(persistentClass.getClassName()).getEntityMetamodel();
        }
        throw new AssertionFailure("Cannot get the metamodel for PersistenceType: " + persistenceType);
    }

    private Member determineStandardJavaMember(AbstractManagedType<?> ownerType, Property property) {
        Type.PersistenceType persistenceType = ownerType.getPersistenceType();
        if (Type.PersistenceType.EMBEDDABLE == persistenceType) {
            EmbeddableTypeImpl embeddableType = (EmbeddableTypeImpl)ownerType;
            return embeddableType.getHibernateType().getTuplizerMapping().getTuplizer(EntityMode.POJO).getGetter(embeddableType.getHibernateType().getPropertyIndex(property.getName())).getMember();
        }
        if (Type.PersistenceType.ENTITY == persistenceType || Type.PersistenceType.MAPPED_SUPERCLASS == persistenceType) {
            return this.determineStandardJavaMemberOutOfIdentifiableType((IdentifiableType)ownerType, property);
        }
        throw new IllegalArgumentException("Unexpected owner type : " + persistenceType);
    }

    private Member determineStandardJavaMemberOutOfIdentifiableType(IdentifiableType<?> ownerType, Property property) {
        String propertyName;
        EntityMetamodel entityMetamodel = this.getDeclarerEntityMetamodel(ownerType);
        Integer index = entityMetamodel.getPropertyIndexOrNull(propertyName = property.getName());
        if (index == null) {
            return this.determineVirtualIdentifierJavaMember(entityMetamodel, property);
        }
        return entityMetamodel.getTuplizer(EntityMode.POJO).getGetter(index.intValue()).getMember();
    }

    public <X, Y> SingularAttributeImpl<X, Y> buildVersionAttribute(AbstractIdentifiableType<X> ownerType, Property property, boolean getMember) {
        AttributeContext attrContext = AttributeFactory.getAttributeContext(property);
        Class javaType = property.getType().getReturnedClass();
        Type<X> attrType = this.getType(ownerType, attrContext.getElementTypeStatus(), attrContext.getElementValue(), getMember);
        return new SingularAttributeImpl.Version<X, X>(property.getName(), javaType, ownerType, getMember ? this.determineVersionJavaMember(ownerType, property) : null, attrType, attrContext.getElementAttributeType());
    }

    private Member determineVersionJavaMember(IdentifiableType ownerType, Property property) {
        EntityMetamodel entityMetamodel = this.getDeclarerEntityMetamodel(ownerType);
        if (!property.getName().equals(entityMetamodel.getVersionProperty().getName())) {
            throw new IllegalArgumentException("Given property did not match declared version property");
        }
        return entityMetamodel.getTuplizer(EntityMode.POJO).getVersionGetter().getMember();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static AttributeContext getAttributeContext(Property property) {
        Value value = property.getValue();
        org.hibernate.type.Type type = value.getType();
        if (type.isAnyType()) {
            throw new UnsupportedOperationException("any not supported yet");
        }
        if (type.isAssociationType()) {
            if (!type.isCollectionType()) return new AttributeContext(value, AttributeContext.TypeStatus.ENTITY, Attribute.PersistentAttributeType.MANY_TO_MANY, null, null, null);
            if (value instanceof Collection) {
                Attribute.PersistentAttributeType elementPAT;
                AttributeContext.TypeStatus elementTypeStatus;
                AttributeContext.TypeStatus keyTypeStatus;
                Value keyValue;
                Collection collValue = (Collection)value;
                Value elementValue = collValue.getElement();
                org.hibernate.type.Type elementType = elementValue.getType();
                Class collectionClass = collValue.getCollectionType().getReturnedClass();
                if (value instanceof Map) {
                    keyValue = ((Map)value).getIndex();
                    org.hibernate.type.Type keyType = keyValue.getType();
                    if (keyValue instanceof Component) {
                        keyTypeStatus = AttributeContext.TypeStatus.EMBEDDABLE;
                    } else {
                        if (keyType.isAnyType()) {
                            throw new UnsupportedOperationException("collection of any not supported yet");
                        }
                        keyTypeStatus = keyType.isAssociationType() ? AttributeContext.TypeStatus.ENTITY : AttributeContext.TypeStatus.BASIC;
                    }
                } else {
                    keyValue = null;
                    keyTypeStatus = null;
                }
                if (elementValue instanceof Component) {
                    elementTypeStatus = AttributeContext.TypeStatus.EMBEDDABLE;
                    elementPAT = Attribute.PersistentAttributeType.ELEMENT_COLLECTION;
                    return new AttributeContext(elementValue, elementTypeStatus, elementPAT, collectionClass, keyValue, keyTypeStatus);
                } else {
                    if (elementType.isAnyType()) {
                        throw new UnsupportedOperationException("collection of any not supported yet");
                    }
                    if (elementType.isAssociationType()) {
                        elementTypeStatus = AttributeContext.TypeStatus.ENTITY;
                        elementPAT = Attribute.PersistentAttributeType.MANY_TO_MANY;
                        return new AttributeContext(elementValue, elementTypeStatus, elementPAT, collectionClass, keyValue, keyTypeStatus);
                    } else {
                        elementTypeStatus = AttributeContext.TypeStatus.BASIC;
                        elementPAT = Attribute.PersistentAttributeType.ELEMENT_COLLECTION;
                    }
                }
                return new AttributeContext(elementValue, elementTypeStatus, elementPAT, collectionClass, keyValue, keyTypeStatus);
            }
            if (!(value instanceof OneToMany)) throw new UnsupportedOperationException("oops, we are missing something: " + property.toString());
            return new AttributeContext(value, AttributeContext.TypeStatus.ENTITY, Attribute.PersistentAttributeType.ONE_TO_MANY, null, null, null);
        }
        if (!property.isComposite()) return new AttributeContext(value, AttributeContext.TypeStatus.BASIC, Attribute.PersistentAttributeType.BASIC, null, null, null);
        return new AttributeContext(value, AttributeContext.TypeStatus.EMBEDDABLE, Attribute.PersistentAttributeType.EMBEDDED, null, null, null);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AttributeContext {
        private final Value elementValue;
        private final TypeStatus typeStatus;
        private final Class<?> collectionClass;
        private final Attribute.PersistentAttributeType attrType;
        private final Value keyValue;
        private final TypeStatus keyTypeStatus;

        private AttributeContext(Value elementValue, TypeStatus elementTypeStatus, Attribute.PersistentAttributeType elementPAT, Class<?> collectionClass, Value keyValue, TypeStatus keyTypeStatus) {
            this.elementValue = elementValue;
            this.typeStatus = elementTypeStatus;
            this.collectionClass = collectionClass;
            this.attrType = elementPAT;
            this.keyValue = keyValue;
            this.keyTypeStatus = keyTypeStatus;
        }

        public Value getElementValue() {
            return this.elementValue;
        }

        public TypeStatus getElementTypeStatus() {
            return this.typeStatus;
        }

        public boolean isCollection() {
            return this.collectionClass != null;
        }

        public Class<?> getCollectionClass() {
            return this.collectionClass;
        }

        public Attribute.PersistentAttributeType getElementAttributeType() {
            return this.attrType;
        }

        public Value getKeyValue() {
            return this.keyValue;
        }

        public TypeStatus getKeyTypeStatus() {
            return this.keyTypeStatus;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static enum TypeStatus {
            EMBEDDABLE,
            ENTITY,
            BASIC;

        }
    }
}

