/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.compilers;

import groovyjarjarasm.asm.ClassVisitor;
import groovyjarjarasm.asm.ClassWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.compilers.JRGroovyGenerator;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.design.JRAbstractJavaCompiler;
import net.sf.jasperreports.engine.design.JRCompilationSourceCode;
import net.sf.jasperreports.engine.design.JRCompilationUnit;
import net.sf.jasperreports.engine.design.JRDefaultCompilationSourceCode;
import net.sf.jasperreports.engine.design.JRSourceCompileTask;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.CompilerConfiguration;

public class JRGroovyCompiler
extends JRAbstractJavaCompiler {
    public JRGroovyCompiler() {
        super(false);
    }

    protected String compileUnits(JRCompilationUnit[] units, String classpath, File tempDirFile) throws JRException {
        CompilerConfiguration config = new CompilerConfiguration();
        CompilationUnit unit = new CompilationUnit(config);
        for (int i = 0; i < units.length; ++i) {
            unit.addSource("calculator_" + units[i].getName(), (InputStream)new ByteArrayInputStream(units[i].getSourceCode().getBytes()));
        }
        ClassCollector collector = new ClassCollector();
        unit.setClassgenCallback((CompilationUnit.ClassgenCallback)collector);
        try {
            unit.compile(7);
        }
        catch (CompilationFailedException e) {
            throw new JRException("Errors were encountered when compiling report expressions class file:\n" + e.toString(), e);
        }
        if (collector.classes.size() < units.length) {
            throw new JRException("Too few groovy class were generated.");
        }
        if (collector.classCount > units.length) {
            throw new JRException("Too many groovy classes were generated.\nPlease make sure that you don't use Groovy features such as closures that are not supported by this report compiler.\n");
        }
        for (int i = 0; i < units.length; ++i) {
            units[i].setCompileData((Serializable)collector.classes.get(units[i].getName()));
        }
        return null;
    }

    protected void checkLanguage(String language) throws JRException {
        if (!"groovy".equals(language) && !"java".equals(language)) {
            throw new JRException("Language \"" + language + "\" not supported by this report compiler.\n" + "Expecting \"groovy\" or \"java\" instead.");
        }
    }

    protected JRCompilationSourceCode generateSourceCode(JRSourceCompileTask sourceTask) throws JRException {
        return new JRDefaultCompilationSourceCode(JRGroovyGenerator.generateClass(sourceTask), null);
    }

    protected String getSourceFileName(String unitName) {
        return unitName + ".groovy";
    }

    private static class ClassCollector
    extends CompilationUnit.ClassgenCallback {
        public Map classes = new HashMap();
        public int classCount;

        private ClassCollector() {
        }

        public void call(ClassVisitor writer, ClassNode node) throws CompilationFailedException {
            ++this.classCount;
            String name = node.getName();
            if (!this.classes.containsKey(name)) {
                byte[] bytes = ((ClassWriter)writer).toByteArray();
                this.classes.put(name, bytes);
            }
        }
    }
}

