/*
 * Decompiled with CFR 0.152.
 */
package com.sinba.common.rules.action;

import com.opensymphony.xwork2.ActionSupport;
import com.sinba.common.compass.dto.CompassQueryDTO;
import com.sinba.common.compass.service.ICompassSearchService;
import com.sinba.common.dto.PageDTO;
import com.sinba.common.rules.dto.RuleDTO;
import com.sinba.common.rules.dto.RulePackageDTO;
import com.sinba.common.rules.dto.RuleQueryDTO;
import com.sinba.common.rules.entity.Rule;
import com.sinba.common.rules.service.IRulePackageService;
import com.sinba.common.rules.service.IRuleService;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.compass.core.CompassHit;
import org.compass.core.support.search.CompassSearchResults;
import org.springframework.beans.factory.annotation.Autowired;

public class CallBusinessRuleAction
extends ActionSupport {
    public static final Logger LOGGER = Logger.getLogger(CallBusinessRuleAction.class);
    private RulePackageDTO rulePackageDTO = new RulePackageDTO();
    private RuleDTO ruleDTO = new RuleDTO();
    private RuleQueryDTO ruleQueryDTO = new RuleQueryDTO();
    private CompassQueryDTO compassQueryDto = new CompassQueryDTO();
    @Autowired
    private ICompassSearchService compassSearchService;
    @Autowired
    private IRuleService ruleService;
    @Autowired
    private IRulePackageService rulePackageService;
    private int page = 1;
    private int rows = 10;
    private PageDTO pageDTO;
    private Long rulePackageNo;
    private Long[] ruleNos;
    private boolean result;
    private String sidx;
    private String sord;

    public String getSidx() {
        return this.sidx;
    }

    public void setSidx(String sidx) {
        this.sidx = sidx;
    }

    public String getSord() {
        return this.sord;
    }

    public void setSord(String sord) {
        this.sord = sord;
    }

    public CompassQueryDTO getCompassQueryDto() {
        return this.compassQueryDto;
    }

    public void setCompassQueryDto(CompassQueryDTO compassQueryDto) {
        this.compassQueryDto = compassQueryDto;
    }

    public ICompassSearchService getCompassSearchService() {
        return this.compassSearchService;
    }

    public void setCompassSearchService(ICompassSearchService compassSearchService) {
        this.compassSearchService = compassSearchService;
    }

    public Long[] getRuleNos() {
        return this.ruleNos;
    }

    public void setRuleNos(Long[] ruleNos) {
        this.ruleNos = ruleNos;
    }

    public Long getRulePackageNo() {
        return this.rulePackageNo;
    }

    public void setRulePackageNo(Long rulePackageNo) {
        this.rulePackageNo = rulePackageNo;
    }

    public RulePackageDTO getRulePackageDTO() {
        return this.rulePackageDTO;
    }

    public void setRulePackageDTO(RulePackageDTO rulePackageDTO) {
        this.rulePackageDTO = rulePackageDTO;
    }

    public RuleDTO getRuleDTO() {
        return this.ruleDTO;
    }

    public void setRuleDTO(RuleDTO ruleDTO) {
        this.ruleDTO = ruleDTO;
    }

    public RuleQueryDTO getRuleQueryDTO() {
        return this.ruleQueryDTO;
    }

    public void setRuleQueryDTO(RuleQueryDTO ruleQueryDTO) {
        this.ruleQueryDTO = ruleQueryDTO;
    }

    public IRuleService getRuleService() {
        return this.ruleService;
    }

    public void setRuleService(IRuleService ruleService) {
        this.ruleService = ruleService;
    }

    public IRulePackageService getRulePackageService() {
        return this.rulePackageService;
    }

    public void setRulePackageService(IRulePackageService rulePackageService) {
        this.rulePackageService = rulePackageService;
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public int getRows() {
        return this.rows;
    }

    public void setRows(int rows) {
        this.rows = rows;
    }

    public PageDTO getPageDTO() {
        return this.pageDTO;
    }

    public void setPageDTO(PageDTO pageDTO) {
        this.pageDTO = pageDTO;
    }

    public boolean isResult() {
        return this.result;
    }

    public void setResult(boolean result) {
        this.result = result;
    }

    public String find() {
        this.ruleQueryDTO.setRulePackageNo(this.rulePackageNo);
        int start = (this.page - 1) * this.rows;
        this.pageDTO = this.ruleService.findRuleByPager(this.ruleQueryDTO, start, this.rows, this.sidx, this.sord);
        this.pageDTO.setPage(this.page);
        this.pageDTO.setRows(this.rows);
        return "success";
    }

    public String delete() {
        this.result = this.ruleService.removeRules(this.ruleNos);
        return "result";
    }

    public String findRules() {
        this.find();
        return "showrules";
    }

    public String search() {
        String[] fields = new String[]{"ruleName"};
        CompassSearchResults csr = this.compassSearchService.performSearch(this.compassQueryDto, fields, this.page, this.rows);
        this.pageDTO = new PageDTO();
        this.pageDTO.setTotalSize(csr.getTotalHits());
        this.pageDTO.setPage(this.page);
        this.pageDTO.setRows(this.rows);
        ArrayList<RuleDTO> data = new ArrayList<RuleDTO>();
        CompassHit[] hit = csr.getHits();
        for (int i = 0; i < hit.length; ++i) {
            String alias = hit[i].alias();
            System.out.println("alias" + alias);
            if (!alias.equals("Rule")) continue;
            Rule entity = (Rule)((Object)hit[i].data());
            RuleDTO dto = new RuleDTO();
            this.ruleService.entity2dto(entity, dto);
            data.add(dto);
        }
        this.pageDTO.setData(data);
        return "success";
    }
}

