/*
 * Decompiled with CFR 0.152.
 */
package com.sinba.common.rules.entity;

import com.sinba.common.entity.BaseDomainEntity;
import com.sinba.common.rules.entity.Rule;
import com.sinba.common.rules.entity.RuleAction;
import com.sinba.common.rules.entity.RuleConstraint;
import com.sinba.common.rules.entity.RulePattern;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import org.apache.commons.lang.ObjectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
public class RulePackage
extends BaseDomainEntity {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    private Long rulePackageNo;
    private String packageName;
    private String imports;
    private String globals;
    private String functions;
    private String location;
    private String ruleFlag;
    @OneToMany(cascade={CascadeType.ALL})
    @JoinColumn(name="rulePackageNo")
    private List<Rule> rules = new ArrayList<Rule>();

    public String getRuleFlag() {
        return this.ruleFlag;
    }

    public void setRuleFlag(String ruleFlag) {
        this.ruleFlag = ruleFlag;
    }

    public List<Rule> getRules() {
        return this.rules;
    }

    public void setRules(List<Rule> rules) {
        this.rules = rules;
    }

    public Long getRulePackageNo() {
        return this.rulePackageNo;
    }

    public void setRulePackageNo(Long rulePackageNo) {
        this.rulePackageNo = rulePackageNo;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getImports() {
        return this.imports;
    }

    public void setImports(String imports) {
        this.imports = imports;
    }

    public String getGlobals() {
        return this.globals;
    }

    public void setGlobals(String globals) {
        this.globals = globals;
    }

    public String getFunctions() {
        return this.functions;
    }

    public void setFunctions(String functions) {
        this.functions = functions;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String toString() {
        String binding = null;
        StringBuffer buffer = new StringBuffer();
        BufferedReader br = new BufferedReader(new StringReader(this.imports));
        if (this.packageName.equals("\u8bf7\u6c42\u89c4\u5219")) {
            buffer.append("package com.drools.drl.requestfitservices");
        } else if (this.packageName.equals("\u81ea\u52a8\u5347\u7ea7")) {
            buffer.append("package com.drools.drl.autoupdate");
        } else {
            buffer.append("package " + this.packageName);
        }
        buffer.append("\n");
        try {
            String line = null;
            while ((line = br.readLine()) != null) {
                buffer.append("import ");
                buffer.append(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        buffer.append("\n\n");
        for (int i = 0; i < this.rules.size(); ++i) {
            Rule rule = this.rules.get(i);
            if (rule.getDataFlag() == 99) continue;
            buffer.append("rule \"" + rule.getRuleName() + "\"\n");
            buffer.append("    dialect \"mvel\"\n");
            buffer.append("    no-loop true \n");
            buffer.append("    when");
            RulePattern pattern = rule.getCondition();
            binding = pattern.getPatternBinding();
            buffer.append("\n        ");
            buffer.append(pattern.getPatternBinding());
            buffer.append(":");
            buffer.append(pattern.getPatternType());
            buffer.append("(");
            for (int k = 0; k < pattern.getConstraints().size(); ++k) {
                RuleConstraint constraint = pattern.getConstraints().get(k);
                if (constraint.getSequence() > 1) {
                    if ("and".equals(constraint.getAndOr())) {
                        buffer.append(",");
                    } else {
                        buffer.append("||");
                    }
                }
                buffer.append(constraint.getPropertyName() + " ");
                if ("Long".equals(constraint.getDataType())) {
                    buffer.append(constraint.getPropertyValue());
                    continue;
                }
                if ("Integer".equals(constraint.getDataType())) {
                    buffer.append(constraint.getPropertyValue());
                    continue;
                }
                buffer.append("\"");
                buffer.append(constraint.getPropertyValue());
                buffer.append("\"");
            }
            buffer.append(")");
            buffer.append("\n    then \n        ");
            buffer.append("modify(");
            buffer.append(binding);
            buffer.append("){");
            if (this.packageName.equals("\u81ea\u52a8\u5347\u7ea7")) {
                buffer.append(" autoUpdate=\"yes\" ");
                buffer.append("}");
                buffer.append("\nend\n ");
                buffer.append("\n ");
                continue;
            }
            for (int j = 0; j < rule.getActions().size(); ++j) {
                RuleAction action = rule.getActions().get(j);
                if (action.getSequence() > 1) {
                    buffer.append(",");
                }
                buffer.append(action.getPropertyName());
                if ("Long".equals(action.getDataType())) {
                    buffer.append("=");
                    buffer.append(action.getGivenValue() + "L");
                    continue;
                }
                if ("Integer".equals(action.getDataType())) {
                    buffer.append("=");
                    buffer.append(action.getGivenValue());
                    continue;
                }
                buffer.append("=\"");
                buffer.append(action.getGivenValue());
                buffer.append("\"");
            }
            buffer.append("}");
            buffer.append("\nend\n ");
            buffer.append("\n ");
        }
        if (this.functions != null) {
            buffer.append(this.functions);
        }
        return buffer.toString();
    }

    public boolean equals(Object obj) {
        boolean v = false;
        if (obj instanceof RulePackage) {
            RulePackage another = (RulePackage)((Object)obj);
            v = true;
            v = v && ObjectUtils.equals((Object)this.getPackageName(), (Object)another.getPackageName()) && ObjectUtils.equals((Object)this.getImports().trim(), (Object)another.getImports().trim());
        }
        return v;
    }
}

