/*
 * Decompiled with CFR 0.152.
 */
package com.sinba.common.rules.entity;

import com.sinba.common.entity.BaseDomainEntity;
import com.sinba.common.rules.entity.Rule;
import com.sinba.common.rules.entity.RuleConstraint;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import org.apache.commons.lang.ObjectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
public class RulePattern
extends BaseDomainEntity {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    private Long rulePatternNo;
    private String patternType;
    private String patternBinding;
    private int sequence;
    @OneToOne(mappedBy="condition")
    private Rule rule;
    @OneToMany(cascade={CascadeType.ALL})
    @JoinColumn(name="rulePatternNo")
    private List<RuleConstraint> constraints = new ArrayList<RuleConstraint>();

    public Rule getRule() {
        return this.rule;
    }

    public void setRule(Rule rule) {
        this.rule = rule;
    }

    public List<RuleConstraint> getConstraints() {
        return this.constraints;
    }

    public void setConstraints(List<RuleConstraint> constraints) {
        this.constraints = constraints;
    }

    public Long getRulePatternNo() {
        return this.rulePatternNo;
    }

    public void setRulePatternNo(Long rulePatternNo) {
        this.rulePatternNo = rulePatternNo;
    }

    public String getPatternType() {
        return this.patternType;
    }

    public void setPatternType(String patternType) {
        this.patternType = patternType;
    }

    public String getPatternBinding() {
        return this.patternBinding;
    }

    public void setPatternBinding(String patternBinding) {
        this.patternBinding = patternBinding;
    }

    public int getSequence() {
        return this.sequence;
    }

    public void setSequence(int sequence) {
        this.sequence = sequence;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.patternBinding);
        buffer.append(":");
        buffer.append(this.patternType);
        buffer.append("(");
        for (int i = 0; i < this.constraints.size(); ++i) {
            RuleConstraint c = this.constraints.get(i);
            if (c.getPropertyType().booleanValue()) {
                buffer.append(c.getPropertyName());
                buffer.append("==\"");
                buffer.append(c.getPropertyValue());
                buffer.append("\"");
            } else {
                buffer.append(c.getPropertyName());
                buffer.append("==");
                buffer.append(c.getPropertyValue());
            }
            if (c.getSequence() >= this.constraints.size()) continue;
            buffer.append(c.getAndOr());
        }
        buffer.append(")");
        return buffer.toString();
    }

    public boolean equals(Object obj) {
        boolean v = false;
        if (obj instanceof RulePattern) {
            RulePattern another = (RulePattern)((Object)obj);
            v = true;
            v = v && ObjectUtils.equals((Object)this.getPatternBinding(), (Object)another.getPatternBinding()) && ObjectUtils.equals((Object)this.getPatternType(), (Object)another.getPatternType());
        }
        return v;
    }
}

