/*
 * Decompiled with CFR 0.152.
 */
package com.sinba.common.rules.parser;

import com.sinba.common.rules.entity.Rule;
import com.sinba.common.rules.entity.RuleAction;
import com.sinba.common.rules.entity.RuleConstraint;
import com.sinba.common.rules.entity.RulePackage;
import com.sinba.common.rules.entity.RulePattern;
import com.sinba.common.rules.parser.IRuleHandler;
import java.util.ArrayList;
import java.util.List;

public class RuleHandler
implements IRuleHandler {
    private RulePackage rulePackage = new RulePackage();
    private List<Rule> rules = new ArrayList<Rule>();
    private List<RuleConstraint> constraints = new ArrayList<RuleConstraint>();
    private List<RuleAction> actions = new ArrayList<RuleAction>();
    private StringBuffer buffer = new StringBuffer();

    public RulePackage onPackage(String packageName) {
        this.rulePackage.setPackageName(packageName);
        return this.rulePackage;
    }

    public RulePackage onImport(String imports) {
        this.rulePackage.setImports(this.buffer.append(imports).append("\r\n").toString());
        return this.rulePackage;
    }

    public Rule onRule(String ruleName, String dialect) {
        Rule rule = new Rule();
        rule.setRuleName(ruleName);
        rule.setDialect(dialect);
        this.rules.add(rule);
        this.rulePackage.setRules(this.rules);
        return rule;
    }

    public RulePattern onPattern(String patternBinding, String patternType) {
        RulePattern pattern = new RulePattern();
        pattern.setPatternBinding(patternBinding);
        pattern.setPatternType(patternType);
        List<Rule> rules = this.rulePackage.getRules();
        for (Rule rule : rules) {
            rule.setCondition(pattern);
        }
        return pattern;
    }

    public RuleConstraint onConstraint(String propertyName, String propertyValue, Boolean propertyType, int sequence, String andOr) {
        RuleConstraint constraint = new RuleConstraint();
        constraint.setPropertyName(propertyName);
        constraint.setPropertyValue(propertyValue);
        constraint.setPropertyType(propertyType);
        constraint.setSequence(sequence);
        constraint.setAndOr(andOr);
        this.constraints.add(constraint);
        List<Rule> rules = this.rulePackage.getRules();
        for (Rule rule : rules) {
            RulePattern pattern = rule.getCondition();
            pattern.setConstraints(this.constraints);
        }
        return constraint;
    }

    public RuleAction onAction(String propertyName, String givenValue, int sequence, String andOr) {
        RuleAction action = new RuleAction();
        action.setPropertyName(propertyName);
        action.setGivenValue(givenValue);
        action.setSequence(sequence);
        action.setAndOr(andOr);
        this.actions.add(action);
        List<Rule> rules = this.rulePackage.getRules();
        for (Rule rule : rules) {
            rule.setActions(this.actions);
        }
        return action;
    }
}

