/*
 * Decompiled with CFR 0.152.
 */
package com.sinba.common.rules.parser;

import com.sinba.common.rules.entity.RulePackage;
import com.sinba.common.rules.parser.RuleHandler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.StringTokenizer;

public class RuleParser {
    private static RuleHandler ruleHandler = new RuleHandler();
    private RulePackage rulePackage = new RulePackage();

    public RulePackage parser(String txt) throws IOException {
        BufferedReader br = new BufferedReader(new StringReader(txt));
        String ruleName = "";
        String line = null;
        while ((line = br.readLine()) != null) {
            if (line.contains("package")) {
                String rp = line.substring(7).trim();
                this.rulePackage = ruleHandler.onPackage(rp);
            }
            if (line.contains("import")) {
                String im = line.substring(6).trim();
                ruleHandler.onImport(im);
            }
            if (line.contains("rule")) {
                ruleName = line.substring(4).trim();
                ruleName = ruleName.substring(1, ruleName.length() - 1);
            }
            if (line.contains("dialect")) {
                String dialect = line.substring(11).trim();
                dialect = dialect.substring(1, dialect.length() - 1);
                ruleHandler.onRule(ruleName, dialect);
            }
            if (line.contains("when")) {
                line = br.readLine();
                String[] bindings = line.split(":");
                String binding = "";
                String patternType = "";
                for (int j = 0; j < 1; ++j) {
                    binding = binding + bindings[0];
                    patternType = patternType + bindings[1];
                }
                String[] types = patternType.split("\\(");
                patternType = types[0];
                types[1] = types[1].substring(0, types[1].length() - 1);
                ruleHandler.onPattern(binding.trim(), patternType.trim());
                if (types[1].contains(",") || types[1].contains("||")) {
                    RuleParser.constraint(types[1]);
                }
            }
            if (!line.contains("then")) continue;
            line = br.readLine();
            String[] action = line.split("\\{");
            action[1] = action[1].substring(0, action[1].length() - 1);
            if (!action[1].contains(",") && !action[1].contains("||")) continue;
            RuleParser.action(action[1]);
        }
        return this.rulePackage;
    }

    private static void constraint(String constraint) {
        Boolean propertyType = false;
        String delim = ",(\\|\\|)";
        int sequence = 0;
        StringTokenizer stk = new StringTokenizer(constraint, delim);
        while (stk.hasMoreTokens()) {
            ++sequence;
            String s = stk.nextToken();
            int idx = constraint.indexOf(s);
            String andOr = constraint.substring(0, idx);
            if (andOr.equals("")) {
                andOr = null;
            }
            constraint = constraint.substring(idx + s.length());
            String[] cons1 = s.trim().split("\\==");
            String propertyName = cons1[0];
            String value = cons1[1];
            if (value.contains("\"")) {
                value = value.substring(1, value.length() - 1);
                propertyType = true;
            }
            ruleHandler.onConstraint(propertyName, value, propertyType, sequence, andOr);
        }
    }

    private static void action(String actions) {
        String delim = ",(\\|\\|)";
        int sequence = 0;
        StringTokenizer stk = new StringTokenizer(actions, delim);
        while (stk.hasMoreTokens()) {
            ++sequence;
            String s = stk.nextToken();
            int idx = actions.indexOf(s);
            String andOr = actions.substring(0, idx);
            if (andOr.equals("")) {
                andOr = null;
            }
            actions = actions.substring(idx + s.length());
            String[] act = s.trim().split("\\==");
            String propertyName = act[0];
            String givenValue = act[1];
            if (givenValue.contains("\"")) {
                givenValue = givenValue.substring(1, givenValue.length() - 1);
            }
            ruleHandler.onAction(propertyName, givenValue, sequence, andOr);
        }
    }
}

