/*
 * Decompiled with CFR 0.152.
 */
package com.sinba.common.rules.service;

import com.sinba.common.exception.ApplicationException;
import com.sinba.common.rules.dao.IRuleActionDAO;
import com.sinba.common.rules.dao.IRuleDAO;
import com.sinba.common.rules.dto.RuleActionDTO;
import com.sinba.common.rules.entity.Rule;
import com.sinba.common.rules.entity.RuleAction;
import com.sinba.common.rules.service.IRuleActionService;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuleActionService
implements IRuleActionService {
    @Autowired
    private IRuleDAO ruleDAO;
    @Autowired
    private IRuleActionDAO ruleActionDAO;

    private void dto2entity(RuleActionDTO dto, RuleAction entity) {
        try {
            BeanUtils.copyProperties((Object)((Object)entity), (Object)((Object)dto));
        }
        catch (Exception ex) {
            throw new ApplicationException(ex);
        }
    }

    private void entity2dto(RuleAction entity, RuleActionDTO dto) {
        if (entity.getRule() != null) {
            Long ruleNo = entity.getRule().getRuleNo();
            String ruleName = entity.getRule().getRuleName();
            dto.setRuleNo(ruleNo);
            dto.setRuleName(ruleName);
        }
        try {
            BeanUtils.copyProperties((Object)((Object)dto), (Object)((Object)entity));
        }
        catch (Exception ex) {
            throw new ApplicationException(ex);
        }
    }

    @Override
    @Transactional
    public void saveRuleAction(RuleActionDTO dto) {
        RuleAction entity = new RuleAction();
        this.dto2entity(dto, entity);
        if (null != dto.getRuleNo()) {
            Rule rule = (Rule)((Object)this.ruleDAO.findById(dto.getRuleNo()));
            entity.setRule(rule);
        }
        this.ruleActionDAO.save((Object)entity);
    }

    @Override
    @Transactional
    public void removeRuleAction(Long no) {
        this.ruleActionDAO.delete(this.ruleActionDAO.findById(no));
    }

    @Override
    @Transactional
    public void removeRuleActions(Long[] nos) {
        this.ruleActionDAO.deleteByIds(nos);
    }

    @Override
    @Transactional
    public RuleActionDTO mergeRuleAction(RuleActionDTO dto) {
        RuleAction entity = new RuleAction();
        this.dto2entity(dto, entity);
        if (dto.getRuleNo() != null) {
            Rule rule = (Rule)((Object)this.ruleDAO.findById(dto.getRuleNo()));
            entity.setRule(rule);
        }
        entity = (RuleAction)((Object)this.ruleActionDAO.merge((Object)entity));
        this.entity2dto(entity, dto);
        return dto;
    }

    @Override
    @Transactional
    public void mergeAllRuleAction(List<RuleActionDTO> dtos) {
        ArrayList<RuleAction> entities = new ArrayList<RuleAction>();
        for (RuleActionDTO dto : dtos) {
            RuleAction entity = new RuleAction();
            this.dto2entity(dto, entity);
            if (dto.getRuleNo() != null) {
                Rule rule = (Rule)((Object)this.ruleDAO.findById(dto.getRuleNo()));
                entity.setRule(rule);
            }
            entities.add(entity);
        }
        this.ruleActionDAO.mergeAll(entities);
    }

    @Override
    public List<RuleActionDTO> findRuleActions() {
        List entities = this.ruleActionDAO.findAll();
        ArrayList<RuleActionDTO> dtos = new ArrayList<RuleActionDTO>(entities.size());
        for (RuleAction entity : entities) {
            RuleActionDTO dto = new RuleActionDTO();
            this.entity2dto(entity, dto);
            dtos.add(dto);
        }
        return dtos;
    }

    @Override
    public RuleActionDTO findRuleActionById(Long no) {
        RuleAction entity = (RuleAction)((Object)this.ruleActionDAO.findById(no));
        RuleActionDTO dto = new RuleActionDTO();
        this.entity2dto(entity, dto);
        return dto;
    }

    @Override
    public List<RuleActionDTO> findRuleActionByRuleNo(Long ruleNo) {
        Rule rule = (Rule)((Object)this.ruleDAO.findById(ruleNo));
        List<RuleAction> entities = rule.getActions();
        ArrayList<RuleActionDTO> dtos = new ArrayList<RuleActionDTO>(entities.size());
        for (RuleAction entity : entities) {
            RuleActionDTO dto = new RuleActionDTO();
            this.entity2dto(entity, dto);
            dtos.add(dto);
        }
        return dtos;
    }
}

