/*
 * Decompiled with CFR 0.152.
 */
package com.sinba.common.rules.service;

import com.sinba.common.exception.ApplicationException;
import com.sinba.common.rules.dao.IRuleConstraintDAO;
import com.sinba.common.rules.dao.IRulePatternDAO;
import com.sinba.common.rules.dto.RuleConstraintDTO;
import com.sinba.common.rules.entity.RuleConstraint;
import com.sinba.common.rules.entity.RulePattern;
import com.sinba.common.rules.service.IRuleConstraintService;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuleConstraintService
implements IRuleConstraintService {
    @Autowired
    private IRulePatternDAO rulePatternDAO;
    @Autowired
    private IRuleConstraintDAO ruleConstraintDAO;

    private void dto2entity(RuleConstraintDTO dto, RuleConstraint entity) {
        try {
            BeanUtils.copyProperties((Object)((Object)entity), (Object)((Object)dto));
        }
        catch (Exception ex) {
            throw new ApplicationException(ex);
        }
    }

    private void entity2dto(RuleConstraint entity, RuleConstraintDTO dto) {
        if (entity.getPattern() != null) {
            Long rulePatternNo = entity.getPattern().getRulePatternNo();
            dto.setRulePatternNo(rulePatternNo);
        }
        try {
            BeanUtils.copyProperties((Object)((Object)dto), (Object)((Object)entity));
        }
        catch (Exception ex) {
            throw new ApplicationException(ex);
        }
    }

    @Override
    @Transactional
    public void saveRuleConstraint(RuleConstraintDTO dto) {
        RuleConstraint entity = new RuleConstraint();
        this.dto2entity(dto, entity);
        if (null != dto.getRulePatternNo()) {
            RulePattern rulePattern = (RulePattern)((Object)this.rulePatternDAO.findById(dto.getRulePatternNo()));
            entity.setPattern(rulePattern);
        }
        this.ruleConstraintDAO.save((Object)entity);
    }

    @Override
    @Transactional
    public void removeRuleConstraint(Long no) {
        this.ruleConstraintDAO.delete(this.ruleConstraintDAO.findById(no));
    }

    @Override
    @Transactional
    public void removeRuleConstraints(Long[] nos) {
        this.ruleConstraintDAO.deleteByIds(nos);
    }

    @Override
    @Transactional
    public RuleConstraintDTO mergeRuleConstraint(RuleConstraintDTO dto) {
        RuleConstraint entity = new RuleConstraint();
        this.dto2entity(dto, entity);
        if (dto.getRulePatternNo() != null) {
            RulePattern rulePattern = (RulePattern)((Object)this.rulePatternDAO.findById(dto.getRulePatternNo()));
            entity.setPattern(rulePattern);
        }
        entity = (RuleConstraint)((Object)this.ruleConstraintDAO.merge((Object)entity));
        this.entity2dto(entity, dto);
        return dto;
    }

    @Override
    @Transactional
    public void mergeAllRuleConstraint(List<RuleConstraintDTO> dtos) {
        ArrayList<RuleConstraint> entities = new ArrayList<RuleConstraint>();
        for (RuleConstraintDTO dto : dtos) {
            RuleConstraint entity = new RuleConstraint();
            this.dto2entity(dto, entity);
            if (dto.getRulePatternNo() != null) {
                RulePattern rulePattern = (RulePattern)((Object)this.rulePatternDAO.findById(dto.getRulePatternNo()));
                entity.setPattern(rulePattern);
            }
            entities.add(entity);
        }
        this.ruleConstraintDAO.mergeAll(entities);
    }

    @Override
    @Transactional
    public List<RuleConstraintDTO> findRuleConstraints() {
        List entities = this.ruleConstraintDAO.findAll();
        ArrayList<RuleConstraintDTO> dtos = new ArrayList<RuleConstraintDTO>(entities.size());
        for (RuleConstraint entity : entities) {
            RuleConstraintDTO dto = new RuleConstraintDTO();
            this.entity2dto(entity, dto);
            dtos.add(dto);
        }
        return dtos;
    }

    @Override
    public RuleConstraintDTO findRuleConstraintById(Long no) {
        RuleConstraint entity = (RuleConstraint)((Object)this.ruleConstraintDAO.findById(no));
        RuleConstraintDTO dto = new RuleConstraintDTO();
        this.entity2dto(entity, dto);
        return dto;
    }

    @Override
    public List<RuleConstraintDTO> findRuleConstraintByPatternNo(Long patternNo) {
        RulePattern pattern = (RulePattern)((Object)this.rulePatternDAO.findById(patternNo));
        List<RuleConstraint> entities = pattern.getConstraints();
        ArrayList<RuleConstraintDTO> dtos = new ArrayList<RuleConstraintDTO>(entities.size());
        for (RuleConstraint entity : entities) {
            RuleConstraintDTO dto = new RuleConstraintDTO();
            this.entity2dto(entity, dto);
            dtos.add(dto);
        }
        return dtos;
    }
}

