/*
 * Decompiled with CFR 0.152.
 */
package com.sinba.common.rules.service;

import com.sinba.common.exception.ApplicationException;
import com.sinba.common.rules.dao.IRulePackageDAO;
import com.sinba.common.rules.dto.RulePackageDTO;
import com.sinba.common.rules.entity.RulePackage;
import com.sinba.common.rules.service.IRulePackageService;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RulePackageService
implements IRulePackageService {
    @Autowired
    private IRulePackageDAO rulePackageDAO;

    private void dto2entity(RulePackageDTO dto, RulePackage entity) {
        try {
            BeanUtils.copyProperties((Object)((Object)entity), (Object)((Object)dto));
        }
        catch (Exception ex) {
            throw new ApplicationException(ex);
        }
    }

    private void entity2dto(RulePackage entity, RulePackageDTO dto) {
        try {
            BeanUtils.copyProperties((Object)((Object)dto), (Object)((Object)entity));
        }
        catch (Exception ex) {
            throw new ApplicationException(ex);
        }
    }

    @Override
    @Transactional
    public void saveRulePackage(RulePackageDTO dto) {
        RulePackage entity = new RulePackage();
        this.dto2entity(dto, entity);
        this.rulePackageDAO.save((Object)entity);
    }

    @Override
    @Transactional
    public void removeRulePackage(Long no) {
        this.rulePackageDAO.delete(this.rulePackageDAO.findById(no));
    }

    @Override
    @Transactional
    public void removeRulePackages(Long[] nos) {
        this.rulePackageDAO.deleteByIds(nos);
    }

    @Override
    @Transactional
    public RulePackageDTO mergeRulePackage(RulePackageDTO dto) {
        RulePackage entity = new RulePackage();
        this.dto2entity(dto, entity);
        entity.getRules().addAll(((RulePackage)((Object)this.rulePackageDAO.findById(entity.getRulePackageNo()))).getRules());
        entity = (RulePackage)((Object)this.rulePackageDAO.merge((Object)entity));
        this.entity2dto(entity, dto);
        return dto;
    }

    @Override
    @Transactional
    public void mergeAllRulePackage(List<RulePackageDTO> dtos) {
        ArrayList<RulePackage> entities = new ArrayList<RulePackage>();
        for (RulePackageDTO dto : dtos) {
            RulePackage entity = new RulePackage();
            this.dto2entity(dto, entity);
            entities.add(entity);
        }
        this.rulePackageDAO.mergeAll(entities);
    }

    @Override
    public List<RulePackageDTO> findRulePackages() {
        List<RulePackage> entities = this.rulePackageDAO.findRules();
        ArrayList<RulePackageDTO> dtos = new ArrayList<RulePackageDTO>();
        for (RulePackage entity : entities) {
            RulePackageDTO dto = new RulePackageDTO();
            this.entity2dto(entity, dto);
            dtos.add(dto);
        }
        return dtos;
    }

    @Override
    public RulePackageDTO findRulePackageById(Long no) {
        RulePackage entity = (RulePackage)((Object)this.rulePackageDAO.findById(no));
        RulePackageDTO dto = new RulePackageDTO();
        this.entity2dto(entity, dto);
        return dto;
    }
}

