/*
 * Decompiled with CFR 0.152.
 */
package com.sinba.common.rules.service;

import com.sinba.common.exception.ApplicationException;
import com.sinba.common.rules.dao.IRuleDAO;
import com.sinba.common.rules.dao.IRulePatternDAO;
import com.sinba.common.rules.dto.RulePatternDTO;
import com.sinba.common.rules.entity.Rule;
import com.sinba.common.rules.entity.RulePattern;
import com.sinba.common.rules.service.IRulePatternService;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RulePatternService
implements IRulePatternService {
    @Autowired
    private IRulePatternDAO rulePatternDAO;
    @Autowired
    private IRuleDAO ruleDAO;

    private void dto2entity(RulePatternDTO dto, RulePattern entity) {
        try {
            BeanUtils.copyProperties((Object)((Object)entity), (Object)((Object)dto));
        }
        catch (Exception ex) {
            throw new ApplicationException(ex);
        }
    }

    private void entity2dto(RulePattern entity, RulePatternDTO dto) {
        if (entity.getRule() != null) {
            Long ruleNo = entity.getRule().getRuleNo();
            String ruleName = entity.getRule().getRuleName();
            dto.setRuleNo(ruleNo);
            dto.setRuleName(ruleName);
        }
        try {
            BeanUtils.copyProperties((Object)((Object)dto), (Object)((Object)entity));
        }
        catch (Exception ex) {
            throw new ApplicationException(ex);
        }
    }

    @Override
    @Transactional
    public void saveRulePattern(RulePatternDTO dto) {
        RulePattern entity = new RulePattern();
        this.dto2entity(dto, entity);
        if (null != dto.getRuleNo()) {
            Rule rule = (Rule)((Object)this.ruleDAO.findById(dto.getRuleNo()));
            rule.setCondition(entity);
        }
        this.rulePatternDAO.save((Object)entity);
    }

    @Override
    @Transactional
    public void removeRulePattern(Long no) {
        this.rulePatternDAO.delete(this.rulePatternDAO.findById(no));
    }

    @Override
    @Transactional
    public void removeRulePatterns(Long[] nos) {
        this.rulePatternDAO.deleteByIds(nos);
    }

    @Override
    @Transactional
    public RulePatternDTO mergeRulePattern(RulePatternDTO dto) {
        RulePattern entity = new RulePattern();
        this.dto2entity(dto, entity);
        if (null != dto.getRuleNo()) {
            Rule rule = (Rule)((Object)this.ruleDAO.findById(dto.getRuleNo()));
            rule.setCondition(entity);
        }
        entity = (RulePattern)((Object)this.rulePatternDAO.merge((Object)entity));
        this.entity2dto(entity, dto);
        return dto;
    }

    @Override
    @Transactional
    public void mergeAllRulePattern(List<RulePatternDTO> dtos) {
        ArrayList<RulePattern> entities = new ArrayList<RulePattern>();
        for (RulePatternDTO dto : dtos) {
            RulePattern entity = new RulePattern();
            this.dto2entity(dto, entity);
            if (null != dto.getRuleNo()) {
                Rule rule = (Rule)((Object)this.ruleDAO.findById(dto.getRuleNo()));
                rule.setCondition(entity);
            }
            entities.add(entity);
        }
        this.rulePatternDAO.mergeAll(entities);
    }

    @Override
    public List<RulePatternDTO> findRulePatterns() {
        List entities = this.rulePatternDAO.findAll();
        ArrayList<RulePatternDTO> dtos = new ArrayList<RulePatternDTO>(entities.size());
        for (RulePattern entity : entities) {
            RulePatternDTO dto = new RulePatternDTO();
            this.entity2dto(entity, dto);
            dtos.add(dto);
        }
        return dtos;
    }

    @Override
    public RulePatternDTO findRulePatternById(Long no) {
        RulePattern entity = (RulePattern)((Object)this.rulePatternDAO.findById(no));
        RulePatternDTO dto = new RulePatternDTO();
        this.entity2dto(entity, dto);
        return dto;
    }

    @Override
    public RulePatternDTO findRulePatternByRuleNo(Long ruleNo) {
        Rule rule = (Rule)((Object)this.ruleDAO.findById(ruleNo));
        RulePattern entity = rule.getCondition();
        RulePatternDTO dto = new RulePatternDTO();
        this.entity2dto(entity, dto);
        return dto;
    }
}

