/*
 * Decompiled with CFR 0.152.
 */
package com.sinba.common.rules.service;

import com.sinba.common.dto.PageDTO;
import com.sinba.common.exception.ApplicationException;
import com.sinba.common.rules.dao.IRuleActionDAO;
import com.sinba.common.rules.dao.IRuleConstraintDAO;
import com.sinba.common.rules.dao.IRuleDAO;
import com.sinba.common.rules.dao.IRulePackageDAO;
import com.sinba.common.rules.dto.RuleDTO;
import com.sinba.common.rules.dto.RuleQueryDTO;
import com.sinba.common.rules.entity.Rule;
import com.sinba.common.rules.entity.RuleAction;
import com.sinba.common.rules.entity.RuleConstraint;
import com.sinba.common.rules.entity.RulePackage;
import com.sinba.common.rules.parser.ProcreationDrlFiles;
import com.sinba.common.rules.service.IRuleService;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.beanutils.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuleService
implements IRuleService {
    @Autowired
    private IRulePackageDAO rulePackageDAO;
    @Autowired
    private IRuleDAO ruleDAO;
    @Autowired
    private IRuleActionDAO ruleActionDAO;
    @Autowired
    private IRuleConstraintDAO ruleConstraintDAO;
    private ProcreationDrlFiles procreationDrlFiles = new ProcreationDrlFiles();

    private void dto2entity(RuleDTO dto, Rule entity) {
        try {
            BeanUtils.copyProperties((Object)((Object)entity), (Object)((Object)dto));
        }
        catch (Exception ex) {
            throw new ApplicationException(ex);
        }
    }

    @Override
    public void entity2dto(Rule entity, RuleDTO dto) {
        if (entity.getRulePackage() != null) {
            Long rulePackageNo = entity.getRulePackage().getRulePackageNo();
            String packageName = entity.getRulePackage().getPackageName();
            dto.setRulePackageNo(rulePackageNo);
            dto.setPackageName(packageName);
        }
        try {
            BeanUtils.copyProperties((Object)((Object)dto), (Object)((Object)entity));
        }
        catch (Exception ex) {
            throw new ApplicationException(ex);
        }
    }

    @Override
    @Transactional
    public void saveRule(RuleDTO dto) {
        Rule entity = new Rule();
        this.dto2entity(dto, entity);
        if (null != dto.getRulePackageNo()) {
            RulePackage rulePackage = (RulePackage)((Object)this.rulePackageDAO.findById(dto.getRulePackageNo()));
            entity.setRulePackage(rulePackage);
        }
        this.ruleDAO.save((Object)entity);
    }

    @Override
    @Transactional
    public boolean removeRule(Long no) {
        boolean result = true;
        Byte delete = 1;
        Rule rule = (Rule)((Object)this.ruleDAO.findById(no));
        if (rule.getDataFlag().equals(delete)) {
            result = false;
        } else {
            this.ruleDAO.delete(this.ruleDAO.findById(no));
        }
        return result;
    }

    @Override
    @Transactional
    public boolean removeRules(Long[] nos) {
        boolean result = true;
        Byte delete = 1;
        RulePackage rulePackage = null;
        for (Long id : nos) {
            Rule rule = (Rule)((Object)this.ruleDAO.findById(id));
            if (rule.getDataFlag().equals(delete)) {
                result = false;
                continue;
            }
            if (rulePackage != null) continue;
            rulePackage = rule.getRulePackage();
        }
        if (result) {
            this.ruleDAO.deleteByIds(nos);
        }
        this.procreationDrlFiles.printDrlFiles(rulePackage);
        return result;
    }

    @Override
    @Transactional
    public RuleDTO mergeRule(RuleDTO dto) {
        Rule entity = new Rule();
        this.dto2entity(dto, entity);
        if (null != dto.getRulePackageNo()) {
            RulePackage rulePackage = (RulePackage)((Object)this.rulePackageDAO.findById(dto.getRulePackageNo()));
            entity.setRulePackage(rulePackage);
        }
        entity = (Rule)((Object)this.ruleDAO.merge((Object)entity));
        this.entity2dto(entity, dto);
        this.procreationDrlFiles.printDrlFiles(entity);
        return dto;
    }

    @Override
    @Transactional
    public void mergeAllRule(List<RuleDTO> dtos) {
        ArrayList<Rule> entities = new ArrayList<Rule>();
        for (RuleDTO dto : dtos) {
            Rule entity = new Rule();
            this.dto2entity(dto, entity);
            if (null != dto.getRulePackageNo()) {
                RulePackage rulePackage = (RulePackage)((Object)this.rulePackageDAO.findById(dto.getRulePackageNo()));
                entity.setRulePackage(rulePackage);
            }
            entities.add(entity);
        }
        this.ruleDAO.mergeAll(entities);
    }

    @Override
    @Transactional
    public void saveRuleEntity(Rule rule) {
        Pattern pattern = Pattern.compile("[0-9]*");
        if (null != rule.getRulePackage()) {
            RulePackage rulePackage = (RulePackage)((Object)this.rulePackageDAO.findById(rule.getRulePackage().getRulePackageNo()));
            rule.setRulePackage(rulePackage);
        }
        if (rule.getCondition() != null && rule.getCondition().getConstraints() != null) {
            for (RuleConstraint constraint : rule.getCondition().getConstraints()) {
                Matcher isNum = pattern.matcher(constraint.getPropertyValue());
                if (!isNum.matches()) {
                    constraint.setPropertyType(true);
                } else {
                    constraint.setPropertyType(false);
                }
                constraint.setPattern(rule.getCondition());
            }
        }
        if (rule.getActions() != null) {
            for (RuleAction action : rule.getActions()) {
                action.setRule(rule);
            }
        }
        this.ruleDAO.save((Object)rule);
        this.procreationDrlFiles.printDrlFiles(rule);
    }

    @Override
    @Transactional
    public Rule mergeRuleEntity(Rule rule) {
        Pattern pattern = Pattern.compile("[0-9]*");
        Rule originRule = (Rule)((Object)this.ruleDAO.findById(rule.getRuleNo()));
        if (null != originRule.getCondition().getConstraints()) {
            this.ruleConstraintDAO.deleteAll(originRule.getCondition().getConstraints());
        }
        if (null != originRule.getActions()) {
            this.ruleActionDAO.deleteAll(originRule.getActions());
        }
        for (RuleConstraint constraint : rule.getCondition().getConstraints()) {
            Matcher isNum = pattern.matcher(constraint.getPropertyValue());
            if (!isNum.matches()) {
                constraint.setPropertyType(true);
            } else {
                constraint.setPropertyType(false);
            }
            constraint.setPattern(rule.getCondition());
        }
        for (RuleAction action : rule.getActions()) {
            action.setRule(rule);
        }
        rule = (Rule)((Object)this.ruleDAO.merge((Object)rule));
        this.procreationDrlFiles.printDrlFiles(rule);
        return rule;
    }

    @Override
    public PageDTO findRuleByPager(RuleQueryDTO qdto, int start, int limit, String sidx, String sord) {
        PageDTO p = this.ruleDAO.findPager(qdto, start, limit, sidx, sord);
        List entities = p.getData();
        ArrayList<RuleDTO> dtos = new ArrayList<RuleDTO>();
        for (Rule entity : entities) {
            RuleDTO dto = new RuleDTO();
            this.entity2dto(entity, dto);
            dtos.add(dto);
        }
        p.setData(dtos);
        return p;
    }

    @Override
    public RuleDTO findRuleDTOById(Long no) {
        Rule entity = (Rule)((Object)this.ruleDAO.findById(no));
        RuleDTO dto = new RuleDTO();
        this.entity2dto(entity, dto);
        return dto;
    }

    @Override
    @Transactional
    public Rule findRuleById(Long no) {
        Rule entity = (Rule)((Object)this.ruleDAO.findById(no));
        if (entity != null) {
            if (entity.getActions() != null) {
                entity.getActions().size();
            }
            if (entity.getCondition() != null) {
                entity.getCondition().getConstraints().size();
            }
            return entity;
        }
        return null;
    }

    public String writeDrlFile() {
        RulePackage rulePackage = (RulePackage)((Object)this.rulePackageDAO.findById(Long.valueOf(1L)));
        if (rulePackage != null) {
            return rulePackage.toString();
        }
        return null;
    }
}

