/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.analysis.analyzer;

import java.util.Properties;
import net.paoding.analysis.Constants;
import net.paoding.analysis.analyzer.PaodingAnalyzerBean;
import net.paoding.analysis.analyzer.estimate.TryPaodingAnalyzer;
import net.paoding.analysis.knife.Knife;
import net.paoding.analysis.knife.Paoding;
import net.paoding.analysis.knife.PaodingMaker;

public class PaodingAnalyzer
extends PaodingAnalyzerBean {
    public PaodingAnalyzer() {
        this("classpath:paoding-analysis.properties");
    }

    public PaodingAnalyzer(String propertiesPath) {
        this.init(propertiesPath);
    }

    protected void init(String propertiesPath) {
        if (propertiesPath == null) {
            propertiesPath = "classpath:paoding-analysis.properties";
        }
        Properties properties = PaodingMaker.getProperties(propertiesPath);
        String mode = Constants.getProperty(properties, "paoding.analyzer.mode");
        Paoding paoding = PaodingMaker.make(properties);
        this.setKnife(paoding);
        this.setMode(mode);
    }

    public static void main(String[] args) {
        if (System.getProperty("paoding.try.app") == null) {
            System.setProperty("paoding.try.app", "PaodingAnalyzer");
            System.setProperty("paoding.try.cmd", "java PaodingAnalyzer");
        }
        TryPaodingAnalyzer.main(args);
    }

    public PaodingAnalyzer(Knife knife, int mode) {
        super(knife, mode);
    }

    public static PaodingAnalyzer queryMode(Knife knife) {
        return PaodingAnalyzer.maxMode(knife);
    }

    public static PaodingAnalyzer defaultMode(Knife knife) {
        return new PaodingAnalyzer(knife, 1);
    }

    public static PaodingAnalyzer maxMode(Knife knife) {
        return new PaodingAnalyzer(knife, 2);
    }

    public static PaodingAnalyzer writerMode(Knife knife) {
        return PaodingAnalyzer.defaultMode(knife);
    }
}

