/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.analysis.analyzer;

import java.io.Reader;
import net.paoding.analysis.analyzer.PaodingTokenizer;
import net.paoding.analysis.analyzer.TokenCollector;
import net.paoding.analysis.analyzer.impl.MaxWordLengthTokenCollector;
import net.paoding.analysis.analyzer.impl.MostWordsTokenCollector;
import net.paoding.analysis.knife.Knife;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;

public class PaodingAnalyzerBean
extends Analyzer {
    public static final int MOST_WORDS_MODE = 1;
    public static final int MAX_WORD_LENGTH_MODE = 2;
    private Knife knife;
    private int mode = 1;
    private Class modeClass;

    public PaodingAnalyzerBean() {
    }

    public PaodingAnalyzerBean(Knife knife) {
        this.knife = knife;
    }

    public PaodingAnalyzerBean(Knife knife, int mode) {
        this.knife = knife;
        this.mode = mode;
    }

    public PaodingAnalyzerBean(Knife knife, String mode) {
        this.knife = knife;
        this.setMode(mode);
    }

    public Knife getKnife() {
        return this.knife;
    }

    public void setKnife(Knife knife) {
        this.knife = knife;
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        if (mode != 1 && mode != 2) {
            throw new IllegalArgumentException("wrong mode:" + mode);
        }
        this.mode = mode;
        this.modeClass = null;
    }

    public void setModeClass(Class modeClass) {
        this.modeClass = modeClass;
    }

    public void setModeClass(String modeClass) {
        try {
            this.modeClass = Class.forName(modeClass);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("not found mode class:" + e.getMessage());
        }
    }

    public void setMode(String mode) {
        if (mode.startsWith("class:")) {
            this.setModeClass(mode.substring("class:".length()));
        } else if ("most-words".equalsIgnoreCase(mode) || "default".equalsIgnoreCase(mode) || "1".equals(mode)) {
            this.setMode(1);
        } else if ("max-word-length".equalsIgnoreCase(mode) || "2".equals(mode)) {
            this.setMode(2);
        } else {
            throw new IllegalArgumentException("\u4e0d\u5408\u6cd5\u7684\u5206\u6790\u5668Mode\u53c2\u6570\u8bbe\u7f6e:" + mode);
        }
    }

    public TokenStream tokenStream(String fieldName, Reader reader) {
        if (this.knife == null) {
            throw new NullPointerException("knife should be set before token");
        }
        return new PaodingTokenizer(reader, this.knife, this.createTokenCollector());
    }

    protected TokenCollector createTokenCollector() {
        if (this.modeClass != null) {
            try {
                return (TokenCollector)this.modeClass.newInstance();
            }
            catch (InstantiationException e) {
                throw new IllegalArgumentException("wrong mode class:" + e.getMessage());
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("wrong mode class:" + e.getMessage());
            }
        }
        switch (this.mode) {
            case 1: {
                return new MostWordsTokenCollector();
            }
            case 2: {
                return new MaxWordLengthTokenCollector();
            }
        }
        throw new Error("never happened");
    }
}

