/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.analysis.analyzer;

import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;
import net.paoding.analysis.analyzer.TokenCollector;
import net.paoding.analysis.knife.Beef;
import net.paoding.analysis.knife.Collector;
import net.paoding.analysis.knife.Knife;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;

public final class PaodingTokenizer
extends TokenStream
implements Collector {
    private final Reader input;
    private int inputLength;
    private static final int bufferLength = 128;
    private final char[] buffer = new char[128];
    private int offset;
    private final Beef beef = new Beef(this.buffer, 0, 0);
    private int dissected;
    private Knife knife;
    private TokenCollector tokenCollector;
    private Iterator tokenIteractor;

    public PaodingTokenizer(Reader input, Knife knife, TokenCollector tokenCollector) {
        this.input = input;
        this.knife = knife;
        this.tokenCollector = tokenCollector;
    }

    public TokenCollector getTokenCollector() {
        return this.tokenCollector;
    }

    public void setTokenCollector(TokenCollector tokenCollector) {
        this.tokenCollector = tokenCollector;
    }

    public void collect(String word, int offset, int end) {
        this.tokenCollector.collect(word, this.offset + offset, this.offset + end);
    }

    public Token next() throws IOException {
        while (this.tokenIteractor == null || !this.tokenIteractor.hasNext()) {
            int read = 0;
            int remainning = -1;
            if (this.dissected >= this.beef.length()) {
                remainning = 0;
            } else if (this.dissected < 0) {
                remainning = 128 + this.dissected;
            }
            if (remainning >= 0) {
                if (remainning > 0) {
                    System.arraycopy(this.buffer, -this.dissected, this.buffer, 0, remainning);
                }
                read = this.input.read(this.buffer, remainning, 128 - remainning);
                this.inputLength += read;
                int charCount = remainning + read;
                if (charCount < 0) {
                    return null;
                }
                if (charCount < 128) {
                    this.buffer[charCount++] = '\u0000';
                }
                this.beef.set(0, charCount);
                this.offset += Math.abs(this.dissected);
                this.dissected = 0;
            }
            this.dissected = this.knife.dissect(this, this.beef, this.dissected);
            this.tokenIteractor = this.tokenCollector.iterator();
        }
        return (Token)this.tokenIteractor.next();
    }

    public int getInputLength() {
        return this.inputLength;
    }

    public void close() throws IOException {
        super.close();
        this.input.close();
    }
}

