/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.analysis.analyzer.estimate;

import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import java.util.LinkedList;
import net.paoding.analysis.analyzer.PaodingTokenizer;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;

public class Estimate {
    private Analyzer analyzer;
    private String print;
    private PrintGate printGate;

    public Estimate() {
        this.setPrint("50");
    }

    public Estimate(Analyzer analyzer) {
        this.setAnalyzer(analyzer);
        this.setPrint("50");
    }

    public void setAnalyzer(Analyzer analyzer) {
        this.analyzer = analyzer;
    }

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    public void setPrint(String print) {
        if (print == null || print.length() == 0 || print.equalsIgnoreCase("null") || print.equalsIgnoreCase("no")) {
            this.printGate = null;
            this.print = null;
        } else {
            this.printGate = new LinePrintGate();
            this.printGate.setPrint(print, 10);
            this.print = print;
        }
    }

    public String getPrint() {
        return this.print;
    }

    public void test(String input) {
        this.test(System.out, input);
    }

    public void test(PrintStream out, String input) {
        StringReaderEx reader = new StringReaderEx(input);
        this.test(out, reader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test(PrintStream out, Reader reader) {
        try {
            Token token;
            long begin = System.currentTimeMillis();
            TokenStream ts = this.analyzer.tokenStream("", reader);
            LinkedList<CToken> list = new LinkedList<CToken>();
            int wordsCount = 0;
            while ((token = ts.next()) != null) {
                if (this.printGate != null && this.printGate.filter(wordsCount)) {
                    list.add(new CToken(token, wordsCount));
                }
                ++wordsCount;
            }
            long end = System.currentTimeMillis();
            int c = 0;
            if (list.size() > 0) {
                Iterator iter = list.iterator();
                while (iter.hasNext()) {
                    CToken ctoken = (CToken)iter.next();
                    c = ctoken.i;
                    token = ctoken.t;
                    if (c % 10 == 0) {
                        if (c != 0) {
                            out.println();
                        }
                        out.print(c / 10 + 1 + ":\t");
                    }
                    out.print(token.termText() + "/");
                }
            }
            if (wordsCount == 0) {
                System.out.println("\tAll are noise characters or words");
            } else {
                if (c % 10 != 1) {
                    System.out.println();
                }
                String inputLength = "<\u672a\u77e5>";
                if (reader instanceof StringReaderEx) {
                    inputLength = "" + ((StringReaderEx)reader).inputLength;
                } else if (ts instanceof PaodingTokenizer) {
                    inputLength = "" + ((PaodingTokenizer)ts).getInputLength();
                }
                System.out.println();
                System.out.println("\t\u5206\u8bcd\u5668" + this.analyzer.getClass().getName());
                System.out.println("\t\u5185\u5bb9\u957f\u5ea6 " + inputLength + "\u5b57\u7b26\uff0c \u5206 " + wordsCount + "\u4e2a\u8bcd");
                System.out.println("\t\u5206\u8bcd\u8017\u65f6 " + (end - begin) + "ms ");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
    }

    static class StringReaderEx
    extends StringReader {
        private int inputLength;

        public StringReaderEx(String s) {
            super(s);
            this.inputLength = s.length();
        }
    }

    static class LinePrintGate
    implements PrintGate {
        private PrintGate[] list;

        LinePrintGate() {
        }

        public void setPrint(String print, int unitSize) {
            String[] prints = print.split(",");
            this.list = new PrintGate[prints.length];
            for (int i = 0; i < prints.length; ++i) {
                PrintGateToken pg = new PrintGateToken();
                pg.setPrint(prints[i], unitSize);
                this.list[i] = pg;
            }
        }

        public boolean filter(int count) {
            for (int i = 0; i < this.list.length; ++i) {
                if (!this.list[i].filter(count)) continue;
                return true;
            }
            return false;
        }
    }

    static class PrintGateToken
    implements PrintGate {
        private int begin;
        private int end;

        PrintGateToken() {
        }

        public void setBegin(int begin) {
            this.begin = begin;
        }

        public void setEnd(int end) {
            this.end = end;
        }

        public void setPrint(String print, int unitSize) {
            int i = print.indexOf(45);
            if (i > 0) {
                int bv = Integer.parseInt(print.substring(0, i));
                int ev = Integer.parseInt(print.substring(i + 1));
                this.setBegin(unitSize * (Math.abs(bv) - 1));
                this.setEnd(unitSize * Math.abs(ev));
            } else {
                this.setBegin(0);
                int v = Integer.parseInt(print);
                this.setEnd(unitSize * Math.abs(v));
            }
        }

        public boolean filter(int count) {
            return count >= this.begin && count < this.end;
        }
    }

    static interface PrintGate {
        public void setPrint(String var1, int var2);

        public boolean filter(int var1);
    }

    static class CToken {
        Token t;
        int i;

        CToken(Token t, int i) {
            this.t = t;
            this.i = i;
        }
    }
}

