/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.analysis.analyzer.estimate;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import net.paoding.analysis.analyzer.PaodingAnalyzer;
import net.paoding.analysis.analyzer.estimate.Estimate;
import org.apache.lucene.analysis.Analyzer;

public class TryPaodingAnalyzer {
    private static final String ARGS_TIP = ":";
    static String input = null;
    static String file = null;
    static Reader reader = null;
    static String charset = null;
    static String mode = null;
    static String analyzerName = null;
    static String print = null;
    static String properties = "classpath:paoding-analysis.properties";
    private static boolean titlePrinted = false;
    private static boolean welcomePrinted = false;
    static /* synthetic */ Class class$net$paoding$analysis$analyzer$estimate$TryPaodingAnalyzer;
    static /* synthetic */ Class class$net$paoding$analysis$analyzer$estimate$Estimate;

    public static void main(String[] args) {
        try {
            TryPaodingAnalyzer.resetArgs();
            int inInput = 0;
            for (int i = 0; i < args.length; ++i) {
                if (args[i] == null || (args[i] = args[i].trim()).length() == 0) continue;
                if (args[i].equals("--file") || args[i].equals("-f")) {
                    file = args[++i];
                    continue;
                }
                if (args[i].equals("--charset") || args[i].equals("-c")) {
                    charset = args[++i];
                    continue;
                }
                if (args[i].equals("--mode") || args[i].equals("-m")) {
                    mode = args[++i];
                    continue;
                }
                if (args[i].equals("--properties") || args[i].equals("-p")) {
                    properties = args[++i];
                    continue;
                }
                if (args[i].equals("--analyzer") || args[i].equals("-a")) {
                    analyzerName = args[++i];
                    continue;
                }
                if (args[i].equals("--print") || args[i].equals("-P")) {
                    print = args[++i];
                    continue;
                }
                if (args[i].equals("--input") || args[i].equals("-i")) {
                    ++inInput;
                    continue;
                }
                if (args[i].equals("--help") || args[i].equals("-h") || args[i].equals("?")) {
                    TryPaodingAnalyzer.printHelp();
                    return;
                }
                if (args[i].startsWith("-") || i != 0 && !args[i - 1].equals("-i") && !args[i - 1].equals("--input") && args[i - 1].startsWith("-")) continue;
                input = input == null ? args[i] : input + ' ' + args[i];
                ++inInput;
            }
            if (file != null) {
                input = null;
                reader = TryPaodingAnalyzer.getReader(file, charset);
            }
            TryPaodingAnalyzer.analysing();
        }
        catch (Exception e1) {
            TryPaodingAnalyzer.resetArgs();
            e1.printStackTrace();
        }
    }

    private static void resetArgs() {
        input = null;
        file = null;
        reader = null;
        charset = null;
        mode = null;
        print = null;
        analyzerName = null;
        properties = "classpath:paoding-analysis.properties";
    }

    private static void analysing() throws Exception {
        PaodingAnalyzer analyzer;
        if (analyzerName == null || analyzerName.length() == 0 || analyzerName.equalsIgnoreCase("paoding")) {
            analyzer = new PaodingAnalyzer(properties);
            if (mode != null) {
                analyzer.setMode(mode);
            }
        } else {
            if (analyzerName.equalsIgnoreCase("standard")) {
                analyzerName = "org.apache.lucene.analysis.standard.StandardAnalyzer";
            } else if (analyzerName.equalsIgnoreCase("cjk")) {
                analyzerName = "org.apache.lucene.analysis.cjk.CJKAnalyzer";
            } else if (analyzerName.equalsIgnoreCase("cn") || analyzerName.equalsIgnoreCase("chinese")) {
                analyzerName = "org.apache.lucene.analysis.cn.ChineseAnalyzer";
            } else if (analyzerName.equalsIgnoreCase("st") || analyzerName.equalsIgnoreCase("standard")) {
                analyzerName = "org.apache.lucene.analysis.standard.StandardAnalyzer";
            }
            Class<?> clz = Class.forName(analyzerName);
            analyzer = (Analyzer)clz.newInstance();
        }
        boolean readInputFromConsle = false;
        Estimate estimate = new Estimate(analyzer);
        if (print != null) {
            estimate.setPrint(print);
        }
        while (true) {
            if (reader == null) {
                if (input == null || input.length() == 0 || readInputFromConsle) {
                    input = TryPaodingAnalyzer.getInputFromConsole();
                    readInputFromConsle = true;
                }
                if (input == null || input.length() == 0) {
                    System.out.println("Warn: none charactors you input!!");
                    continue;
                }
                if (input.startsWith(ARGS_TIP)) {
                    String argsStr = input.substring(ARGS_TIP.length());
                    TryPaodingAnalyzer.main(argsStr.split(" "));
                    continue;
                }
            }
            if (reader != null) {
                estimate.test(System.out, reader);
                reader = null;
            } else {
                estimate.test(System.out, input);
                input = null;
            }
            System.out.println("--------------------------------------------------");
            if (!readInputFromConsle) break;
        }
    }

    private static String getInputFromConsole() throws IOException {
        TryPaodingAnalyzer.printTitleIfNotPrinted("");
        String input = null;
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        while (true) {
            System.out.print("paoding> ");
            String line = reader.readLine();
            if (line == null || line.length() == 0) continue;
            if (line.equals(":clear") || line.equals(":c")) {
                input = null;
                System.out.println("paoding> Cleared");
                return TryPaodingAnalyzer.getInputFromConsole();
            }
            if (line.equals(":exit") || line.equals(":quit") || line.equals(":e") || line.equals(":q")) {
                System.out.println("Bye!");
                System.exit(0);
                continue;
            }
            if (input == null && line.startsWith(ARGS_TIP)) {
                input = line;
                break;
            }
            if (line.endsWith(";")) {
                if (line.length() <= ";".length()) break;
                input = line.substring(0, line.length() - ";".length());
                break;
            }
            if (input == null) {
                input = line;
                continue;
            }
            input = input + "\n" + line;
        }
        return input == null ? null : input.trim();
    }

    private static void printHelp() {
        String app = System.getProperty("paoding.try.app", "TryPaodingAnalyzer");
        String cmd = System.getProperty("paoding.try.cmd", "java " + (class$net$paoding$analysis$analyzer$estimate$TryPaodingAnalyzer == null ? (class$net$paoding$analysis$analyzer$estimate$TryPaodingAnalyzer = TryPaodingAnalyzer.class$("net.paoding.analysis.analyzer.estimate.TryPaodingAnalyzer")) : class$net$paoding$analysis$analyzer$estimate$TryPaodingAnalyzer).getName());
        System.out.println(app + "\u7684\u7528\u6cd5:");
        System.out.println("\t" + cmd + " [OPTIONS] [text_content]");
        System.out.println("\nOPTIONS:");
        System.out.println("\t--file, -f:\n\t\t\u6587\u7ae0\u4ee5\u6587\u4ef6\u7684\u5f62\u5f0f\u8f93\u5165\uff0c\u5728\u524d\u7f00\u52a0\u4e0a\"classpath:\"\u8868\u793a\u4ece\u7c7b\u8def\u5f84\u4e2d\u5bfb\u627e\u8be5\u6587\u4ef6\u3002");
        System.out.println("\t--charset, -c:\n\t\t\u6587\u7ae0\u7684\u5b57\u7b26\u96c6\u7f16\u7801\uff0c\u6bd4\u5982gbk,utf-8\u7b49\u3002\u5982\u679c\u6ca1\u6709\u8bbe\u7f6e\u8be5\u9009\u9879\uff0c\u5219\u4f7f\u7528Java\u73af\u5883\u9ed8\u8ba4\u7684\u5b57\u7b26\u96c6\u7f16\u7801\u3002");
        System.out.println("\t--properties, -p:\n\t\t\u4e0d\u8bfb\u53d6\u9ed8\u8ba4\u7684\u7c7b\u8def\u5f84\u4e0b\u7684\u5e96\u4e01\u5206\u8bcd\u5c5e\u6027\u6587\u4ef6\uff0c\u800c\u4f7f\u7528\u6307\u5b9a\u7684\u6587\u4ef6\uff0c\u5728\u524d\u7f00\u52a0\u4e0a\"classpath:\"\u8868\u793a\u4ece\u7c7b\u8def\u5f84\u4e2d\u5bfb\u627e\u8be5\u6587\u4ef6\u3002");
        System.out.println("\t--mode, -m:\n\t\t\u5f3a\u5236\u4f7f\u7528\u7ed9\u5b9a\u7684mode\u7684\u5206\u8bcd\u5668\uff1b\u53ef\u4ee5\u8bbe\u5b9a\u4e3adefault,most-words,max-word-length\u6216\u6307\u5b9a\u7c7b\u540d\u7684\u5176\u4ed6mode(\u6307\u5b9a\u7c7b\u540d\u7684\uff0c\u9700\u8981\u52a0\u524d\u7f00\"class:\")\u3002");
        System.out.println("\t--input, -i:\n\t\t\u8981\u88ab\u5206\u8bcd\u7684\u6587\u7ae0\u5185\u5bb9\uff1b\u5f53\u6ca1\u6709\u901a\u8fc7-f\u6216--file\u6307\u5b9a\u6587\u7ae0\u8f93\u5165\u6587\u4ef6\u65f6\u53ef\u9009\u62e9\u8fd9\u4e2a\u9009\u9879\u6307\u5b9a\u8981\u88ab\u5206\u8bcd\u7684\u5185\u5bb9\u3002");
        System.out.println("\t--analyzer, -a:\n\t\t\u6d4b\u8bd5\u5176\u4ed6\u5206\u8bcd\u5668\uff0c\u901a\u8fc7--analyzer\u6216-a\u6307\u5b9a\u5176\u5b8c\u6574\u7c7b\u540d\u3002\u7279\u522b\u5730\uff0cpaoding\u3001cjk\u3001chinese\u3001st\u5206\u522b\u5bf9\u5e94PaodingAnalyzer\u3001CJKAnalyzer\u3001ChineseAnalyzer\u3001StandardAnalyzer");
        System.out.println("\t--print, -P:\n\t\t \u662f\u5426\u6253\u5370\u5206\u8bcd\u7ed3\u679c\u3002\u9ed8\u8ba4\u6253\u5370\u524d50\u884c\u3002\u89c4\u5219\uff1ano\u8868\u793a\u4e0d\u6253\u5370\uff1b50\u7b49\u4ef7\u4e8e1-50\u884c\uff1b1-50\u8868\u793a\u6253\u53701\u81f350\u884c;\u53ef\u4ee5\u4ee5\u9017\u53f7\u7ec4\u5408\u4f7f\u7528\uff0c\u598220,40-50\u8868\u793a\u6253\u53701-20\u4ee5\u53ca40-50\u884c");
        System.out.println("\n\u793a\u4f8b:");
        System.out.println("\t" + cmd);
        System.out.println("\t" + cmd + " ?");
        System.out.println("\t" + cmd + " \u4e2d\u534e\u4eba\u6c11\u5171\u548c\u56fd");
        System.out.println("\t" + cmd + " -m max \u4e2d\u534e\u4eba\u6c11\u5171\u548c\u56fd");
        System.out.println("\t" + cmd + " -f e:/content.txt -c utf8");
        System.out.println("\t" + cmd + " -f e:/content.txt -c utf8 -m max-word-length");
        System.out.println("\t" + cmd + " -f e:/content.txt -c utf8 -a cjk");
        System.out.println("\n\u82e5\u662f\u63a7\u5236\u53f0\u8fdb\u5165\"paoding>\"\u540e:");
        titlePrinted = false;
        TryPaodingAnalyzer.printTitleIfNotPrinted("\t");
    }

    private static void printTitleIfNotPrinted(String prefix) {
        if (!titlePrinted) {
            System.out.println();
            if (!welcomePrinted) {
                System.out.println("Welcome to Paoding Analyser(2.0.4-alpha2)");
                System.out.println();
                welcomePrinted = true;
            }
            System.out.println(prefix + "\u76f4\u63a5\u8f93\u5165\u6216\u7c98\u8d34\u8981\u88ab\u5206\u8bcd\u7684\u5185\u5bb9\uff0c\u4ee5\u5206\u53f7;\u7ed3\u675f\uff0c\u56de\u8f66\u540e\u5f00\u59cb\u5206\u8bcd\u3002");
            System.out.println(prefix + "\u53e6\u8d77\u4e00\u884c\u8f93\u5165:clear\u6216:c\uff0c\u4f7f\u6b64\u6b21\u8f93\u5165\u65e0\u6548\uff0c\u7528\u4ee5\u91cd\u65b0\u8f93\u5165\u3002");
            System.out.println(prefix + "\u8981\u4f7f\u7528\u547d\u4ee4\u884c\u53c2\u6570\u8bfb\u5165\u6587\u4ef6\u5185\u5bb9\u6216\u5176\u4ed6\u53c2\u6570\u8bf7\u4ee5\u5192\u53f7:\u5f00\u59cb\uff0c\u7136\u540e\u8f93\u5165\u53c2\u6570\u9009\u9879\u3002");
            System.out.println(prefix + "\u9000\u51fa\uff0c\u8bf7\u8f93\u5165:quit\u6216:q\u3001:exit\u3001:e");
            System.out.println(prefix + "\u9700\u8981\u5e2e\u52a9\uff0c\u8bf7\u8f93\u5165:?");
            System.out.println(prefix + "\u6ce8\u610f\uff1a\u6307\u5b9a\u5bf9\u6587\u4ef6\u5206\u8bcd\u4e4b\u524d\u8981\u4e86\u89e3\u8be5\u6587\u4ef6\u7684\u7f16\u7801\uff0c\u5982\u679c\u7cfb\u7edf\u7f16\u7801\u548c\u6587\u4ef6\u7f16\u7801\u4e0d\u4e00\u81f4\uff0c\u8981\u901a\u8fc7-c\u6307\u5b9a\u6587\u4ef6\u7684\u7f16\u7801\u3002");
            System.out.println();
            titlePrinted = true;
        }
    }

    static String getContent(String path, String encoding) throws IOException {
        return (String)TryPaodingAnalyzer.read(path, encoding, true);
    }

    static Reader getReader(String path, String encoding) throws IOException {
        return (Reader)TryPaodingAnalyzer.read(path, encoding, false);
    }

    static Object read(String path, String encoding, boolean return_string) throws IOException {
        int count;
        InputStream in;
        if (path.startsWith("classpath:")) {
            path = path.substring("classpath:".length());
            URL url = (class$net$paoding$analysis$analyzer$estimate$Estimate == null ? (class$net$paoding$analysis$analyzer$estimate$Estimate = TryPaodingAnalyzer.class$("net.paoding.analysis.analyzer.estimate.Estimate")) : class$net$paoding$analysis$analyzer$estimate$Estimate).getClassLoader().getResource(path);
            if (url == null) {
                throw new IllegalArgumentException("Not found " + path + " in classpath.");
            }
            System.out.println("read content from:" + url.getFile());
            in = url.openStream();
        } else {
            File f = new File(path);
            if (!f.exists()) {
                throw new IllegalArgumentException("Not found " + path + " in system.");
            }
            System.out.println("read content from:" + f.getAbsolutePath());
            in = new FileInputStream(f);
        }
        InputStreamReader re = encoding != null ? new InputStreamReader(in, encoding) : new InputStreamReader(in);
        if (!return_string) {
            return re;
        }
        char[] chs = new char[1024];
        StringBuffer content = new StringBuffer();
        while ((count = re.read(chs)) != -1) {
            content.append(chs, 0, count);
        }
        ((Reader)re).close();
        return content.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

