/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.analysis.analyzer.impl;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import net.paoding.analysis.dictionary.BinaryDictionary;
import net.paoding.analysis.dictionary.Dictionary;
import net.paoding.analysis.dictionary.HashBinaryDictionary;
import net.paoding.analysis.dictionary.Word;
import net.paoding.analysis.dictionary.support.detection.Detector;
import net.paoding.analysis.dictionary.support.detection.DifferenceListener;
import net.paoding.analysis.dictionary.support.filewords.FileWordsReader;
import net.paoding.analysis.exception.PaodingAnalysisException;
import net.paoding.analysis.knife.Dictionaries;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CompiledFileDictionaries
implements Dictionaries {
    protected Log log = LogFactory.getLog(this.getClass());
    protected Dictionary vocabularyDictionary;
    protected Dictionary combinatoricsDictionary;
    protected Dictionary confucianFamilyNamesDictionary;
    protected Dictionary noiseCharactorsDictionary;
    protected Dictionary noiseWordsDictionary;
    protected Dictionary unitsDictionary;
    protected String dicHome;
    protected String noiseCharactor;
    protected String noiseWord;
    protected String unit;
    protected String confucianFamilyName;
    protected String combinatorics;
    protected String charsetName;
    private Detector detector;
    static /* synthetic */ Class class$java$util$LinkedList;

    public CompiledFileDictionaries() {
    }

    public CompiledFileDictionaries(String dicHome, String noiseCharactor, String noiseWord, String unit, String confucianFamilyName, String combinatorics, String charsetName) {
        this.dicHome = dicHome;
        this.noiseCharactor = noiseCharactor;
        this.noiseWord = noiseWord;
        this.unit = unit;
        this.confucianFamilyName = confucianFamilyName;
        this.combinatorics = combinatorics;
        this.charsetName = charsetName;
    }

    public String getDicHome() {
        return this.dicHome;
    }

    public void setDicHome(String dicHome) {
        this.dicHome = dicHome;
    }

    public String getNoiseCharactor() {
        return this.noiseCharactor;
    }

    public void setNoiseCharactor(String noiseCharactor) {
        this.noiseCharactor = noiseCharactor;
    }

    public String getNoiseWord() {
        return this.noiseWord;
    }

    public void setNoiseWord(String noiseWord) {
        this.noiseWord = noiseWord;
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public String getConfucianFamilyName() {
        return this.confucianFamilyName;
    }

    public void setConfucianFamilyName(String confucianFamilyName) {
        this.confucianFamilyName = confucianFamilyName;
    }

    public String getCharsetName() {
        return this.charsetName;
    }

    public void setCharsetName(String charsetName) {
        this.charsetName = charsetName;
    }

    public void setLantinFllowedByCjk(String lantinFllowedByCjk) {
        this.combinatorics = lantinFllowedByCjk;
    }

    public String getLantinFllowedByCjk() {
        return this.combinatorics;
    }

    public synchronized Dictionary getVocabularyDictionary() {
        if (this.vocabularyDictionary == null) {
            this.vocabularyDictionary = new HashBinaryDictionary(this.getVocabularyWords(), 12287, 0.75f);
        }
        return this.vocabularyDictionary;
    }

    public synchronized Dictionary getConfucianFamilyNamesDictionary() {
        if (this.confucianFamilyNamesDictionary == null) {
            this.confucianFamilyNamesDictionary = new BinaryDictionary(this.getConfucianFamilyNames());
        }
        return this.confucianFamilyNamesDictionary;
    }

    public synchronized Dictionary getNoiseCharactorsDictionary() {
        if (this.noiseCharactorsDictionary == null) {
            this.noiseCharactorsDictionary = new HashBinaryDictionary(this.getNoiseCharactors(), 256, 0.75f);
        }
        return this.noiseCharactorsDictionary;
    }

    public synchronized Dictionary getNoiseWordsDictionary() {
        if (this.noiseWordsDictionary == null) {
            this.noiseWordsDictionary = new BinaryDictionary(this.getNoiseWords());
        }
        return this.noiseWordsDictionary;
    }

    public synchronized Dictionary getUnitsDictionary() {
        if (this.unitsDictionary == null) {
            this.unitsDictionary = new HashBinaryDictionary(this.getUnits(), 1024, 0.75f);
        }
        return this.unitsDictionary;
    }

    public synchronized Dictionary getCombinatoricsDictionary() {
        if (this.combinatoricsDictionary == null) {
            this.combinatoricsDictionary = new BinaryDictionary(this.getCombinatoricsWords());
        }
        return this.combinatoricsDictionary;
    }

    public synchronized void startDetecting(int interval, DifferenceListener l) {
        if (this.detector != null || interval < 0) {
            return;
        }
        Detector detector = new Detector();
        detector.setHome(this.dicHome);
        detector.setFilter(null);
        detector.setFilter(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.getPath().endsWith(".dic.compiled") || pathname.getPath().endsWith(".metadata");
            }
        });
        detector.setLastSnapshot(detector.flash());
        detector.setListener(l);
        detector.setInterval(interval);
        detector.start(true);
        this.detector = detector;
    }

    public synchronized void stopDetecting() {
        if (this.detector == null) {
            return;
        }
        this.detector.setStop();
        this.detector = null;
    }

    protected Word[] getDictionaryWords(String dicNameRelativeDicHome) {
        File f = new File(this.dicHome, "/" + dicNameRelativeDicHome + ".dic.compiled");
        if (!f.exists()) {
            return new Word[0];
        }
        try {
            Map map = FileWordsReader.readWords(f.getAbsolutePath(), this.charsetName, class$java$util$LinkedList == null ? (class$java$util$LinkedList = CompiledFileDictionaries.class$("java.util.LinkedList")) : class$java$util$LinkedList, ".dic.compiled");
            List wordsList = (List)map.values().iterator().next();
            return wordsList.toArray(new Word[wordsList.size()]);
        }
        catch (IOException e) {
            throw this.toRuntimeException(e);
        }
    }

    protected Word[] getVocabularyWords() {
        return this.getDictionaryWords("vocabulary");
    }

    protected Word[] getConfucianFamilyNames() {
        return this.getDictionaryWords(this.confucianFamilyName);
    }

    protected Word[] getNoiseWords() {
        return this.getDictionaryWords(this.noiseWord);
    }

    protected Word[] getNoiseCharactors() {
        return this.getDictionaryWords(this.noiseCharactor);
    }

    protected Word[] getUnits() {
        return this.getDictionaryWords(this.unit);
    }

    protected Word[] getCombinatoricsWords() {
        return this.getDictionaryWords(this.combinatorics);
    }

    protected RuntimeException toRuntimeException(IOException e) {
        return new PaodingAnalysisException(e);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

