/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.analysis.analyzer.impl;

import java.util.Iterator;
import net.paoding.analysis.analyzer.TokenCollector;
import org.apache.lucene.analysis.Token;

public class MostWordsTokenCollector
implements TokenCollector,
Iterator {
    private LinkedToken firstToken;
    private LinkedToken lastToken;
    private LinkedToken nextLinkedToken;

    public void collect(String word, int begin, int end) {
        LinkedToken tokenToAdd = new LinkedToken(word, begin, end);
        if (this.firstToken == null) {
            this.firstToken = tokenToAdd;
            this.lastToken = tokenToAdd;
            return;
        }
        if (tokenToAdd.compareTo(this.lastToken) > 0) {
            tokenToAdd.pre = this.lastToken;
            this.lastToken.next = tokenToAdd;
            this.lastToken = tokenToAdd;
        } else {
            LinkedToken curTokenToTry = this.lastToken.pre;
            while (curTokenToTry != null && tokenToAdd.compareTo(curTokenToTry) < 0) {
                curTokenToTry = curTokenToTry.pre;
            }
            if (curTokenToTry == null) {
                this.firstToken.pre = tokenToAdd;
                tokenToAdd.next = this.firstToken;
                this.firstToken = tokenToAdd;
            } else {
                tokenToAdd.next = curTokenToTry.next;
                curTokenToTry.next.pre = tokenToAdd;
                tokenToAdd.pre = curTokenToTry;
                curTokenToTry.next = tokenToAdd;
            }
        }
    }

    public Iterator iterator() {
        this.nextLinkedToken = this.firstToken;
        this.firstToken = null;
        return this;
    }

    public boolean hasNext() {
        return this.nextLinkedToken != null;
    }

    public Object next() {
        LinkedToken ret = this.nextLinkedToken;
        this.nextLinkedToken = this.nextLinkedToken.next;
        return ret;
    }

    public void remove() {
    }

    private static class LinkedToken
    extends Token
    implements Comparable {
        public LinkedToken pre;
        public LinkedToken next;

        public LinkedToken(String word, int begin, int end) {
            super(word, begin, end);
        }

        public int compareTo(Object obj) {
            LinkedToken that = (LinkedToken)obj;
            if (this.endOffset() > that.endOffset()) {
                return 1;
            }
            if (this.endOffset() == that.endOffset()) {
                return that.startOffset() - this.startOffset();
            }
            return -1;
        }
    }
}

