/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.analysis.analyzer.impl;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Properties;
import net.paoding.analysis.Constants;
import net.paoding.analysis.analyzer.impl.CompiledFileDictionaries;
import net.paoding.analysis.dictionary.Dictionary;
import net.paoding.analysis.dictionary.Word;
import net.paoding.analysis.knife.Dictionaries;
import net.paoding.analysis.knife.DictionariesCompiler;
import net.paoding.analysis.knife.Knife;

public class SortingDictionariesCompiler
implements DictionariesCompiler {
    public static final String VERSION = "2";

    public boolean shouldCompile(Properties p) throws Exception {
        String lastModifieds = p.getProperty("paoding.analysis.properties.lastModifieds");
        String files = p.getProperty("paoding.analysis.properties.files");
        String dicHome = p.getProperty("paoding.dic.home.absolute.path");
        File dicHomeFile = new File(dicHome);
        File compliedMetadataFile = new File(dicHomeFile, ".compiled/sorting/.metadata");
        if (compliedMetadataFile.exists() && compliedMetadataFile.isFile()) {
            Properties compiledProperties = new Properties();
            FileInputStream compiledPropertiesInput = new FileInputStream(compliedMetadataFile);
            compiledProperties.load(compiledPropertiesInput);
            ((InputStream)compiledPropertiesInput).close();
            String compiledLastModifieds = compiledProperties.getProperty("paoding.analysis.properties.lastModifieds");
            String compiledFiles = compiledProperties.getProperty("paoding.analysis.properties.files");
            String clazz = compiledProperties.getProperty("paoding.analysis.compiler.class");
            String version = compiledProperties.getProperty("paoding.analysis.compiler.version");
            if (lastModifieds.equals(compiledLastModifieds) && files.equals(compiledFiles) && this.getClass().getName().equalsIgnoreCase(clazz) && VERSION.equalsIgnoreCase(version)) {
                return false;
            }
        }
        return true;
    }

    public void compile(Dictionaries dictionaries, Knife knife, Properties p) throws Exception {
        String dicHome = p.getProperty("paoding.dic.home.absolute.path");
        String noiseCharactor = SortingDictionariesCompiler.getProperty(p, "paoding.dic.noise-charactor");
        String noiseWord = SortingDictionariesCompiler.getProperty(p, "paoding.dic.noise-word");
        String unit = SortingDictionariesCompiler.getProperty(p, "paoding.dic.unit");
        String confucianFamilyName = SortingDictionariesCompiler.getProperty(p, "paoding.dic.confucian-family-name");
        String combinatorics = SortingDictionariesCompiler.getProperty(p, "paoding.dic.for-combinatorics");
        String charsetName = SortingDictionariesCompiler.getProperty(p, "paoding.dic.charset");
        File dicHomeFile = new File(dicHome);
        File compiledDicHomeFile = new File(dicHomeFile, ".compiled/sorting");
        compiledDicHomeFile.mkdirs();
        Dictionary vocabularyDictionary = dictionaries.getVocabularyDictionary();
        File vocabularyFile = new File(compiledDicHomeFile, "vocabulary.dic.compiled");
        this.sortCompile(vocabularyDictionary, vocabularyFile, charsetName);
        Dictionary noiseCharactorsDictionary = dictionaries.getNoiseCharactorsDictionary();
        File noiseCharactorsDictionaryFile = new File(compiledDicHomeFile, noiseCharactor + ".dic.compiled");
        this.sortCompile(noiseCharactorsDictionary, noiseCharactorsDictionaryFile, charsetName);
        Dictionary noiseWordsDictionary = dictionaries.getNoiseWordsDictionary();
        File noiseWordsDictionaryFile = new File(compiledDicHomeFile, noiseWord + ".dic.compiled");
        this.sortCompile(noiseWordsDictionary, noiseWordsDictionaryFile, charsetName);
        Dictionary unitsDictionary = dictionaries.getUnitsDictionary();
        File unitsDictionaryFile = new File(compiledDicHomeFile, unit + ".dic.compiled");
        this.sortCompile(unitsDictionary, unitsDictionaryFile, charsetName);
        Dictionary confucianFamilyDictionary = dictionaries.getConfucianFamilyNamesDictionary();
        File confucianFamilyDictionaryFile = new File(compiledDicHomeFile, confucianFamilyName + ".dic.compiled");
        this.sortCompile(confucianFamilyDictionary, confucianFamilyDictionaryFile, charsetName);
        Dictionary combinatoricsDictionary = dictionaries.getCombinatoricsDictionary();
        File combinatoricsDictionaryFile = new File(compiledDicHomeFile, combinatorics + ".dic.compiled");
        this.sortCompile(combinatoricsDictionary, combinatoricsDictionaryFile, charsetName);
        File compliedMetadataFile = new File(dicHomeFile, ".compiled/sorting/.metadata");
        if (compliedMetadataFile.exists()) {
            compliedMetadataFile.delete();
        } else {
            compliedMetadataFile.getParentFile().mkdirs();
        }
        FileOutputStream compiledPropertiesOutput = new FileOutputStream(compliedMetadataFile);
        Properties compiledProperties = new Properties();
        String lastModifiedsKey = "paoding.analysis.properties.lastModifieds";
        String filesKey = "paoding.analysis.properties.files";
        compiledProperties.setProperty(lastModifiedsKey, p.getProperty(lastModifiedsKey));
        compiledProperties.setProperty(filesKey, p.getProperty(filesKey));
        compiledProperties.setProperty("paoding.analysis.compiler.class", this.getClass().getName());
        compiledProperties.setProperty("paoding.analysis.compiler.version", VERSION);
        compiledProperties.store(compiledPropertiesOutput, "dont edit it! this file was auto generated by paoding.");
        ((OutputStream)compiledPropertiesOutput).close();
        compliedMetadataFile.setReadOnly();
    }

    private void sortCompile(Dictionary dictionary, File dicFile, String charsetName) throws FileNotFoundException, IOException, UnsupportedEncodingException {
        int wordsSize = dictionary.size();
        if (dicFile.exists()) {
            dicFile.delete();
        }
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(dicFile), 16384);
        for (int i = 0; i < wordsSize; ++i) {
            Word word = dictionary.get(i);
            out.write(word.getText().getBytes(charsetName));
            if (word.getModifiers() != 0) {
                out.write("[m=".getBytes());
                out.write(String.valueOf(word.getModifiers()).getBytes());
                out.write(93);
            }
            out.write(13);
            out.write(10);
        }
        out.flush();
        out.close();
        dicFile.setReadOnly();
    }

    public Dictionaries readCompliedDictionaries(Properties p) {
        String dicHomeAbsolutePath = p.getProperty("paoding.dic.home.absolute.path");
        String noiseCharactor = SortingDictionariesCompiler.getProperty(p, "paoding.dic.noise-charactor");
        String noiseWord = SortingDictionariesCompiler.getProperty(p, "paoding.dic.noise-word");
        String unit = SortingDictionariesCompiler.getProperty(p, "paoding.dic.unit");
        String confucianFamilyName = SortingDictionariesCompiler.getProperty(p, "paoding.dic.confucian-family-name");
        String combinatorics = SortingDictionariesCompiler.getProperty(p, "paoding.dic.for-combinatorics");
        String charsetName = SortingDictionariesCompiler.getProperty(p, "paoding.dic.charset");
        return new CompiledFileDictionaries(dicHomeAbsolutePath + "/.compiled/sorting", noiseCharactor, noiseWord, unit, confucianFamilyName, combinatorics, charsetName);
    }

    private static String getProperty(Properties p, String name) {
        return Constants.getProperty(p, name);
    }
}

