/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.analysis.dictionary;

import net.paoding.analysis.dictionary.Dictionary;
import net.paoding.analysis.dictionary.Hit;
import net.paoding.analysis.dictionary.Word;

public class BinaryDictionary
implements Dictionary {
    private Word[] ascWords;
    private final int start;
    private final int end;
    private final int count;

    public BinaryDictionary(Word[] ascWords) {
        this(ascWords, 0, ascWords.length);
    }

    public BinaryDictionary(Word[] ascWords, int start, int end) {
        this.ascWords = ascWords;
        this.start = start;
        this.end = end;
        this.count = end - start;
    }

    public Word get(int index) {
        return this.ascWords[this.start + index];
    }

    public int size() {
        return this.count;
    }

    public Hit search(CharSequence input, int begin, int count) {
        int left = this.start;
        int right = this.end - 1;
        int pointer = 0;
        Word word = null;
        while (left <= right) {
            pointer = left + right >> 1;
            word = this.ascWords[pointer];
            int relation = BinaryDictionary.compare(input, begin, count, word);
            if (relation == 0) {
                int nextWordIndex = pointer + 1;
                if (nextWordIndex >= this.ascWords.length) {
                    return new Hit(pointer, word, null);
                }
                return new Hit(pointer, word, this.ascWords[nextWordIndex]);
            }
            if (relation < 0) {
                right = pointer - 1;
                continue;
            }
            left = pointer + 1;
        }
        if (left >= this.ascWords.length) {
            return Hit.UNDEFINED;
        }
        boolean asPrex = true;
        Word nextWord = this.ascWords[left];
        if (nextWord.length() < count) {
            asPrex = false;
        }
        int i = begin;
        for (int j = 0; asPrex && j < count; ++j) {
            if (input.charAt(i) != nextWord.charAt(j)) {
                asPrex = false;
            }
            ++i;
        }
        return asPrex ? new Hit(-1, null, nextWord) : Hit.UNDEFINED;
    }

    public static int compare(CharSequence one, int begin, int count, CharSequence theOther) {
        int i = begin;
        for (int j = 0; i < one.length() && j < Math.min(theOther.length(), count); ++i, ++j) {
            if (one.charAt(i) > theOther.charAt(j)) {
                return 1;
            }
            if (one.charAt(i) >= theOther.charAt(j)) continue;
            return -1;
        }
        return count - theOther.length();
    }
}

