/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.analysis.dictionary;

import java.util.HashMap;
import java.util.Map;
import net.paoding.analysis.dictionary.BinaryDictionary;
import net.paoding.analysis.dictionary.Dictionary;
import net.paoding.analysis.dictionary.Hit;
import net.paoding.analysis.dictionary.Word;

public class HashBinaryDictionary
implements Dictionary {
    private Word[] ascWords;
    private Map subs;
    private final int hashIndex;
    private final int start;
    private final int end;
    private final int count;
    protected static final int[] capacityCandiate = new int[]{16, 32, 64, 128, 256, 512, 1024, 2048, 4096, 10192};

    public HashBinaryDictionary(Word[] ascWords, int initialCapacity, float loadFactor) {
        this(ascWords, 0, 0, ascWords.length, initialCapacity, loadFactor);
    }

    public HashBinaryDictionary(Word[] ascWords, int hashIndex, int start, int end, int initialCapacity, float loadFactor) {
        this.ascWords = ascWords;
        this.start = start;
        this.end = end;
        this.count = end - start;
        this.hashIndex = hashIndex;
        this.subs = new HashMap(initialCapacity, loadFactor);
        this.createSubDictionaries();
    }

    protected void createSubDictionaries() {
        if (this.start >= this.ascWords.length) {
            return;
        }
        int beginIndex = this.start;
        char beginHashChar = this.getChar(this.ascWords[this.start], this.hashIndex);
        for (int endIndex = this.start + 1; endIndex < this.end; ++endIndex) {
            char endHashChar = this.getChar(this.ascWords[endIndex], this.hashIndex);
            if (endHashChar == beginHashChar) continue;
            this.addSubDictionary(beginHashChar, beginIndex, endIndex);
            beginIndex = endIndex;
            beginHashChar = endHashChar;
        }
        this.addSubDictionary(beginHashChar, beginIndex, this.end);
    }

    protected char getChar(CharSequence s, int index) {
        if (index >= s.length()) {
            return '\u0000';
        }
        return s.charAt(index);
    }

    protected void addSubDictionary(char hashChar, int beginIndex, int endIndex) {
        Dictionary subDic = this.createSubDictionary(this.ascWords, beginIndex, endIndex);
        SubDictionaryWrap subDicWrap = new SubDictionaryWrap(hashChar, subDic, beginIndex);
        this.subs.put(this.keyOf(hashChar), subDicWrap);
    }

    protected Dictionary createSubDictionary(Word[] ascWords, int beginIndex, int endIndex) {
        int count = endIndex - beginIndex;
        if (count < 16) {
            return new BinaryDictionary(ascWords, beginIndex, endIndex);
        }
        return new HashBinaryDictionary(ascWords, this.hashIndex + 1, beginIndex, endIndex, this.getCapacity(count), 0.75f);
    }

    protected int getCapacity(int count) {
        int capacity = -1;
        count <<= 2;
        count /= 3;
        ++count;
        for (int i = 0; i < capacityCandiate.length; ++i) {
            if (count > capacityCandiate[i]) continue;
            capacity = capacityCandiate[i];
            break;
        }
        if (capacity < 0) {
            capacity = capacityCandiate[capacityCandiate.length - 1];
        }
        return capacity;
    }

    public Word get(int index) {
        return this.ascWords[this.start + index];
    }

    public Hit search(CharSequence input, int begin, int count) {
        SubDictionaryWrap subDic = (SubDictionaryWrap)this.subs.get(this.keyOf(input.charAt(this.hashIndex + begin)));
        if (subDic == null) {
            return Hit.UNDEFINED;
        }
        Dictionary dic = subDic.dic;
        if (count == this.hashIndex + 1) {
            Word header = dic.get(0);
            if (header.length() == this.hashIndex + 1) {
                if (subDic.wordIndexOffset + 1 < this.ascWords.length) {
                    return new Hit(subDic.wordIndexOffset, header, this.ascWords[subDic.wordIndexOffset + 1]);
                }
                return new Hit(subDic.wordIndexOffset, header, null);
            }
            return new Hit(-1, null, header);
        }
        Hit word = dic.search(input, begin, count);
        if (word.isHit()) {
            int index = subDic.wordIndexOffset + word.getIndex();
            word.setIndex(index);
            if (word.getNext() == null && index < this.size()) {
                word.setNext(this.get(index + 1));
            }
        }
        return word;
    }

    public int size() {
        return this.count;
    }

    protected Object keyOf(char theChar) {
        return new Integer(theChar);
    }

    static class SubDictionaryWrap {
        char hashChar;
        Dictionary dic;
        int wordIndexOffset;

        public SubDictionaryWrap(char hashChar, Dictionary dic, int wordIndexOffset) {
            this.hashChar = hashChar;
            this.dic = dic;
            this.wordIndexOffset = wordIndexOffset;
        }
    }
}

