/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.analysis.dictionary;

import net.paoding.analysis.dictionary.Word;

public class Hit {
    public static final int UNCLOSED_INDEX = -1;
    public static final int UNDEFINED_INDEX = -2;
    public static final Hit UNDEFINED = new Hit(-2, null, null);
    private int index;
    private Word word;
    private Word next;

    public Hit(int index, Word word, Word next) {
        this.index = index;
        this.word = word;
        this.next = next;
    }

    public Word getWord() {
        return this.word;
    }

    public int getIndex() {
        return this.index;
    }

    public Word getNext() {
        return this.next;
    }

    public boolean isHit() {
        return this.index >= 0;
    }

    public boolean isUnclosed() {
        return -1 == this.index || this.next != null && this.next.length() >= this.word.length() && this.next.startsWith(this.word);
    }

    public boolean isUndefined() {
        return Hit.UNDEFINED.index == this.index;
    }

    void setIndex(int index) {
        this.index = index;
    }

    void setWord(Word key) {
        this.word = key;
    }

    void setNext(Word next) {
        this.next = next;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.word == null ? 0 : this.word.hashCode());
        result = 31 * result + this.index;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Hit other = (Hit)obj;
        if (this.word == null ? other.word != null : !this.word.equals(other.word)) {
            return false;
        }
        return this.index == other.index;
    }

    public String toString() {
        if (this.isUnclosed()) {
            return "[UNCLOSED]";
        }
        if (this.isUndefined()) {
            return "[UNDEFINED]";
        }
        return "[" + this.index + ']' + this.word;
    }
}

